/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.tcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public abstract class SocketTransceiver
implements Runnable {
    protected Socket socket;
    protected InetAddress addr;
    protected DataInputStream in;
    protected DataOutputStream out;
    private boolean runFlag;

    public SocketTransceiver(Socket socket) {
        this.socket = socket;
        this.addr = socket.getInetAddress();
    }

    public InetAddress getInetAddress() {
        return this.addr;
    }

    public void start() {
        this.runFlag = true;
        new Thread(this).start();
    }

    public void stop() {
        this.runFlag = false;
        try {
            this.socket.shutdownInput();
            this.in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean send(byte[] datas) {
        if (this.out != null) {
            try {
                this.out.write(datas);
                this.out.flush();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.in = new DataInputStream(this.socket.getInputStream());
            this.out = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.runFlag = false;
        }
        byte[] buffer = new byte[1024];
        while (this.runFlag) {
            try {
                int size = this.in.read(buffer);
                byte[] datas = new byte[size];
                System.arraycopy(buffer, 0, datas, 0, size);
                this.onReceive(this.addr, datas);
            }
            catch (Exception e) {
                this.runFlag = false;
            }
        }
        try {
            this.in.close();
            this.out.close();
            this.socket.close();
            this.in = null;
            this.out = null;
            this.socket = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.onDisconnect(this.addr);
    }

    public abstract void onReceive(InetAddress var1, byte[] var2);

    public abstract void onDisconnect(InetAddress var1);
}

