/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.tcp;

import com.icatch.panorama.tcp.SocketTransceiver;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class TcpClient
implements Runnable {
    private int port;
    private String hostIP;
    private boolean connect = false;
    private SocketTransceiver transceiver;
    private List<DataListener> mDataListeners = new ArrayList<DataListener>();
    private List<StatusListener> mStatusListeners = new ArrayList<StatusListener>();
    public static TcpClient mTcpClient;

    public static TcpClient getInstance() {
        if (mTcpClient == null) {
            mTcpClient = new TcpClient();
        }
        return mTcpClient;
    }

    public void connect(String hostIP, int port) {
        this.hostIP = hostIP;
        this.port = port;
        this.disconnect();
        new Thread(this).start();
    }

    @Override
    public void run() {
        try {
            Socket socket = new Socket(this.hostIP, this.port);
            this.transceiver = new SocketTransceiver(socket){

                @Override
                public void onReceive(InetAddress addr, byte[] datas) {
                    for (DataListener dataListener : TcpClient.this.mDataListeners) {
                        dataListener.onReceive(this, datas);
                    }
                }

                @Override
                public void onDisconnect(InetAddress addr) {
                    TcpClient.this.connect = false;
                    for (StatusListener statusListener : TcpClient.this.mStatusListeners) {
                        statusListener.onDisconnect(this);
                    }
                }
            };
            this.transceiver.start();
            this.connect = true;
            for (StatusListener statusListener : this.mStatusListeners) {
                statusListener.onConnect(this.transceiver);
            }
        }
        catch (Exception e) {
            for (StatusListener statusListener : this.mStatusListeners) {
                statusListener.onConnectFailed();
            }
        }
    }

    public void disconnect() {
        if (this.transceiver != null) {
            this.transceiver.stop();
            this.transceiver = null;
        }
    }

    public boolean isConnected() {
        return this.connect;
    }

    public void send(final byte[] datas) {
        if (this.isConnected()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    TcpClient.this.transceiver.send(datas);
                }
            }).start();
        }
    }

    public void registerDataListener(DataListener listener) {
        this.mDataListeners.add(listener);
    }

    public void unregisterDataListener(DataListener listener) {
        this.mDataListeners.remove(listener);
    }

    public void registerStatusListener(StatusListener listener) {
        this.mStatusListeners.add(listener);
    }

    public void unregisterStatusListener(StatusListener listener) {
        this.mStatusListeners.remove(listener);
    }

    public static interface DataListener {
        public void onReceive(SocketTransceiver var1, byte[] var2);
    }

    public static interface StatusListener {
        public void onDisconnect(SocketTransceiver var1);

        public void onConnect(SocketTransceiver var1);

        public void onConnectFailed();
    }
}

