/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.ExtendComponent;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.icatch.panorama.utils.ScaleTool;

public class DragImageView
extends ImageView {
    private Activity mActivity;
    private int screen_W;
    private int screen_H;
    private int bitmap_W;
    private int bitmap_H;
    private int MAX_W;
    private int MAX_H;
    private int MIN_W;
    private int MIN_H;
    private int current_Top;
    private int current_Right;
    private int current_Bottom;
    private int current_Left;
    private int start_x;
    private int start_y;
    private int current_x;
    private int current_y;
    private float beforeLenght;
    private float afterLenght;
    private float scale_temp;
    private boolean firstTouch = true;
    private int maxZoom = 3;
    private int minZoom = 1;
    private int originalRight = 0;
    private int originalLeft = 0;
    private int originalTop = 0;
    private int originalBottom = 0;
    private Bitmap bm;
    private MODE mode = MODE.NONE;
    private boolean isControl_V = false;
    private boolean isControl_H = false;

    public DragImageView(Context context) {
        super(context);
    }

    public void setmActivity(Activity mActivity) {
        this.mActivity = mActivity;
    }

    public void setScreen_W(int screen_W) {
        this.screen_W = screen_W;
    }

    public void setScreen_H(int screen_H) {
        this.screen_H = screen_H;
    }

    public DragImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setImageBitmap(Bitmap bm, int width, int heigth) {
        this.setImageBitmap(bm);
        this.bm = bm;
        if (bm == null) {
            return;
        }
        Rect drawFrameRect = ScaleTool.getScaledPosition(bm.getWidth(), bm.getHeight(), width, heigth);
        RelativeLayout.LayoutParams dragImageViewLayoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        dragImageViewLayoutParams.leftMargin = drawFrameRect.left;
        dragImageViewLayoutParams.rightMargin = drawFrameRect.left;
        dragImageViewLayoutParams.topMargin = drawFrameRect.top;
        dragImageViewLayoutParams.bottomMargin = drawFrameRect.top;
        this.setLayoutParams((ViewGroup.LayoutParams)dragImageViewLayoutParams);
        this.setScaleType(ImageView.ScaleType.FIT_XY);
        this.screen_W = width;
        this.screen_H = heigth;
    }

    public void setMaxAndMin() {
        this.bitmap_W = this.getWidth();
        this.bitmap_H = this.getHeight();
        this.MAX_W = this.bitmap_W * this.maxZoom;
        this.MAX_H = this.bitmap_H * this.maxZoom;
        this.MIN_W = this.bitmap_W * this.minZoom;
        this.MIN_H = this.bitmap_H * this.minZoom;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.getParent().requestDisallowInterceptTouchEvent(true);
        if (this.firstTouch) {
            this.firstTouch = false;
            this.setMaxAndMin();
            this.originalLeft = this.getLeft();
            this.originalRight = this.getRight();
            this.originalTop = this.getTop();
            this.originalBottom = this.getBottom();
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.onTouchDown(event);
                break;
            }
            case 5: {
                this.onPointerDown(event);
                break;
            }
            case 2: {
                this.onTouchMove(event);
                break;
            }
            case 1: {
                this.mode = MODE.NONE;
                break;
            }
            case 6: {
                this.mode = MODE.NONE;
            }
        }
        return true;
    }

    void onTouchDown(MotionEvent event) {
        this.mode = MODE.DRAG;
        this.current_x = (int)event.getRawX();
        this.current_y = (int)event.getRawY();
        this.start_x = (int)event.getX();
        this.start_y = this.current_y - this.getTop();
    }

    void onPointerDown(MotionEvent event) {
        if (event.getPointerCount() == 2) {
            this.mode = MODE.ZOOM;
            this.beforeLenght = this.getDistance(event);
        }
    }

    void onTouchMove(MotionEvent event) {
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        if (this.mode == MODE.DRAG) {
            left = this.current_x - this.start_x;
            right = this.current_x + this.getWidth() - this.start_x;
            top = this.current_y - this.start_y;
            bottom = this.current_y - this.start_y + this.getHeight();
            if (this.isControl_H) {
                if (left >= 0) {
                    left = 0;
                    right = this.getWidth();
                }
                if (right <= this.screen_W) {
                    left = this.screen_W - this.getWidth();
                    right = this.screen_W;
                }
            } else {
                left = this.getLeft();
                right = this.getRight();
            }
            if (this.isControl_V) {
                if (top >= 0) {
                    top = 0;
                    bottom = this.getHeight();
                }
                if (bottom <= this.screen_H) {
                    top = this.screen_H - this.getHeight();
                    bottom = this.screen_H;
                }
            } else {
                top = this.getTop();
                bottom = this.getBottom();
            }
            if (this.isControl_H) {
                if (this.getLeft() == 0 && event.getX() - (float)this.start_x > 0.0f || this.getRight() == this.screen_W && event.getX() - (float)this.start_x < 0.0f) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                }
            } else if (event.getX() - (float)this.start_x > 0.0f || event.getX() - (float)this.start_x < 0.0f) {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            }
            if (this.isControl_H || this.isControl_V) {
                this.setPosition(left, top, right, bottom);
            }
            this.current_x = (int)event.getRawX();
            this.current_y = (int)event.getRawY();
        } else if (this.mode == MODE.ZOOM) {
            this.afterLenght = this.getDistance(event);
            float gapLenght = this.afterLenght - this.beforeLenght;
            if (Math.abs(gapLenght) > 5.0f) {
                this.scale_temp = this.afterLenght / this.beforeLenght;
                this.setScale(this.scale_temp);
                this.beforeLenght = this.afterLenght;
            }
        }
    }

    float getDistance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private void setPosition(int left, int top, int right, int bottom) {
        this.layout(left, top, right, bottom);
    }

    void setScale(float scale) {
        int disX = (int)((float)this.getWidth() * Math.abs(1.0f - scale)) / 4;
        int disY = (int)((float)this.getHeight() * Math.abs(1.0f - scale)) / 4;
        if (scale > 1.0f && this.getWidth() <= this.MAX_W) {
            this.current_Left = this.getLeft() - disX;
            this.current_Top = this.getTop() - disY;
            this.current_Right = this.getRight() + disX;
            this.current_Bottom = this.getBottom() + disY;
            this.setFrame(this.current_Left, this.current_Top, this.current_Right, this.current_Bottom);
            this.isControl_V = this.current_Top <= 0 && this.current_Bottom >= this.screen_H;
            this.isControl_H = this.current_Left <= 0 && this.current_Right >= this.screen_W;
        } else if (scale < 1.0f && this.getWidth() >= this.MIN_W) {
            this.current_Left = this.getLeft() + disX;
            this.current_Top = this.getTop() + disY;
            this.current_Right = this.getRight() - disX;
            this.current_Bottom = this.getBottom() - disY;
            if (this.current_Right - this.current_Left < this.MIN_W) {
                this.current_Left = this.originalLeft;
                this.current_Right = this.originalRight;
            }
            if (this.current_Bottom - this.current_Top < this.MIN_H) {
                this.current_Top = this.originalTop;
                this.current_Bottom = this.originalBottom;
            }
            if (this.isControl_V && this.current_Top > 0) {
                this.current_Top = 0;
                this.current_Bottom = this.getBottom() - 2 * disY;
                if (this.current_Bottom < this.screen_H) {
                    this.current_Bottom = this.screen_H;
                    this.isControl_V = false;
                }
            }
            if (this.isControl_V && this.current_Bottom < this.screen_H) {
                this.current_Bottom = this.screen_H;
                this.current_Top = this.getTop() + 2 * disY;
                if (this.current_Top > 0) {
                    this.current_Top = 0;
                    this.isControl_V = false;
                }
            }
            if (this.isControl_H && this.current_Left >= 0) {
                this.current_Left = 0;
                this.current_Right = this.getRight() - 2 * disX;
                if (this.current_Right <= this.screen_W) {
                    this.current_Right = this.screen_W;
                    this.isControl_H = false;
                }
            }
            if (this.isControl_H && this.current_Right <= this.screen_W) {
                this.current_Right = this.screen_W;
                this.current_Left = this.getLeft() + 2 * disX;
                if (this.current_Left >= 0) {
                    this.current_Left = 0;
                    this.isControl_H = false;
                }
            }
            if (this.isControl_H || this.isControl_V) {
                this.setFrame(this.current_Left, this.current_Top, this.current_Right, this.current_Bottom);
            } else {
                this.setFrame(this.current_Left, this.current_Top, this.current_Right, this.current_Bottom);
            }
        }
    }

    public void recyleBitmap() {
        if (this.bm != null) {
            this.bm.recycle();
            this.bm = null;
        }
    }

    private static enum MODE {
        NONE,
        DRAG,
        ZOOM;

    }
}

