/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.ExtendComponent;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import com.icatch.panorama.R;

public class ProgressWheel
extends View {
    private int layoutHeight = 0;
    private int layoutWidth = 0;
    private int fullRadius = 100;
    private int circleRadius = 80;
    private int barLength = 60;
    private int barWidth = 20;
    private int rimWidth = 20;
    private int textSize = 20;
    private float contourSize = 0.0f;
    private int paddingTop = 5;
    private int paddingBottom = 5;
    private int paddingLeft = 5;
    private int paddingRight = 5;
    private int barColor = -1442840576;
    private int contourColor = -1442840576;
    private int circleColor = 0;
    private int rimColor = -1428300323;
    private int textColor = -16777216;
    private Paint barPaint = new Paint();
    private Paint circlePaint = new Paint();
    private Paint rimPaint = new Paint();
    private Paint textPaint = new Paint();
    private Paint contourPaint = new Paint();
    private RectF innerCircleBounds = new RectF();
    private RectF circleBounds = new RectF();
    private RectF circleOuterContour = new RectF();
    private RectF circleInnerContour = new RectF();
    private float spinSpeed = 2.0f;
    private int delayMillis = 10;
    private float progress = 0.0f;
    boolean isSpinning = false;
    private String text = "";
    private String[] splitText = new String[0];

    public ProgressWheel(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.parseAttributes(context.obtainStyledAttributes(attrs, R.styleable.ProgressWheel));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int size = 0;
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int widthWithoutPadding = width - this.getPaddingLeft() - this.getPaddingRight();
        int heightWithoutPadding = height - this.getPaddingTop() - this.getPaddingBottom();
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        size = heightMode != 0 && widthMode != 0 ? (widthWithoutPadding > heightWithoutPadding ? heightWithoutPadding : widthWithoutPadding) : Math.max(heightWithoutPadding, widthWithoutPadding);
        this.setMeasuredDimension(size + this.getPaddingLeft() + this.getPaddingRight(), size + this.getPaddingTop() + this.getPaddingBottom());
    }

    protected void onSizeChanged(int newWidth, int newHeight, int oldWidth, int oldHeight) {
        super.onSizeChanged(newWidth, newHeight, oldWidth, oldHeight);
        this.layoutWidth = newWidth;
        this.layoutHeight = newHeight;
        this.setupBounds();
        this.setupPaints();
        this.invalidate();
    }

    private void setupPaints() {
        this.barPaint.setColor(this.barColor);
        this.barPaint.setAntiAlias(true);
        this.barPaint.setStyle(Paint.Style.STROKE);
        this.barPaint.setStrokeWidth((float)this.barWidth);
        this.rimPaint.setColor(this.rimColor);
        this.rimPaint.setAntiAlias(true);
        this.rimPaint.setStyle(Paint.Style.STROKE);
        this.rimPaint.setStrokeWidth((float)this.rimWidth);
        this.circlePaint.setColor(this.circleColor);
        this.circlePaint.setAntiAlias(true);
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.textPaint.setColor(this.textColor);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setTextSize((float)this.textSize);
        this.contourPaint.setColor(this.contourColor);
        this.contourPaint.setAntiAlias(true);
        this.contourPaint.setStyle(Paint.Style.STROKE);
        this.contourPaint.setStrokeWidth(this.contourSize);
    }

    private void setupBounds() {
        int minValue = Math.min(this.layoutWidth, this.layoutHeight);
        int xOffset = this.layoutWidth - minValue;
        int yOffset = this.layoutHeight - minValue;
        this.paddingTop = this.getPaddingTop() + yOffset / 2;
        this.paddingBottom = this.getPaddingBottom() + yOffset / 2;
        this.paddingLeft = this.getPaddingLeft() + xOffset / 2;
        this.paddingRight = this.getPaddingRight() + xOffset / 2;
        int width = this.getWidth();
        int height = this.getHeight();
        this.innerCircleBounds = new RectF((float)this.paddingLeft + 1.5f * (float)this.barWidth, (float)this.paddingTop + 1.5f * (float)this.barWidth, (float)(width - this.paddingRight) - 1.5f * (float)this.barWidth, (float)(height - this.paddingBottom) - 1.5f * (float)this.barWidth);
        this.circleBounds = new RectF((float)(this.paddingLeft + this.barWidth), (float)(this.paddingTop + this.barWidth), (float)(width - this.paddingRight - this.barWidth), (float)(height - this.paddingBottom - this.barWidth));
        this.circleInnerContour = new RectF(this.circleBounds.left + (float)this.rimWidth / 2.0f + this.contourSize / 2.0f, this.circleBounds.top + (float)this.rimWidth / 2.0f + this.contourSize / 2.0f, this.circleBounds.right - (float)this.rimWidth / 2.0f - this.contourSize / 2.0f, this.circleBounds.bottom - (float)this.rimWidth / 2.0f - this.contourSize / 2.0f);
        this.circleOuterContour = new RectF(this.circleBounds.left - (float)this.rimWidth / 2.0f - this.contourSize / 2.0f, this.circleBounds.top - (float)this.rimWidth / 2.0f - this.contourSize / 2.0f, this.circleBounds.right + (float)this.rimWidth / 2.0f + this.contourSize / 2.0f, this.circleBounds.bottom + (float)this.rimWidth / 2.0f + this.contourSize / 2.0f);
        this.fullRadius = (width - this.paddingRight - this.barWidth) / 2;
        this.circleRadius = this.fullRadius - this.barWidth + 1;
    }

    private void parseAttributes(TypedArray a) {
        this.barWidth = (int)a.getDimension(R.styleable.ProgressWheel_wl_barWidth, (float)this.barWidth);
        this.rimWidth = (int)a.getDimension(R.styleable.ProgressWheel_wl_rimWidth, (float)this.rimWidth);
        this.spinSpeed = (int)a.getDimension(R.styleable.ProgressWheel_wl_spinSpeed, this.spinSpeed);
        this.barLength = (int)a.getDimension(R.styleable.ProgressWheel_wl_barLengthP, (float)this.barLength);
        this.delayMillis = a.getInteger(R.styleable.ProgressWheel_wl_delayMillis, this.delayMillis);
        if (this.delayMillis < 0) {
            this.delayMillis = 10;
        }
        if (a.hasValue(R.styleable.ProgressWheel_wl_text)) {
            this.setText(a.getString(R.styleable.ProgressWheel_wl_text));
        }
        this.barColor = a.getColor(R.styleable.ProgressWheel_wl_barColor, this.barColor);
        this.textColor = a.getColor(R.styleable.ProgressWheel_wl_textColor, this.textColor);
        this.rimColor = a.getColor(R.styleable.ProgressWheel_wl_rimColor, this.rimColor);
        this.circleColor = a.getColor(R.styleable.ProgressWheel_wl_circleColor, this.circleColor);
        this.contourColor = a.getColor(R.styleable.ProgressWheel_wl_contourColor, this.contourColor);
        this.textSize = (int)a.getDimension(R.styleable.ProgressWheel_wl_textSize, (float)this.textSize);
        this.contourSize = a.getDimension(R.styleable.ProgressWheel_wl_contourSize, this.contourSize);
        a.recycle();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawArc(this.innerCircleBounds, 360.0f, 360.0f, false, this.circlePaint);
        canvas.drawArc(this.circleBounds, 360.0f, 360.0f, false, this.rimPaint);
        canvas.drawArc(this.circleOuterContour, 360.0f, 360.0f, false, this.contourPaint);
        if (this.isSpinning) {
            canvas.drawArc(this.circleBounds, this.progress - 90.0f, (float)this.barLength, false, this.barPaint);
        } else {
            canvas.drawArc(this.circleBounds, -90.0f, this.progress, false, this.barPaint);
        }
        float textHeight = this.textPaint.descent() - this.textPaint.ascent();
        float verticalTextOffset = textHeight / 2.0f - this.textPaint.descent();
        for (String line : this.splitText) {
            float horizontalTextOffset = this.textPaint.measureText(line) / 2.0f;
            canvas.drawText(line, (float)(this.getWidth() / 2) - horizontalTextOffset, (float)(this.getHeight() / 2) + verticalTextOffset, this.textPaint);
        }
        if (this.isSpinning) {
            this.scheduleRedraw();
        }
    }

    private void scheduleRedraw() {
        this.progress += this.spinSpeed;
        if (this.progress > 360.0f) {
            this.progress = 0.0f;
        }
        this.postInvalidateDelayed(this.delayMillis);
    }

    public boolean isSpinning() {
        return this.isSpinning;
    }

    public void resetCount() {
        this.progress = 0.0f;
        this.setText("0%");
        this.invalidate();
    }

    public void stopSpinning() {
        this.isSpinning = false;
        this.progress = 0.0f;
        this.postInvalidate();
    }

    public void startSpinning() {
        this.isSpinning = true;
        this.postInvalidate();
    }

    public void incrementProgress() {
        this.incrementProgress(1);
    }

    public void incrementProgress(int amount) {
        this.isSpinning = false;
        this.progress += (float)amount;
        if (this.progress > 360.0f) {
            this.progress %= 360.0f;
        }
        this.postInvalidate();
    }

    public void setProgress(int i) {
        this.isSpinning = false;
        this.progress = i;
        this.postInvalidate();
    }

    public void setText(String text) {
        this.text = text;
        this.splitText = this.text.split("\n");
    }

    public int getCircleRadius() {
        return this.circleRadius;
    }

    public void setCircleRadius(int circleRadius) {
        this.circleRadius = circleRadius;
    }

    public int getBarLength() {
        return this.barLength;
    }

    public void setBarLength(int barLength) {
        this.barLength = barLength;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(int barWidth) {
        this.barWidth = barWidth;
        if (this.barPaint != null) {
            this.barPaint.setStrokeWidth((float)this.barWidth);
        }
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
        if (this.textPaint != null) {
            this.textPaint.setTextSize((float)this.textSize);
        }
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
    }

    public int getBarColor() {
        return this.barColor;
    }

    public void setBarColor(int barColor) {
        this.barColor = barColor;
        if (this.barPaint != null) {
            this.barPaint.setColor(this.barColor);
        }
    }

    public int getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(int circleColor) {
        this.circleColor = circleColor;
        if (this.circlePaint != null) {
            this.circlePaint.setColor(this.circleColor);
        }
    }

    public int getRimColor() {
        return this.rimColor;
    }

    public void setRimColor(int rimColor) {
        this.rimColor = rimColor;
        if (this.rimPaint != null) {
            this.rimPaint.setColor(this.rimColor);
        }
    }

    public Shader getRimShader() {
        return this.rimPaint.getShader();
    }

    public void setRimShader(Shader shader) {
        this.rimPaint.setShader(shader);
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        if (this.textPaint != null) {
            this.textPaint.setColor(this.textColor);
        }
    }

    public float getSpinSpeed() {
        return this.spinSpeed;
    }

    public void setSpinSpeed(float spinSpeed) {
        this.spinSpeed = spinSpeed;
    }

    public int getRimWidth() {
        return this.rimWidth;
    }

    public void setRimWidth(int rimWidth) {
        this.rimWidth = rimWidth;
        if (this.rimPaint != null) {
            this.rimPaint.setStrokeWidth((float)this.rimWidth);
        }
    }

    public int getDelayMillis() {
        return this.delayMillis;
    }

    public void setDelayMillis(int delayMillis) {
        this.delayMillis = delayMillis;
    }

    public int getContourColor() {
        return this.contourColor;
    }

    public void setContourColor(int contourColor) {
        this.contourColor = contourColor;
        if (this.contourPaint != null) {
            this.contourPaint.setColor(this.contourColor);
        }
    }

    public float getContourSize() {
        return this.contourSize;
    }

    public void setContourSize(float contourSize) {
        this.contourSize = contourSize;
        if (this.contourPaint != null) {
            this.contourPaint.setStrokeWidth(this.contourSize);
        }
    }

    public int getProgress() {
        return (int)this.progress;
    }
}

