/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.ExtendComponent;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.icatch.panorama.R;

public class RoundAngleImageView
extends ImageView {
    private Paint paint;
    private int roundWidth = 5;
    private int roundHeight = 5;
    private Paint paint2;

    public RoundAngleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    public RoundAngleImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RoundAngleImageView(Context context) {
        super(context);
        this.init(context, null);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RoundAngleImageView);
            this.roundWidth = a.getDimensionPixelSize(R.styleable.RoundAngleImageView_roundWidth, this.roundWidth);
            this.roundHeight = a.getDimensionPixelSize(R.styleable.RoundAngleImageView_roundHeight, this.roundHeight);
            a.recycle();
        } else {
            float density = context.getResources().getDisplayMetrics().density;
            this.roundWidth = (int)((float)this.roundWidth * density);
            this.roundHeight = (int)((float)this.roundHeight * density);
        }
        this.paint = new Paint();
        this.paint.setColor(-1);
        this.paint.setAntiAlias(true);
        this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        this.paint2 = new Paint();
        this.paint2.setXfermode(null);
    }

    public void draw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = new Canvas(bitmap);
        super.draw(canvas2);
        this.drawLiftUp(canvas2);
        this.drawRightUp(canvas2);
        this.drawLiftDown(canvas2);
        this.drawRightDown(canvas2);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.paint2);
        bitmap.recycle();
    }

    private void drawLiftUp(Canvas canvas) {
        Path path = new Path();
        path.moveTo(0.0f, (float)this.roundHeight);
        path.lineTo(0.0f, 0.0f);
        path.lineTo((float)this.roundWidth, 0.0f);
        path.arcTo(new RectF(0.0f, 0.0f, (float)(this.roundWidth * 2), (float)(this.roundHeight * 2)), -90.0f, -90.0f);
        path.close();
        canvas.drawPath(path, this.paint);
    }

    private void drawLiftDown(Canvas canvas) {
        Path path = new Path();
        path.moveTo(0.0f, (float)(this.getHeight() - this.roundHeight));
        path.lineTo(0.0f, (float)this.getHeight());
        path.lineTo((float)this.roundWidth, (float)this.getHeight());
        path.arcTo(new RectF(0.0f, (float)(this.getHeight() - this.roundHeight * 2), (float)(0 + this.roundWidth * 2), (float)this.getHeight()), 90.0f, 90.0f);
        path.close();
        canvas.drawPath(path, this.paint);
    }

    private void drawRightDown(Canvas canvas) {
        Path path = new Path();
        path.moveTo((float)(this.getWidth() - this.roundWidth), (float)this.getHeight());
        path.lineTo((float)this.getWidth(), (float)this.getHeight());
        path.lineTo((float)this.getWidth(), (float)(this.getHeight() - this.roundHeight));
        path.arcTo(new RectF((float)(this.getWidth() - this.roundWidth * 2), (float)(this.getHeight() - this.roundHeight * 2), (float)this.getWidth(), (float)this.getHeight()), 0.0f, 90.0f);
        path.close();
        canvas.drawPath(path, this.paint);
    }

    private void drawRightUp(Canvas canvas) {
        Path path = new Path();
        path.moveTo((float)this.getWidth(), (float)this.roundHeight);
        path.lineTo((float)this.getWidth(), 0.0f);
        path.lineTo((float)(this.getWidth() - this.roundWidth), 0.0f);
        path.arcTo(new RectF((float)(this.getWidth() - this.roundWidth * 2), 0.0f, (float)this.getWidth(), (float)(0 + this.roundHeight * 2)), -90.0f, 90.0f);
        path.close();
        canvas.drawPath(path, this.paint);
    }
}

