/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.ExtendComponent;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.R;
import java.util.Timer;
import java.util.TimerTask;

public class ZoomView
extends RelativeLayout {
    private static final String TAG = ZoomView.class.getSimpleName();
    public static float MAX_VALUE;
    public static float MIN_VALUE;
    private static int zoomGrained;
    private final ImageButton zoomIn;
    private final ImageButton zoomOut;
    private final SeekBar zoomBar;
    private final TextView zoomRateText;
    private static final int DISPLAY_DURATION = 5000;
    private Timer timer;
    public boolean firstCreate = true;
    private OnSeekBarChangeListener onSeekBarChangeListener;

    public ZoomView(Context context, AttributeSet attrs) {
        super(context, attrs);
        View zoomView = LayoutInflater.from((Context)context).inflate(R.layout.zoombar_view, (ViewGroup)this, true);
        this.zoomIn = (ImageButton)zoomView.findViewById(R.id.zoom_in);
        this.zoomOut = (ImageButton)zoomView.findViewById(R.id.zoom_out);
        this.zoomBar = (SeekBar)zoomView.findViewById(R.id.zoomBar);
        this.zoomRateText = (TextView)zoomView.findViewById(R.id.zoom_rate);
        this.post(new Runnable(){

            @Override
            public void run() {
                ZoomView.this.startDisplay();
            }
        });
    }

    public void setZoomInOnclickListener(View.OnClickListener onclickListener) {
        this.zoomIn.setOnClickListener(onclickListener);
    }

    public void setZoomOutOnclickListener(View.OnClickListener onclickListener) {
        this.zoomOut.setOnClickListener(onclickListener);
    }

    public void setOnSeekBarChangeListener(final OnSeekBarChangeListener onSeekBarChangeListener) {
        this.onSeekBarChangeListener = onSeekBarChangeListener;
        this.zoomBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                onSeekBarChangeListener.onProgressChanged(ZoomView.this, (float)progress * 1.0f / (float)zoomGrained + MIN_VALUE, fromUser);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                onSeekBarChangeListener.onStartTrackingTouch(ZoomView.this);
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                onSeekBarChangeListener.onStopTrackingTouch(ZoomView.this);
            }
        });
    }

    private void updateZoomRateText(float zoomRate) {
        AppLog.i(TAG, "updateZoomRateText zoomRate =" + zoomRate);
        this.zoomRateText.setText((CharSequence)("x " + zoomRate));
    }

    public void updateZoomBarValue(int value) {
        AppLog.i(TAG, "updateZoomBarValue value =" + value);
        this.updateZoomRateText((float)value / 1.0f);
    }

    public void updateZoomBarValue(float value) {
        AppLog.i(TAG, "updateZoomBarValue value =" + value);
        this.updateZoomRateText(value / 1.0f);
    }

    public void setProgress(float value) {
        AppLog.i(TAG, "setProgress value =" + value);
        this.zoomBar.setProgress((int)((value - MIN_VALUE) * (float)zoomGrained));
    }

    public void setMinValue(int minValue) {
        MIN_VALUE = minValue;
    }

    public void setMinValue(float minValue) {
        MIN_VALUE = minValue;
    }

    public void setMaxValue(float maxValue) {
        MAX_VALUE = maxValue;
        this.zoomBar.setMax((int)((maxValue - MIN_VALUE) * (float)zoomGrained));
    }

    public void setMaxValue(int maxValue) {
        MAX_VALUE = maxValue;
        this.zoomBar.setMax(maxValue);
    }

    public float getProgress() {
        return (float)this.zoomBar.getProgress() * 1.0f / (float)zoomGrained + MIN_VALUE;
    }

    public void startDisplay() {
        if (this.firstCreate) {
            this.firstCreate = false;
            return;
        }
        if (!CameraManager.getInstance().getCurCamera().getCameraProperties().hasFuction(20502)) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                Handler handler = ZoomView.this.getHandler();
                if (handler != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            ZoomView.this.setVisibility(8);
                        }
                    });
                }
            }
        };
        this.timer.schedule(timerTask, 5000L);
        this.setVisibility(0);
    }

    static {
        zoomGrained = 10;
    }

    public static interface OnSeekBarChangeListener {
        public void onProgressChanged(ZoomView var1, float var2, boolean var3);

        public void onStartTrackingTouch(ZoomView var1);

        public void onStopTrackingTouch(ZoomView var1);
    }
}

