/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.Fragment;

import android.app.Activity;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.icatch.panorama.Listener.OnStatusChangedListener;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.Presenter.LocalMultiPbFragmentPresenter;
import com.icatch.panorama.R;
import com.icatch.panorama.data.Mode.OperationMode;
import com.icatch.panorama.data.entity.LocalPbItemInfo;
import com.icatch.panorama.data.type.FileType;
import com.icatch.panorama.ui.Interface.LocalMultiPbFragmentView;
import com.icatch.panorama.ui.adapter.LocalMultiPbWallListAdapter;
import java.util.List;

public class LocalMultiPbFragment
extends Fragment
implements LocalMultiPbFragmentView {
    private static final String TAG = LocalMultiPbFragment.class.getSimpleName();
    ListView listView;
    TextView headerView;
    TextView noContentTxv;
    FrameLayout multiPbPhotoListLayout;
    LocalMultiPbFragmentPresenter presenter;
    private OnStatusChangedListener modeChangedListener;
    private FileType fileType = FileType.FILE_PHOTO;
    private boolean isChoose;
    private int limit = 10;

    public static LocalMultiPbFragment newInstance(int param1) {
        LocalMultiPbFragment fragment = new LocalMultiPbFragment();
        Bundle args = new Bundle();
        args.putInt("FILE_TYPE", param1);
        fragment.setArguments(args);
        return fragment;
    }

    public static LocalMultiPbFragment newInstance(int param1, boolean isChoose, int limit) {
        LocalMultiPbFragment fragment = new LocalMultiPbFragment();
        Bundle args = new Bundle();
        args.putBoolean("isChoose", isChoose);
        args.putInt("FILE_TYPE", param1);
        args.putInt("limit", limit);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int fileTypeInt = 0;
        if (this.getArguments() != null) {
            fileTypeInt = this.getArguments().getInt("FILE_TYPE");
            this.isChoose = this.getArguments().getBoolean("isChoose");
            this.limit = this.getArguments().getInt("limit");
        }
        this.fileType = fileTypeInt == 0 ? FileType.FILE_VIDEO : FileType.FILE_PHOTO;
        AppLog.d(TAG, "onCreate fileType=" + fileTypeInt);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        AppLog.d(TAG, "MultiPbPhotoFragment onCreateView");
        View view = inflater.inflate(R.layout.fragment_multi_pb_photo, container, false);
        this.listView = (ListView)view.findViewById(R.id.multi_pb_photo_list_view);
        this.headerView = (TextView)view.findViewById(R.id.photo_wall_header);
        this.noContentTxv = (TextView)view.findViewById(R.id.no_content_txv);
        this.multiPbPhotoListLayout = (FrameLayout)view.findViewById(R.id.multi_pb_photo_list_layout);
        this.presenter = new LocalMultiPbFragmentPresenter((Activity)this.getActivity(), this.fileType);
        this.presenter.setView(this);
        this.presenter.setChoose(this.isChoose);
        this.listView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                LocalMultiPbFragment.this.presenter.listViewEnterEditMode(position);
                return true;
            }
        });
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (LocalMultiPbFragment.this.isChoose) {
                    if (LocalMultiPbFragment.this.presenter.getSelectedList().size() < LocalMultiPbFragment.this.limit) {
                        LocalMultiPbFragment.this.presenter.listViewSelectOrCancelOnce(position);
                    }
                } else {
                    LocalMultiPbFragment.this.presenter.listViewSelectOrCancelOnce(position);
                }
            }
        });
        return view;
    }

    public void onResume() {
        super.onResume();
        this.presenter.loadPhotoWall();
    }

    public void quitEditMode() {
        this.presenter.quitEditMode();
    }

    @Override
    public void setListViewVisibility(int visibility) {
        if (this.multiPbPhotoListLayout.getVisibility() != visibility) {
            this.multiPbPhotoListLayout.setVisibility(visibility);
        }
    }

    @Override
    public void setListViewAdapter(LocalMultiPbWallListAdapter photoWallListAdapter) {
        this.listView.setAdapter((ListAdapter)photoWallListAdapter);
    }

    @Override
    public void setListViewSelection(int position) {
        this.listView.setSelection(position);
    }

    @Override
    public void setListViewHeaderText(String headerText) {
        this.headerView.setText((CharSequence)headerText);
    }

    @Override
    public View listViewFindViewWithTag(int tag) {
        return this.listView.findViewWithTag((Object)tag);
    }

    @Override
    public void notifyChangeMultiPbMode(OperationMode operationMode) {
        if (this.modeChangedListener != null) {
            this.modeChangedListener.onChangeOperationMode(operationMode);
        }
    }

    @Override
    public void setPhotoSelectNumText(int selectNum) {
        if (this.modeChangedListener != null) {
            this.modeChangedListener.onSelectedItemsCountChanged(selectNum);
        }
    }

    @Override
    public void setNoContentTxvVisibility(int visibility) {
        int v = this.noContentTxv.getVisibility();
        if (v != visibility) {
            this.noContentTxv.setVisibility(visibility);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Log.i((String)"1122", (String)"MultiPbPhotoFragment onConfigurationChanged");
        this.presenter.refreshPhotoWall();
    }

    public void refreshPhotoWall() {
        this.presenter.refreshPhotoWall();
    }

    public void setOperationListener(OnStatusChangedListener modeChangedListener) {
        this.modeChangedListener = modeChangedListener;
    }

    public void selectOrCancelAll(boolean isSelectAll) {
        this.presenter.selectOrCancelAll(isSelectAll);
    }

    public List<LocalPbItemInfo> getSelectedList() {
        return this.presenter.getSelectedList();
    }

    public void clealAsytaskList() {
    }
}

