/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.Fragment;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import com.icatch.panorama.Listener.OnStatusChangedListener;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.R;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import com.icatch.panorama.data.Mode.OperationMode;
import com.icatch.panorama.data.entity.LocalPbItemInfo;
import com.icatch.panorama.data.type.FileType;
import com.icatch.panorama.ui.ExtendComponent.MyProgressDialog;
import com.icatch.panorama.ui.ExtendComponent.MyToast;
import com.icatch.panorama.ui.activity.LocalPhotoPbActivity;
import com.icatch.panorama.ui.activity.PanoListActivity;
import com.icatch.panorama.ui.adapter.LocalMultiPbWallListAdapter;
import com.icatch.panorama.utils.FileOpertion.FileTools;
import com.icatch.panorama.utils.FileOpertion.MFileTools;
import com.icatch.panorama.utils.PanoramaTools;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PanoListFragment
extends Fragment {
    ImageButton selectBtn;
    ImageButton deleteBtn;
    TextView selectedNumTxv;
    LinearLayout multiPbEditLayout;
    private static final String TAG = PanoListActivity.class.getSimpleName();
    private Activity activity;
    OperationMode curOperationMode = OperationMode.MODE_BROWSE;
    private boolean curSelectAll = false;
    ListView listView;
    TextView headerView;
    TextView noContentTxv;
    FrameLayout multiPbPhotoListLayout;
    private OnStatusChangedListener modeChangedListener;
    private LocalMultiPbWallListAdapter photoWallListAdapter;
    private static int section = 1;
    private Map<String, Integer> sectionMap = new HashMap<String, Integer>();
    private List<LocalPbItemInfo> pbItemInfoList;
    private Handler handler;

    public static PanoListFragment newInstance() {
        PanoListFragment fragment = new PanoListFragment();
        Bundle args = new Bundle();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            // empty if block
        }
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        if (isVisibleToUser && this.listView != null) {
            this.loadPhotoWall();
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_pano_list, container, false);
        this.selectBtn = (ImageButton)view.findViewById(R.id.action_select);
        this.deleteBtn = (ImageButton)view.findViewById(R.id.action_delete);
        this.selectedNumTxv = (TextView)view.findViewById(R.id.info_selected_num);
        this.multiPbEditLayout = (LinearLayout)view.findViewById(R.id.edit_layout);
        this.activity = this.getActivity();
        this.selectBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PanoListFragment.this.selectOrCancel();
            }
        });
        this.deleteBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                final List<LocalPbItemInfo> selected = PanoListFragment.this.getSelectedList();
                if (selected == null || selected.isEmpty()) {
                    MyToast.show((Context)PanoListFragment.this.activity, "\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u7167\u7247");
                    return;
                }
                AlertDialog dialog = new AlertDialog.Builder((Context)PanoListFragment.this.activity).setTitle((CharSequence)"\u63d0\u793a").setMessage((CharSequence)"\u786e\u8ba4\u5220\u9664\u5417\uff1f").setNegativeButton((CharSequence)"\u53d6\u6d88", null).setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        MyProgressDialog.showProgressDialog((Context)PanoListFragment.this.activity, "\u5220\u9664\u4e2d...");
                        new Thread(new DeleteThread(selected)).start();
                    }
                }).create();
                dialog.setCanceledOnTouchOutside(false);
                dialog.show();
            }
        });
        this.init(view);
        this.loadPhotoWall();
        return view;
    }

    public void onResume() {
        super.onResume();
        this.loadPhotoWall();
    }

    public void setSelectNumText(String text) {
        this.selectedNumTxv.setText((CharSequence)text);
    }

    public void setSelectBtnVisibility(int visibility) {
        this.selectBtn.setVisibility(visibility);
    }

    public void setSelectBtnIcon(int icon) {
        this.selectBtn.setImageResource(icon);
    }

    public void setSelectNumTextVisibility(int visibility) {
        this.selectedNumTxv.setVisibility(visibility);
    }

    public void setEditLayoutVisibility(int visibility) {
        this.multiPbEditLayout.setVisibility(visibility);
    }

    private void init(View view) {
        this.listView = (ListView)view.findViewById(R.id.multi_pb_photo_list_view);
        this.headerView = (TextView)view.findViewById(R.id.photo_wall_header);
        this.noContentTxv = (TextView)view.findViewById(R.id.no_content_txv);
        this.multiPbPhotoListLayout = (FrameLayout)view.findViewById(R.id.multi_pb_photo_list_layout);
        this.handler = new Handler();
        this.listView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                PanoListFragment.this.listViewEnterEditMode(position);
                return true;
            }
        });
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                PanoListFragment.this.listViewSelectOrCancelOnce(position);
            }
        });
        this.setOperationListener(new OnStatusChangedListener(){

            @Override
            public void onChangeOperationMode(OperationMode operationMode) {
                PanoListFragment.this.curOperationMode = operationMode;
                if (PanoListFragment.this.curOperationMode == OperationMode.MODE_BROWSE) {
                    PanoListFragment.this.setSelectBtnVisibility(8);
                    PanoListFragment.this.setSelectNumTextVisibility(8);
                    PanoListFragment.this.setEditLayoutVisibility(8);
                    PanoListFragment.this.setSelectBtnIcon(R.drawable.ic_select_all_white_24dp);
                    PanoListFragment.this.curSelectAll = false;
                    AppLog.d(TAG, "multiPbPhotoFragment quit EditMode");
                } else {
                    PanoListFragment.this.setSelectBtnVisibility(0);
                    PanoListFragment.this.setSelectNumTextVisibility(0);
                    PanoListFragment.this.setEditLayoutVisibility(0);
                }
            }

            @Override
            public void onSelectedItemsCountChanged(int SelectedNum) {
                String temp = "\u5df2\u9009\u62e9(" + SelectedNum + ")";
                PanoListFragment.this.setSelectNumText(temp);
            }
        });
    }

    public void reback() {
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            if (this.getActivity() != null) {
                this.getActivity().finish();
            }
        } else if (this.curOperationMode == OperationMode.MODE_EDIT) {
            this.curOperationMode = OperationMode.MODE_BROWSE;
            this.quitEditMode();
        }
    }

    public void selectOrCancel() {
        if (this.curSelectAll) {
            this.setSelectBtnIcon(R.drawable.ic_select_all_white_24dp);
            this.curSelectAll = false;
        } else {
            this.setSelectBtnIcon(R.drawable.ic_unselected_white_24dp);
            this.curSelectAll = true;
        }
        if (AppInfo.currentViewpagerPosition == 0) {
            this.selectOrCancelAll(this.curSelectAll);
        }
    }

    public void setListViewVisibility(int visibility) {
        if (this.multiPbPhotoListLayout.getVisibility() != visibility) {
            this.multiPbPhotoListLayout.setVisibility(visibility);
        }
    }

    public void setListViewAdapter(LocalMultiPbWallListAdapter photoWallListAdapter) {
        this.listView.setAdapter((ListAdapter)photoWallListAdapter);
    }

    public void setListViewSelection(int position) {
        this.listView.setSelection(position);
    }

    public void setListViewHeaderText(String headerText) {
        this.headerView.setText((CharSequence)headerText);
    }

    public View listViewFindViewWithTag(int tag) {
        return this.listView.findViewWithTag((Object)tag);
    }

    public void notifyChangeMultiPbMode(OperationMode operationMode) {
        if (this.modeChangedListener != null) {
            this.modeChangedListener.onChangeOperationMode(operationMode);
        }
    }

    public void setPhotoSelectNumText(int selectNum) {
        if (this.modeChangedListener != null) {
            this.modeChangedListener.onSelectedItemsCountChanged(selectNum);
        }
    }

    public void setNoContentTxvVisibility(int visibility) {
        int v = this.noContentTxv.getVisibility();
        if (v != visibility) {
            this.noContentTxv.setVisibility(visibility);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Log.i((String)"1122", (String)"MultiPbPhotoFragment onConfigurationChanged");
        this.refreshPhotoWall();
    }

    public void setOperationListener(OnStatusChangedListener modeChangedListener) {
        this.modeChangedListener = modeChangedListener;
    }

    public List<LocalPbItemInfo> getPhotoInfoList() {
        ArrayList<LocalPbItemInfo> photoList = new ArrayList<LocalPbItemInfo>();
        String filePath = Environment.getExternalStorageDirectory().toString() + "/DCIM/720Cam/720photo/";
        List<File> fileList = MFileTools.getPhotosOrderByDate(filePath);
        if (fileList == null || fileList.size() <= 0) {
            return null;
        }
        AppLog.i(TAG, "fileList size=" + fileList.size());
        for (int ii = 0; ii < fileList.size(); ++ii) {
            LocalPbItemInfo mGridItem;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            long time = fileList.get(ii).lastModified();
            String fileDate = format.format(new Date(time));
            if (!this.sectionMap.containsKey(fileDate)) {
                this.sectionMap.put(fileDate, section);
                mGridItem = new LocalPbItemInfo(fileList.get(ii), section, PanoramaTools.isPanorama(fileList.get(ii).getPath()));
                photoList.add(mGridItem);
                ++section;
                continue;
            }
            mGridItem = new LocalPbItemInfo(fileList.get(ii), this.sectionMap.get(fileDate), PanoramaTools.isPanorama(fileList.get(ii).getPath()));
            photoList.add(mGridItem);
        }
        GlobalInfo.getInstance().setLocalPhotoList(photoList);
        return photoList;
    }

    public void loadPhotoWall() {
        MyProgressDialog.showProgressDialog((Context)this.activity, "Loading...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                PanoListFragment.this.pbItemInfoList = PanoListFragment.this.getPhotoInfoList();
                if (PanoListFragment.this.pbItemInfoList == null || PanoListFragment.this.pbItemInfoList.size() <= 0) {
                    PanoListFragment.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            MyProgressDialog.closeProgressDialog();
                            PanoListFragment.this.setListViewVisibility(8);
                            PanoListFragment.this.setNoContentTxvVisibility(0);
                        }
                    });
                } else {
                    PanoListFragment.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            PanoListFragment.this.setNoContentTxvVisibility(8);
                            PanoListFragment.this.setAdaper();
                            MyProgressDialog.closeProgressDialog();
                        }
                    });
                }
            }
        }).start();
    }

    public void setAdaper() {
        this.curOperationMode = OperationMode.MODE_BROWSE;
        if (this.pbItemInfoList != null && this.pbItemInfoList.size() > 0) {
            String fileDate = this.pbItemInfoList.get(0).getFileDate();
            AppLog.d(TAG, "fileDate=" + fileDate);
            this.setListViewHeaderText(fileDate);
        }
        boolean curWidth = false;
        this.setListViewVisibility(0);
        this.photoWallListAdapter = new LocalMultiPbWallListAdapter((Context)this.activity, this.pbItemInfoList, FileType.FILE_PHOTO);
        this.setListViewAdapter(this.photoWallListAdapter);
    }

    public void refreshPhotoWall() {
        this.pbItemInfoList = this.getPhotoInfoList();
        if (this.pbItemInfoList == null || this.pbItemInfoList.size() <= 0) {
            this.setListViewVisibility(8);
            this.setNoContentTxvVisibility(0);
        } else {
            this.setNoContentTxvVisibility(8);
            this.setAdaper();
        }
    }

    public void listViewEnterEditMode(int position) {
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            this.curOperationMode = OperationMode.MODE_EDIT;
            this.notifyChangeMultiPbMode(this.curOperationMode);
            this.photoWallListAdapter.setOperationMode(this.curOperationMode);
            this.photoWallListAdapter.changeSelectionState(position);
            this.setPhotoSelectNumText(this.photoWallListAdapter.getSelectedCount());
            AppLog.i(TAG, "gridViewSelectOrCancelOnce curOperationMode=" + (Object)((Object)this.curOperationMode));
        }
    }

    private void enterEditMode() {
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            this.curOperationMode = OperationMode.MODE_EDIT;
            this.notifyChangeMultiPbMode(this.curOperationMode);
        }
    }

    public void quitEditMode() {
        this.curOperationMode = OperationMode.MODE_BROWSE;
        this.notifyChangeMultiPbMode(this.curOperationMode);
        this.photoWallListAdapter.quitEditMode();
    }

    public void listViewSelectOrCancelOnce(int position) {
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            Intent intent = new Intent();
            intent.putExtra("curfilePosition", position);
            intent.setClass((Context)this.activity, LocalPhotoPbActivity.class);
            this.activity.startActivity(intent);
        } else {
            this.photoWallListAdapter.changeSelectionState(position);
            this.setPhotoSelectNumText(this.photoWallListAdapter.getSelectedCount());
        }
    }

    public void selectOrCancelAll(boolean isSelectAll) {
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            return;
        }
        if (isSelectAll) {
            this.photoWallListAdapter.selectAllItems();
            int selectNum = this.photoWallListAdapter.getSelectedCount();
            this.setPhotoSelectNumText(selectNum);
        } else {
            this.photoWallListAdapter.cancelAllSelections();
            int selectNum = this.photoWallListAdapter.getSelectedCount();
            this.setPhotoSelectNumText(selectNum);
        }
    }

    public List<LocalPbItemInfo> getSelectedList() {
        return this.photoWallListAdapter.getSelectedList();
    }

    private class DeleteThread
    implements Runnable {
        private List<LocalPbItemInfo> stitchPaths;

        public DeleteThread(List<LocalPbItemInfo> stitchPaths) {
            this.stitchPaths = stitchPaths;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.stitchPaths.size(); ++i) {
                String path = this.stitchPaths.get((int)i).file.getPath();
                File file = new File(path);
                FileTools.deleteFile(file);
                final int index = i;
                PanoListFragment.this.pbItemInfoList.remove(this.stitchPaths.get(i));
                PanoListFragment.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        PanoListFragment.this.setListViewVisibility(0);
                        PanoListFragment.this.photoWallListAdapter.notifyDataSetChanged();
                        if (index == DeleteThread.this.stitchPaths.size() - 1) {
                            PanoListFragment.this.photoWallListAdapter.cancelAllSelections();
                            int selectNum = PanoListFragment.this.photoWallListAdapter.getSelectedCount();
                            PanoListFragment.this.setPhotoSelectNumText(selectNum);
                            MyProgressDialog.closeProgressDialog();
                            MyToast.show((Context)PanoListFragment.this.activity, "\u5220\u9664\u5b8c\u6bd5");
                        }
                    }
                });
            }
        }
    }
}

