/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.Fragment;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import com.icatch.panorama.Listener.OnStatusChangedListener;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.R;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.Mode.OperationMode;
import com.icatch.panorama.data.entity.LocalPbItemInfo;
import com.icatch.panorama.data.type.FileType;
import com.icatch.panorama.ui.ExtendComponent.MyProgressDialog;
import com.icatch.panorama.ui.ExtendComponent.MyToast;
import com.icatch.panorama.ui.activity.SaveThumbActivity;
import com.icatch.panorama.ui.activity.ThumbListActivity;
import com.icatch.panorama.ui.adapter.LocalMultiPbWallListAdapter;
import com.icatch.panorama.utils.FileOpertion.FileOper;
import com.icatch.panorama.utils.FileOpertion.FileTools;
import com.icatch.panorama.utils.MediaRefresh;
import com.icatch.panorama.utils.PanoramaTools;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jni.pano.JniTools;

public class ThumbListFragment
extends Fragment {
    ImageButton selectBtn;
    ImageButton deleteBtn;
    TextView selectedNumTxv;
    LinearLayout multiPbEditLayout;
    private static final String TAG = ThumbListActivity.class.getSimpleName();
    private Activity activity;
    OperationMode curOperationMode = OperationMode.MODE_BROWSE;
    private boolean curSelectAll = false;
    ListView listView;
    TextView headerView;
    TextView noContentTxv;
    FrameLayout multiPbPhotoListLayout;
    private OnStatusChangedListener modeChangedListener;
    private LocalMultiPbWallListAdapter photoWallListAdapter;
    private static int section = 1;
    private Map<String, Integer> sectionMap = new HashMap<String, Integer>();
    private List<LocalPbItemInfo> pbItemInfoList;
    private Handler handler;
    private boolean isCompose;

    public static ThumbListFragment newInstance() {
        ThumbListFragment fragment = new ThumbListFragment();
        Bundle args = new Bundle();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            // empty if block
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_thumb_list, container, false);
        this.selectBtn = (ImageButton)view.findViewById(R.id.action_select);
        this.deleteBtn = (ImageButton)view.findViewById(R.id.action_delete);
        this.selectedNumTxv = (TextView)view.findViewById(R.id.info_selected_num);
        this.multiPbEditLayout = (LinearLayout)view.findViewById(R.id.edit_layout);
        this.activity = this.getActivity();
        this.selectBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ThumbListFragment.this.selectOrCancel();
            }
        });
        this.deleteBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                final List<LocalPbItemInfo> selected = ThumbListFragment.this.getSelectedList();
                if (selected == null || selected.isEmpty()) {
                    MyToast.show((Context)ThumbListFragment.this.activity, "\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u7167\u7247");
                    return;
                }
                AlertDialog dialog = new AlertDialog.Builder((Context)ThumbListFragment.this.activity).setTitle((CharSequence)"\u63d0\u793a").setMessage((CharSequence)"\u786e\u8ba4\u5220\u9664\u5417\uff1f").setNegativeButton((CharSequence)"\u53d6\u6d88", null).setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        MyProgressDialog.showProgressDialog((Context)ThumbListFragment.this.activity, "\u5220\u9664\u4e2d...");
                        new Thread(new DeleteThread(selected)).start();
                    }
                }).create();
                dialog.setCanceledOnTouchOutside(false);
                dialog.show();
            }
        });
        this.selectedNumTxv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                final List<LocalPbItemInfo> selected = ThumbListFragment.this.getSelectedList();
                if (selected == null || selected.isEmpty()) {
                    MyToast.show((Context)ThumbListFragment.this.activity, "\u8bf7\u9009\u62e9\u9700\u8981\u5408\u6210\u7684\u7167\u7247");
                    return;
                }
                AlertDialog dialog = new AlertDialog.Builder((Context)ThumbListFragment.this.activity).setTitle((CharSequence)"\u63d0\u793a").setMessage((CharSequence)"\u6279\u91cf\u5408\u6210\u9700\u8981\u7b49\u5f85\u6bd4\u8f83\u4e45\u7684\u65f6\u95f4\uff0c\u8bf7\u4e0d\u8981\u8ba9APP\u8fdb\u5165\u540e\u53f0\uff0c\u8bf7\u95ee\u662f\u5426\u7ee7\u7eed\uff1f").setNegativeButton((CharSequence)"\u53d6\u6d88", null).setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        MyProgressDialog.showProgressDialog((Context)ThumbListFragment.this.activity, "\u6279\u91cf\u5408\u6210\u4e2d...");
                        new Thread(new DownloadThread(selected)).start();
                    }
                }).create();
                dialog.setCanceledOnTouchOutside(false);
                dialog.show();
            }
        });
        this.init(view);
        return view;
    }

    public void onResume() {
        super.onResume();
        if (!this.isCompose) {
            this.loadPhotoWall();
        }
    }

    public void setSelectNumText(String text) {
        this.selectedNumTxv.setText((CharSequence)text);
    }

    public void setSelectBtnVisibility(int visibility) {
        this.selectBtn.setVisibility(visibility);
    }

    public void setSelectBtnIcon(int icon) {
        this.selectBtn.setImageResource(icon);
    }

    public void setSelectNumTextVisibility(int visibility) {
        this.selectedNumTxv.setVisibility(visibility);
    }

    public void setEditLayoutVisibility(int visibility) {
        this.multiPbEditLayout.setVisibility(visibility);
    }

    private void init(View view) {
        this.listView = (ListView)view.findViewById(R.id.multi_pb_photo_list_view);
        this.headerView = (TextView)view.findViewById(R.id.photo_wall_header);
        this.noContentTxv = (TextView)view.findViewById(R.id.no_content_txv);
        this.multiPbPhotoListLayout = (FrameLayout)view.findViewById(R.id.multi_pb_photo_list_layout);
        this.handler = new Handler();
        this.listView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                ThumbListFragment.this.listViewEnterEditMode(position);
                return true;
            }
        });
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                ThumbListFragment.this.listViewSelectOrCancelOnce(position);
            }
        });
        this.setOperationListener(new OnStatusChangedListener(){

            @Override
            public void onChangeOperationMode(OperationMode operationMode) {
                ThumbListFragment.this.curOperationMode = operationMode;
                if (ThumbListFragment.this.curOperationMode == OperationMode.MODE_BROWSE) {
                    ThumbListFragment.this.setSelectBtnVisibility(8);
                    ThumbListFragment.this.setSelectNumTextVisibility(8);
                    ThumbListFragment.this.setEditLayoutVisibility(8);
                    ThumbListFragment.this.setSelectBtnIcon(R.drawable.ic_select_all_white_24dp);
                    ThumbListFragment.this.curSelectAll = false;
                    AppLog.d(TAG, "multiPbPhotoFragment quit EditMode");
                } else {
                    ThumbListFragment.this.setSelectBtnVisibility(0);
                    ThumbListFragment.this.setSelectNumTextVisibility(0);
                    ThumbListFragment.this.setEditLayoutVisibility(0);
                }
            }

            @Override
            public void onSelectedItemsCountChanged(int SelectedNum) {
                String temp = "\u6279\u91cf\u5408\u6210(" + SelectedNum + ")";
                ThumbListFragment.this.setSelectNumText(temp);
            }
        });
    }

    public void reback() {
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            if (this.getActivity() != null) {
                this.getActivity().finish();
            }
        } else if (this.curOperationMode == OperationMode.MODE_EDIT) {
            this.curOperationMode = OperationMode.MODE_BROWSE;
            this.quitEditMode();
        }
    }

    public void selectOrCancel() {
        if (this.curSelectAll) {
            this.setSelectBtnIcon(R.drawable.ic_select_all_white_24dp);
            this.curSelectAll = false;
        } else {
            this.setSelectBtnIcon(R.drawable.ic_unselected_white_24dp);
            this.curSelectAll = true;
        }
        if (AppInfo.currentViewpagerPosition == 0) {
            this.selectOrCancelAll(this.curSelectAll);
        }
    }

    public void setListViewVisibility(int visibility) {
        if (this.multiPbPhotoListLayout.getVisibility() != visibility) {
            this.multiPbPhotoListLayout.setVisibility(visibility);
        }
    }

    public void setListViewAdapter(LocalMultiPbWallListAdapter photoWallListAdapter) {
        this.listView.setAdapter((ListAdapter)photoWallListAdapter);
    }

    public void setListViewSelection(int position) {
        this.listView.setSelection(position);
    }

    public void setListViewHeaderText(String headerText) {
        this.headerView.setText((CharSequence)headerText);
    }

    public View listViewFindViewWithTag(int tag) {
        return this.listView.findViewWithTag((Object)tag);
    }

    public void notifyChangeMultiPbMode(OperationMode operationMode) {
        if (this.modeChangedListener != null) {
            this.modeChangedListener.onChangeOperationMode(operationMode);
        }
    }

    public void setPhotoSelectNumText(int selectNum) {
        if (this.modeChangedListener != null) {
            this.modeChangedListener.onSelectedItemsCountChanged(selectNum);
        }
    }

    public void setNoContentTxvVisibility(int visibility) {
        int v = this.noContentTxv.getVisibility();
        if (v != visibility) {
            this.noContentTxv.setVisibility(visibility);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Log.i((String)"1122", (String)"MultiPbPhotoFragment onConfigurationChanged");
        this.refreshPhotoWall();
    }

    public void setOperationListener(OnStatusChangedListener modeChangedListener) {
        this.modeChangedListener = modeChangedListener;
    }

    public List<LocalPbItemInfo> getPhotoInfoList() {
        ArrayList<LocalPbItemInfo> photoList = new ArrayList<LocalPbItemInfo>();
        String filePath = this.activity.getExternalCacheDir().getPath() + "/" + "pano";
        File file = new File(filePath);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return photoList;
        }
        List<File> folderList = Arrays.asList(fileArray);
        Collections.sort(folderList, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                long diff = f1.lastModified() - f2.lastModified();
                if (diff < 0L) {
                    return 1;
                }
                if (diff == 0L) {
                    return 0;
                }
                return -1;
            }

            @Override
            public boolean equals(Object obj) {
                return true;
            }
        });
        if (folderList == null || folderList.isEmpty()) {
            return photoList;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        for (File f : folderList) {
            File thumb = new File(f, "thumb.jpg");
            if (!thumb.exists()) continue;
            fileList.add(thumb);
        }
        for (int ii = 0; ii < fileList.size(); ++ii) {
            LocalPbItemInfo mGridItem;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            long time = ((File)fileList.get(ii)).lastModified();
            String fileDate = format.format(new Date(time));
            if (!this.sectionMap.containsKey(fileDate)) {
                this.sectionMap.put(fileDate, section);
                mGridItem = new LocalPbItemInfo((File)fileList.get(ii), section, PanoramaTools.isPanorama(((File)fileList.get(ii)).getPath()));
                photoList.add(mGridItem);
                ++section;
                continue;
            }
            mGridItem = new LocalPbItemInfo((File)fileList.get(ii), this.sectionMap.get(fileDate), PanoramaTools.isPanorama(((File)fileList.get(ii)).getPath()));
            photoList.add(mGridItem);
        }
        return photoList;
    }

    public void loadPhotoWall() {
        MyProgressDialog.showProgressDialog((Context)this.activity, "Loading...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                ThumbListFragment.this.pbItemInfoList = ThumbListFragment.this.getPhotoInfoList();
                if (ThumbListFragment.this.pbItemInfoList == null || ThumbListFragment.this.pbItemInfoList.size() <= 0) {
                    ThumbListFragment.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            MyProgressDialog.closeProgressDialog();
                            ThumbListFragment.this.setListViewVisibility(8);
                            ThumbListFragment.this.setNoContentTxvVisibility(0);
                        }
                    });
                } else {
                    ThumbListFragment.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            ThumbListFragment.this.setNoContentTxvVisibility(8);
                            ThumbListFragment.this.setAdapter();
                            MyProgressDialog.closeProgressDialog();
                        }
                    });
                }
            }
        }).start();
    }

    public void setAdapter() {
        this.curOperationMode = OperationMode.MODE_BROWSE;
        if (this.pbItemInfoList != null && this.pbItemInfoList.size() > 0) {
            String fileDate = this.pbItemInfoList.get(0).getFileDate();
            AppLog.d(TAG, "fileDate=" + fileDate);
            this.setListViewHeaderText(fileDate);
        }
        this.setListViewVisibility(0);
        this.photoWallListAdapter = new LocalMultiPbWallListAdapter((Context)this.activity, this.pbItemInfoList, FileType.FILE_PHOTO);
        this.setListViewAdapter(this.photoWallListAdapter);
    }

    public void refreshPhotoWall() {
        this.pbItemInfoList = this.getPhotoInfoList();
        if (this.pbItemInfoList == null || this.pbItemInfoList.size() <= 0) {
            this.setListViewVisibility(8);
            this.setNoContentTxvVisibility(0);
        } else {
            this.setNoContentTxvVisibility(8);
            this.setAdapter();
        }
    }

    public void listViewEnterEditMode(int position) {
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            this.curOperationMode = OperationMode.MODE_EDIT;
            this.notifyChangeMultiPbMode(this.curOperationMode);
            this.photoWallListAdapter.setOperationMode(this.curOperationMode);
            this.photoWallListAdapter.changeSelectionState(position);
            this.setPhotoSelectNumText(this.photoWallListAdapter.getSelectedCount());
            AppLog.i(TAG, "gridViewSelectOrCancelOnce curOperationMode=" + (Object)((Object)this.curOperationMode));
        }
    }

    public void quitEditMode() {
        this.curOperationMode = OperationMode.MODE_BROWSE;
        this.notifyChangeMultiPbMode(this.curOperationMode);
        this.photoWallListAdapter.quitEditMode();
    }

    public void listViewSelectOrCancelOnce(int position) {
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            Intent intent = new Intent();
            intent.putExtra("path", this.pbItemInfoList.get(position).getFilePath());
            intent.putExtra("formTemp", true);
            intent.setClass((Context)this.activity, SaveThumbActivity.class);
            this.activity.startActivity(intent);
        } else {
            this.photoWallListAdapter.changeSelectionState(position);
            this.setPhotoSelectNumText(this.photoWallListAdapter.getSelectedCount());
        }
    }

    public void selectOrCancelAll(boolean isSelectAll) {
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            return;
        }
        if (isSelectAll) {
            this.photoWallListAdapter.selectAllItems();
        } else {
            this.photoWallListAdapter.cancelAllSelections();
        }
        int selectNum = this.photoWallListAdapter.getSelectedCount();
        this.setPhotoSelectNumText(selectNum);
    }

    public List<LocalPbItemInfo> getSelectedList() {
        return this.photoWallListAdapter.getSelectedList();
    }

    private File saveFile(File oldFile, String newName) {
        if (TextUtils.isEmpty((CharSequence)newName)) {
            newName = "Pano";
        }
        Pattern pattern = Pattern.compile("[\\s\\\\/:\\*\\?\\\"<>\\|]");
        Matcher matcher = pattern.matcher(newName);
        newName = matcher.replaceAll("");
        String uniquePath = FileTools.chooseUniqueFilename(Environment.getExternalStorageDirectory().toString() + "/DCIM/720Cam/720photo/" + newName + ".jpg");
        File newFile = new File(uniquePath);
        oldFile.renameTo(newFile);
        MediaRefresh.scanFileAsync((Context)this.activity, newFile.getPath());
        return newFile;
    }

    private class DeleteThread
    implements Runnable {
        private List<LocalPbItemInfo> stitchPaths;

        public DeleteThread(List<LocalPbItemInfo> stitchPaths) {
            this.stitchPaths = stitchPaths;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.stitchPaths.size(); ++i) {
                String path = this.stitchPaths.get((int)i).file.getPath();
                File folder = new File(path).getParentFile();
                FileTools.deleteFile(folder);
                final int index = i;
                ThumbListFragment.this.pbItemInfoList.remove(this.stitchPaths.get(i));
                ThumbListFragment.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThumbListFragment.this.setListViewVisibility(0);
                        ThumbListFragment.this.photoWallListAdapter.notifyDataSetChanged();
                        if (index == DeleteThread.this.stitchPaths.size() - 1) {
                            ThumbListFragment.this.photoWallListAdapter.cancelAllSelections();
                            int selectNum = ThumbListFragment.this.photoWallListAdapter.getSelectedCount();
                            ThumbListFragment.this.setPhotoSelectNumText(selectNum);
                            MyProgressDialog.closeProgressDialog();
                            MyToast.show((Context)ThumbListFragment.this.activity, "\u5220\u9664\u5b8c\u6bd5");
                        }
                    }
                });
            }
        }
    }

    private class DownloadThread
    implements Runnable {
        private List<LocalPbItemInfo> stitchPaths;

        public DownloadThread(List<LocalPbItemInfo> stitchPaths) {
            this.stitchPaths = stitchPaths;
        }

        @Override
        public void run() {
            ThumbListFragment.this.isCompose = true;
            for (int i = 0; i < this.stitchPaths.size(); ++i) {
                File saveFile;
                String path = this.stitchPaths.get((int)i).file.getPath();
                File folder = new File(path).getParentFile();
                File tmpFolder = new File(folder, "temp");
                File[] paths = tmpFolder.listFiles();
                ArrayList<String> cachePaths = new ArrayList<String>();
                for (File f : paths) {
                    cachePaths.add(f.getPath());
                }
                Collections.sort(cachePaths);
                File panoFile = new File(folder.getParentFile(), "pano.jpg");
                ArrayList<String> merges = new ArrayList<String>();
                JniTools.mixMultipleImgs((String)cachePaths.get(0), 3);
                merges.add(((String)cachePaths.get(0)).replace("SA", "WL"));
                merges.add(((String)cachePaths.get(1)).replace("SA", "WL"));
                merges.add(((String)cachePaths.get(2)).replace("SA", "WL"));
                merges.add(((String)cachePaths.get(3)).replace("SA", "WL"));
                File binFile = new File(folder, "stitch.bin");
                JniTools.setProcessResolution(8000, 4000);
                String[] images = merges.toArray(new String[merges.size()]);
                JniTools.setInputPaths(images);
                JniTools.setOutputPath(panoFile.getPath());
                JniTools.stitch(binFile.getPath());
                JniTools.saveFinalImg();
                File txtFile = new File(folder, "name.txt");
                String photoName = FileOper.getTxtContent(txtFile.getPath());
                if (TextUtils.isEmpty((CharSequence)photoName)) {
                    photoName = folder.getName();
                }
                if (!(saveFile = ThumbListFragment.this.saveFile(panoFile, photoName)).exists()) continue;
                FileTools.deleteFile(folder);
                final int index = i;
                ThumbListFragment.this.pbItemInfoList.remove(this.stitchPaths.get(i));
                ThumbListFragment.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ThumbListFragment.this.setListViewVisibility(0);
                        ThumbListFragment.this.photoWallListAdapter.notifyDataSetChanged();
                        if (index == DownloadThread.this.stitchPaths.size() - 1) {
                            ThumbListFragment.this.photoWallListAdapter.cancelAllSelections();
                            int selectNum = ThumbListFragment.this.photoWallListAdapter.getSelectedCount();
                            ThumbListFragment.this.setPhotoSelectNumText(selectNum);
                            MyProgressDialog.closeProgressDialog();
                            MyToast.show((Context)ThumbListFragment.this.activity, "\u6279\u91cf\u5408\u6210\u5b8c\u6bd5");
                        }
                    }
                });
            }
            ThumbListFragment.this.isCompose = false;
        }
    }
}

