/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.activity;

import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.google.android.material.tabs.TabLayout;
import com.icatch.panorama.R;
import com.icatch.panorama.ui.Fragment.PanoListFragment;
import com.icatch.panorama.ui.Fragment.ThumbListFragment;
import java.util.ArrayList;
import java.util.List;

public class AlbumActivity
extends AppCompatActivity {
    private ImageView btn_back;
    private TabLayout tl;
    private ViewPager vp;
    private List<Fragment> fragments = new ArrayList<Fragment>();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().addFlags(128);
        this.setContentView(R.layout.activity_album);
        this.initView();
        this.fragments.add(PanoListFragment.newInstance());
        this.fragments.add(ThumbListFragment.newInstance());
    }

    private void initView() {
        this.btn_back = (ImageView)this.findViewById(R.id.btn_back);
        this.tl = (TabLayout)this.findViewById(R.id.tl);
        this.vp = (ViewPager)this.findViewById(R.id.vp);
        this.vp.setAdapter((PagerAdapter)new FragmentAdapter(this.getSupportFragmentManager()));
        this.tl.setupWithViewPager(this.vp);
        this.btn_back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlbumActivity.this.reback();
            }
        });
    }

    private void reback() {
        if (this.vp.getCurrentItem() == 0) {
            PanoListFragment fragment = (PanoListFragment)this.fragments.get(this.vp.getCurrentItem());
            fragment.reback();
        } else if (this.vp.getCurrentItem() == 1) {
            ThumbListFragment fragment = (ThumbListFragment)this.fragments.get(this.vp.getCurrentItem());
            fragment.reback();
        } else {
            this.finish();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 3: {
                break;
            }
            case 4: {
                this.reback();
                break;
            }
            default: {
                return super.onKeyDown(keyCode, event);
            }
        }
        return true;
    }

    public class FragmentAdapter
    extends FragmentPagerAdapter {
        private String[] mTitles;

        public FragmentAdapter(FragmentManager fm) {
            super(fm);
            this.mTitles = new String[]{"\u5df2\u5408\u6210", "\u5f85\u5408\u6210"};
        }

        public Fragment getItem(int position) {
            return (Fragment)AlbumActivity.this.fragments.get(position);
        }

        public int getCount() {
            return this.mTitles.length;
        }

        public CharSequence getPageTitle(int position) {
            return this.mTitles[position];
        }
    }
}

