/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.icatch.panorama.Listener.OnStatusChangedListener;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.Presenter.LocalMultiPbPresenter;
import com.icatch.panorama.R;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.Mode.OperationMode;
import com.icatch.panorama.data.entity.LocalPbItemInfo;
import com.icatch.panorama.ui.Fragment.LocalMultiPbFragment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ChoosePanoActivity
extends AppCompatActivity {
    ImageButton selectBtn;
    ImageButton deleteBtn;
    ImageButton shareBtn;
    TextView selectedNumTxv;
    LinearLayout multiPbEditLayout;
    private static final String TAG = LocalMultiPbPresenter.class.getSimpleName();
    private Activity activity;
    LocalMultiPbFragment multiPbPhotoFragment;
    OperationMode curOperationMode = OperationMode.MODE_BROWSE;
    private boolean curSelectAll = false;
    private int limit = 10;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_choose_pano);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.limit = this.getIntent().getIntExtra("limit", 10);
        this.selectBtn = (ImageButton)this.findViewById(R.id.action_select);
        this.deleteBtn = (ImageButton)this.findViewById(R.id.action_delete);
        this.shareBtn = (ImageButton)this.findViewById(R.id.action_share);
        this.selectedNumTxv = (TextView)this.findViewById(R.id.info_selected_num);
        this.multiPbEditLayout = (LinearLayout)this.findViewById(R.id.edit_layout);
        this.selectedNumTxv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChoosePanoActivity.this.multiPbPhotoFragment.getSelectedList().size() > 0) {
                    Intent intent = new Intent();
                    List<LocalPbItemInfo> infos = ChoosePanoActivity.this.multiPbPhotoFragment.getSelectedList();
                    ArrayList<String> paths = new ArrayList<String>();
                    for (LocalPbItemInfo lb : infos) {
                        paths.add(lb.getFilePath());
                    }
                    intent.putExtra("EXTRA_RESULT_SELECTION", (Serializable)paths);
                    ChoosePanoActivity.this.setResult(-1, intent);
                    ChoosePanoActivity.this.finish();
                }
            }
        });
        this.activity = this;
        this.selectBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChoosePanoActivity.this.selectOrCancel();
            }
        });
        this.deleteBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        this.init();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.reback();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 3: {
                Log.d((String)"AppStart", (String)"home");
                break;
            }
            case 4: {
                Log.d((String)"AppStart", (String)"back");
                this.reback();
                break;
            }
            default: {
                return super.onKeyDown(keyCode, event);
            }
        }
        return true;
    }

    public void setSelectNumText(String text) {
        this.selectedNumTxv.setText((CharSequence)text);
    }

    public void setSelectBtnVisibility(int visibility) {
        this.selectBtn.setVisibility(4);
    }

    public void setSelectBtnIcon(int icon) {
        this.selectBtn.setImageResource(icon);
    }

    public void setSelectNumTextVisibility(int visibility) {
        this.selectedNumTxv.setVisibility(visibility);
    }

    public void setEditLayoutVisibility(int visibility) {
        this.multiPbEditLayout.setVisibility(visibility);
    }

    private void init() {
        if (this.multiPbPhotoFragment == null) {
            this.multiPbPhotoFragment = LocalMultiPbFragment.newInstance(1, true, this.limit);
        }
        this.multiPbPhotoFragment.setOperationListener(new OnStatusChangedListener(){

            @Override
            public void onChangeOperationMode(OperationMode operationMode) {
                ChoosePanoActivity.this.curOperationMode = operationMode;
                if (ChoosePanoActivity.this.curOperationMode == OperationMode.MODE_BROWSE) {
                    ChoosePanoActivity.this.setSelectBtnVisibility(8);
                    ChoosePanoActivity.this.setSelectNumTextVisibility(8);
                    ChoosePanoActivity.this.setEditLayoutVisibility(8);
                    ChoosePanoActivity.this.setSelectBtnIcon(R.drawable.ic_select_all_white_24dp);
                    ChoosePanoActivity.this.curSelectAll = false;
                    AppLog.d(TAG, "multiPbPhotoFragment quit EditMode");
                } else {
                    ChoosePanoActivity.this.setSelectBtnVisibility(0);
                    ChoosePanoActivity.this.setSelectNumTextVisibility(0);
                    ChoosePanoActivity.this.setEditLayoutVisibility(0);
                }
            }

            @Override
            public void onSelectedItemsCountChanged(int SelectedNum) {
                String temp = "\u786e\u8ba4\u9009\u62e9(" + SelectedNum + ")";
                ChoosePanoActivity.this.setSelectNumText(temp);
            }
        });
        this.getSupportFragmentManager().beginTransaction().add(R.id.f_p, (Fragment)this.multiPbPhotoFragment).commit();
    }

    public void reback() {
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            this.setResult(0);
            this.activity.finish();
        } else if (this.curOperationMode == OperationMode.MODE_EDIT) {
            this.curOperationMode = OperationMode.MODE_BROWSE;
            if (AppInfo.currentViewpagerPosition == 0) {
                this.multiPbPhotoFragment.quitEditMode();
            }
        }
    }

    public void selectOrCancel() {
        if (this.curSelectAll) {
            this.setSelectBtnIcon(R.drawable.ic_select_all_white_24dp);
            this.curSelectAll = false;
        } else {
            this.setSelectBtnIcon(R.drawable.ic_unselected_white_24dp);
            this.curSelectAll = true;
        }
        if (AppInfo.currentViewpagerPosition == 0) {
            this.multiPbPhotoFragment.selectOrCancelAll(this.curSelectAll);
        }
    }
}

