/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.activity;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.icatch.panorama.Application.PanoramaSDK;
import com.icatch.panorama.CameraConstants;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.R;
import com.icatch.panorama.SdkApi.FileOperation;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.SystemInfo.MWifiManager;
import com.icatch.panorama.data.SystemInfo.SystemInfo;
import com.icatch.panorama.ui.ExtendComponent.MyToast;
import com.icatch.panorama.ui.activity.SavePhotoActivity;
import com.icatch.panorama.ui.activity.ViewPhotoActivity;
import com.icatch.panorama.ui.view.IndicatorUtils;
import com.icatch.panorama.utils.FileOpertion.FileOper;
import com.icatch.panorama.utils.FileOpertion.FileTools;
import com.icatch.panorama.utils.MediaRefresh;
import com.icatch.panorama.utils.PhotoEnhance;
import com.icatch.panorama.utils.VoiceUtils;
import com.icatchtek.reliant.customer.type.ICatchFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jni.pano.JniTools;

public class CompositeV35Activity
extends AppCompatActivity {
    private ExecutorService executor;
    private Future<Object> future;
    private Handler handler = new Handler();
    private Context activity;
    private FileOperation fileOperation = CameraManager.getInstance().getCurCamera().getFileOperation();
    private List<ICatchFile> downFileList = new ArrayList<ICatchFile>();
    private String path;
    private PhotoEnhance mEnhance;
    private boolean isFromSDK;
    private int amount = CameraConstants.PICTURE_AMOUNT;
    private long calcTime;
    private List<ICatchFile> remoteFiles;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setFlags(128, 128);
        this.setContentView(R.layout.activity_composite);
        this.activity = this;
        this.isFromSDK = !TextUtils.isEmpty((CharSequence)PanoramaSDK.getInstance().getOutputFolder());
        this.remoteFiles = this.fileOperation.getFileList(1);
        if (this.remoteFiles.size() < this.amount) {
            Toast.makeText((Context)this, (CharSequence)"\u62cd\u6444\u6570\u91cf\u9519\u8bef!", (int)0).show();
            this.finish();
            return;
        }
        long size = 0L;
        for (int i = 0; i < this.amount; ++i) {
            size += this.remoteFiles.get(i).getFileSize();
            this.downFileList.add(this.remoteFiles.get(i));
        }
        if (SystemInfo.getSDFreeSize() < size) {
            MyToast.show((Context)this, R.string.text_sd_card_memory_shortage);
            this.finish();
        } else {
            this.executor = Executors.newSingleThreadExecutor();
            this.future = this.executor.submit(new DownloadThread(), null);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public int getBright(Bitmap bm) {
        if (bm == null) {
            return -1;
        }
        int width = bm.getWidth();
        int height = bm.getHeight();
        int count = 0;
        int bright = 0;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                ++count;
                int localTemp = bm.getPixel(i, j);
                int r = (localTemp | 0xFF00FFFF) >> 16 & 0xFF;
                int g = (localTemp | 0xFFFF00FF) >> 8 & 0xFF;
                int b = (localTemp | 0xFFFFFF00) & 0xFF;
                bright = (int)((double)bright + 0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
            }
        }
        return bright / count;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void saveBitmap(File f, Bitmap bm) {
        if (f.exists()) {
            f.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(f);
            bm.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class DownloadThread
    implements Runnable {
        private DownloadThread() {
        }

        @Override
        public void run() {
            AppInfo.isDownloading = true;
            if (!Environment.getExternalStorageState().equals("mounted")) {
                CompositeV35Activity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        MyToast.show(CompositeV35Activity.this.activity, R.string.message_download_failed);
                        CompositeV35Activity.this.finish();
                    }
                });
                return;
            }
            CompositeV35Activity.this.path = CompositeV35Activity.this.activity.getExternalCacheDir().getPath();
            CompositeV35Activity.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    VoiceUtils.getVoiceUtils((Context)CompositeV35Activity.this).continuePlay("\u5168\u666f\u626b\u63cf.mp3");
                }
            });
            ArrayList<String> cachePaths = new ArrayList<String>();
            FileOper.createDirectory(CompositeV35Activity.this.path);
            File cacheFolder = new File(CompositeV35Activity.this.path);
            File[] cacheFiles = cacheFolder.listFiles();
            if (cacheFiles != null && cacheFiles.length > 0) {
                for (File cf : cacheFiles) {
                    cf.delete();
                }
            }
            for (ICatchFile ic : CompositeV35Activity.this.downFileList) {
                String fileName = ic.getFileName();
                String cachePath = FileTools.chooseUniqueFilename(CompositeV35Activity.this.path + "/" + fileName);
                cachePaths.add(cachePath);
                boolean temp = CompositeV35Activity.this.fileOperation.downloadFile(ic, cachePath);
                if (temp) continue;
                CompositeV35Activity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        MyToast.show(CompositeV35Activity.this.activity, R.string.message_download_failed);
                        CompositeV35Activity.this.finish();
                    }
                });
                AppInfo.isDownloading = false;
                return;
            }
            JniTools.setStitchVersion(0);
            AppInfo.isDownloading = false;
            for (ICatchFile ic : CompositeV35Activity.this.remoteFiles) {
                boolean fileName = CompositeV35Activity.this.fileOperation.deleteFile(ic);
            }
            final File panoFile = new File(CompositeV35Activity.this.path, "pano.jpg");
            if (panoFile.exists()) {
                panoFile.delete();
            }
            if (cachePaths.size() == CompositeV35Activity.this.amount) {
                Collections.sort(cachePaths);
                CompositeV35Activity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        VoiceUtils.getVoiceUtils((Context)CompositeV35Activity.this).continuePlay("\u5168\u666f\u626b\u63cf.mp3");
                    }
                });
                ArrayList<String> merges = new ArrayList<String>();
                if (IndicatorUtils.getCurrentSelectedIndex() != 0) {
                    JniTools.mixMultipleImgs((String)cachePaths.get(0), 3);
                    merges.add(((String)cachePaths.get(0)).replace("SA", "WL"));
                    merges.add(((String)cachePaths.get(1)).replace("SA", "WL"));
                    merges.add(((String)cachePaths.get(2)).replace("SA", "WL"));
                    merges.add(((String)cachePaths.get(3)).replace("SA", "WL"));
                    CompositeV35Activity.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            VoiceUtils.getVoiceUtils((Context)CompositeV35Activity.this).continuePlay("\u5168\u666f\u626b\u63cf.mp3");
                        }
                    });
                } else {
                    merges.addAll(cachePaths);
                }
                File binFolder = new File(PanoramaSDK.getContext().getExternalFilesDir(null), "/SmartPano/");
                if (!binFolder.exists()) {
                    binFolder.mkdirs();
                }
                File binFile = new File(binFolder, MWifiManager.getSsid((Context)CompositeV35Activity.this) + ".bin");
                JniTools.setProcessResolution(8000, 4000);
                String[] images = merges.toArray(new String[merges.size()]);
                JniTools.setInputPaths(images);
                JniTools.setOutputPath(panoFile.getPath());
                JniTools.stitch(binFile.getPath());
                float brightness = 140.8f;
                brightness -= 128.0f;
                float contrast = 217.6f;
                contrast = (contrast / 2.0f + 64.0f) / 128.0f;
                JniTools.saveFinalImg();
            }
            if (panoFile.exists()) {
                CompositeV35Activity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        VoiceUtils.getVoiceUtils((Context)CompositeV35Activity.this).playVoice("\u62cd\u6444\u5b8c\u6210.mp3");
                        if (CompositeV35Activity.this.isFromSDK) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_hhmmss");
                            File folder = new File(PanoramaSDK.getInstance().getOutputFolder());
                            File newFile = new File(folder, "pano_" + sdf.format(new Date()) + ".jpg");
                            panoFile.renameTo(newFile);
                            MediaRefresh.scanFileAsync(CompositeV35Activity.this.activity, newFile.getPath());
                            String panoPath = newFile.getPath();
                            Intent intent = new Intent(CompositeV35Activity.this.activity, ViewPhotoActivity.class);
                            intent.putExtra("path", panoPath);
                            CompositeV35Activity.this.startActivity(intent);
                            CompositeV35Activity.this.setResult(-1);
                        } else {
                            Intent intent = new Intent((Context)CompositeV35Activity.this, SavePhotoActivity.class);
                            intent.putExtra("path", panoFile.getPath());
                            CompositeV35Activity.this.startActivity(intent);
                        }
                        CompositeV35Activity.this.finish();
                    }
                });
            } else {
                Toast.makeText((Context)CompositeV35Activity.this, (CharSequence)"\u5408\u6210\u5931\u8d25!", (int)0).show();
                CompositeV35Activity.this.finish();
            }
        }
    }
}

