/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.MyCamera.CameraType;
import com.icatch.panorama.MyCamera.MyCamera;
import com.icatch.panorama.R;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.SystemInfo.HotSpot;
import com.icatch.panorama.data.SystemInfo.MWifiManager;
import com.icatch.panorama.data.entity.CameraSlot;
import com.icatch.panorama.db.CameraSlotSQLite;
import com.icatch.panorama.ui.ExtendComponent.MyProgressDialog;
import com.icatch.panorama.ui.activity.PanoramaPreviewV35Activity;
import com.icatch.panorama.ui.activity.PanoramaPreviewV50Activity;
import com.icatch.panorama.ui.activity.PanoramaPreviewV51Activity;
import com.icatch.panorama.ui.appdialog.AppDialog;
import com.icatch.panorama.utils.VoiceUtils;

public class ConnectCameraActivity
extends AppCompatActivity
implements View.OnClickListener {
    private ImageView btn_back;
    private TextView btn_connect;
    private Handler mHandler = new Handler();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connect_camera);
        this.initView();
        VoiceUtils.getVoiceUtils((Context)this).playVoice("\u53bb\u8fde\u63a5.mp3");
    }

    protected void onDestroy() {
        super.onDestroy();
        VoiceUtils.getVoiceUtils((Context)this).end();
    }

    private void initView() {
        this.btn_back = (ImageView)this.findViewById(R.id.btn_back);
        this.btn_connect = (TextView)this.findViewById(R.id.btn_connect);
        this.btn_back.setOnClickListener((View.OnClickListener)this);
        this.btn_connect.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btn_back) {
            this.finish();
        } else if (v.getId() == R.id.btn_connect) {
            final String cameraName = MWifiManager.getSsid((Context)this);
            MyProgressDialog.showProgressDialog((Context)this, R.string.action_processing);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ConnectCameraActivity.this.beginConnectCamera(ConnectCameraActivity.this.getCameraIp(), cameraName);
                }
            }).start();
        }
    }

    private String getCameraIp() {
        String ip = "";
        ip = HotSpot.isApEnabled((Context)this) ? HotSpot.getFirstConnectedHotIP() : (!AppInfo.enableLive ? "192.168.1.1" : AppInfo.inputIp);
        return ip;
    }

    private void beginConnectCamera(String ip, final String wifiSsid) {
        CameraManager.getInstance().createCamera(CameraType.PANORAMA_CAMERA, wifiSsid, ip, 1);
        final MyCamera currentCamera = CameraManager.getInstance().getCurCamera();
        if (!currentCamera.connect(true)) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    MyProgressDialog.closeProgressDialog();
                    AppDialog.showDialogWifi((Context)ConnectCameraActivity.this, ConnectCameraActivity.this.getString(R.string.dialog_connect_failed));
                }
            });
            return;
        }
        if (currentCamera.getCameraProperties().hasFuction(20497)) {
            currentCamera.getCameraProperties().setCameraDate();
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (!CameraSlotSQLite.getInstance().isExisted(wifiSsid)) {
                    CameraSlotSQLite.getInstance().insert(new CameraSlot(true, wifiSsid, CameraType.PANORAMA_CAMERA, null, true));
                }
                MyProgressDialog.closeProgressDialog();
                if ("V50 Serial".equals(currentCamera.getBaseProrertys().getProjectModel())) {
                    ConnectCameraActivity.this.startActivity(new Intent((Context)ConnectCameraActivity.this, PanoramaPreviewV50Activity.class));
                } else if ("V50 SBC".equals(currentCamera.getBaseProrertys().getProjectModel())) {
                    ConnectCameraActivity.this.startActivity(new Intent((Context)ConnectCameraActivity.this, PanoramaPreviewV51Activity.class));
                } else {
                    ConnectCameraActivity.this.startActivity(new Intent((Context)ConnectCameraActivity.this, PanoramaPreviewV35Activity.class));
                }
                ConnectCameraActivity.this.finish();
            }
        });
    }
}

