/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.Presenter.LocalPhotoPbPresenter;
import com.icatch.panorama.R;
import com.icatch.panorama.ui.ExtendComponent.HackyViewPager;
import com.icatch.panorama.ui.Interface.LocalPhotoPbView;

public class LocalPhotoPbActivity
extends AppCompatActivity
implements LocalPhotoPbView {
    private static final String TAG = LocalPhotoPbActivity.class.getSimpleName();
    private HackyViewPager viewPager;
    private TextView indexInfoTxv;
    private SurfaceView mSurfaceView;
    private ImageButton shareBtn;
    private ImageButton deleteBtn;
    private ImageButton photoInfoBtn;
    private RelativeLayout topBar;
    private LinearLayout bottomBar;
    private ImageButton back;
    private LocalPhotoPbPresenter presenter;
    private ImageButton doPrevious;
    private ImageButton doNext;
    private TextView panoramaTypeTxv;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_local_photo_pb);
        this.viewPager = (HackyViewPager)this.findViewById(R.id.viewpager);
        this.viewPager.setPageMargin(30);
        this.indexInfoTxv = (TextView)this.findViewById(R.id.pb_index_info);
        this.mSurfaceView = (SurfaceView)this.findViewById(R.id.m_surfaceView);
        this.shareBtn = (ImageButton)this.findViewById(R.id.local_photo_pb_share);
        this.deleteBtn = (ImageButton)this.findViewById(R.id.local_photo_pb_delete);
        this.photoInfoBtn = (ImageButton)this.findViewById(R.id.local_photo_pb_info);
        this.topBar = (RelativeLayout)this.findViewById(R.id.local_pb_top_layout);
        this.bottomBar = (LinearLayout)this.findViewById(R.id.local_pb_bottom_layout);
        this.back = (ImageButton)this.findViewById(R.id.local_pb_back);
        this.doPrevious = (ImageButton)this.findViewById(R.id.do_previous);
        this.doNext = (ImageButton)this.findViewById(R.id.do_next);
        this.panoramaTypeTxv = (TextView)this.findViewById(R.id.panorama_type_btn);
        this.presenter = new LocalPhotoPbPresenter((Activity)this);
        this.presenter.setView(this);
        this.shareBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LocalPhotoPbActivity.this.presenter.share((Context)LocalPhotoPbActivity.this);
            }
        });
        this.deleteBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LocalPhotoPbActivity.this.presenter.delete();
            }
        });
        this.photoInfoBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LocalPhotoPbActivity.this.presenter.info();
            }
        });
        this.panoramaTypeTxv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LocalPhotoPbActivity.this.presenter.setPanoramaType();
            }
        });
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LocalPhotoPbActivity.this.presenter.finish();
            }
        });
        this.doPrevious.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppLog.d(TAG, "....doPrevious");
                LocalPhotoPbActivity.this.presenter.loadPreviousImage();
            }
        });
        this.doNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppLog.d(TAG, "....doNext");
                LocalPhotoPbActivity.this.presenter.loadNextImage();
            }
        });
        this.mSurfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                AppLog.d(TAG, "surfaceCreated");
                LocalPhotoPbActivity.this.presenter.setShowArea(LocalPhotoPbActivity.this.mSurfaceView.getHolder().getSurface());
                LocalPhotoPbActivity.this.presenter.loadPanoramaImage();
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                AppLog.d(TAG, "surfaceChanged........width=" + width);
                LocalPhotoPbActivity.this.presenter.setDrawingArea(width, height);
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                AppLog.d(TAG, "surfaceDestroyed");
                LocalPhotoPbActivity.this.presenter.clearImage(1);
            }
        });
        this.mSurfaceView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        LocalPhotoPbActivity.this.presenter.onSufaceViewTouchDown(event);
                        break;
                    }
                    case 1: {
                        LocalPhotoPbActivity.this.presenter.onSufaceViewTouchUp();
                        break;
                    }
                    case 5: {
                        LocalPhotoPbActivity.this.presenter.onSufaceViewPointerDown(event);
                        break;
                    }
                    case 6: {
                        LocalPhotoPbActivity.this.presenter.onSufaceViewTouchPointerUp();
                        break;
                    }
                    case 2: {
                        LocalPhotoPbActivity.this.presenter.onSufaceViewTouchMove(event);
                    }
                }
                return true;
            }
        });
        this.viewPager.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppLog.d(TAG, "viewPager.setOnClickListener");
            }
        });
        this.presenter.initPanorama();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 3: {
                Log.d((String)"AppStart", (String)"home");
                break;
            }
            case 4: {
                Log.d((String)"AppStart", (String)"back");
                this.presenter.finish();
                break;
            }
            default: {
                return super.onKeyDown(keyCode, event);
            }
        }
        return true;
    }

    protected void onResume() {
        AppLog.d(TAG, "onResume");
        super.onResume();
        this.presenter.initView();
        this.presenter.submitAppInfo();
    }

    protected void onStart() {
        AppLog.d(TAG, "onStart");
        super.onStart();
    }

    protected void onStop() {
        AppLog.d(TAG, "onStop");
        super.onStop();
        this.presenter.isAppBackground();
    }

    protected void onDestroy() {
        AppLog.d(TAG, "onDestroy");
        super.onDestroy();
        this.presenter.removeActivity();
    }

    protected void onPause() {
        super.onPause();
    }

    @Override
    public void setViewPagerAdapter(PagerAdapter adapter) {
        if (adapter != null) {
            this.viewPager.setAdapter(adapter);
        }
    }

    @Override
    public void setIndexInfoTxv(String indexInfo) {
        this.indexInfoTxv.setText((CharSequence)indexInfo);
    }

    @Override
    public void setViewPagerCurrentItem(int position) {
        this.viewPager.setCurrentItem(position);
    }

    @Override
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.viewPager.addOnPageChangeListener(listener);
    }

    @Override
    public int getViewPagerCurrentItem() {
        return this.viewPager.getCurrentItem();
    }

    @Override
    public int getTopBarVisibility() {
        return this.topBar.getVisibility();
    }

    @Override
    public void setTopBarVisibility(int visibility) {
        this.topBar.setVisibility(visibility);
    }

    @Override
    public void setBottomBarVisibility(int visibility) {
        this.bottomBar.setVisibility(visibility);
    }

    @Override
    public void setSurfaceviewVisibility(int visibility) {
        int curVisibility = this.mSurfaceView.getVisibility();
        if (curVisibility != visibility) {
            this.mSurfaceView.setVisibility(visibility);
        }
    }

    @Override
    public void setViewPagerVisibility(int visibility) {
        this.viewPager.setVisibility(visibility);
    }

    @Override
    public void setPanoramaTypeTxv(int resId) {
        this.panoramaTypeTxv.setText(resId);
    }
}

