/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.activity;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.SurfaceTexture;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.Switch;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.Presenter.LocalVideoPbPresenter;
import com.icatch.panorama.R;
import com.icatch.panorama.ui.ExtendComponent.ProgressWheel;
import com.icatch.panorama.ui.Interface.LocalVideoPbView;
import com.icatch.panorama.ui.view.TextureVideoView;

public class LocalVideoPbActivity
extends AppCompatActivity
implements LocalVideoPbView {
    private String TAG = LocalVideoPbActivity.class.getSimpleName();
    private TextView timeLapsed;
    private TextView timeDuration;
    private SeekBar seekBar;
    private ImageButton play;
    private ImageButton back;
    private RelativeLayout topBar;
    private LinearLayout bottomBar;
    private TextView localVideoNameTxv;
    private TextureVideoView mSurfaceViewImage;
    private boolean isShowBar = true;
    private ProgressWheel progressWheel;
    private LocalVideoPbPresenter presenter;
    private String videoPath;
    private ImageButton panoramaTypeBtn;
    private LinearLayout moreSettingLayout;
    private ImageButton moreBtn;
    private ImageButton cancelBtn;
    private Switch eisSwitch;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_panorama_local_video_pb);
        this.timeLapsed = (TextView)this.findViewById(R.id.local_pb_time_lapsed);
        this.timeDuration = (TextView)this.findViewById(R.id.local_pb_time_duration);
        this.seekBar = (SeekBar)this.findViewById(R.id.local_pb_seekBar);
        this.play = (ImageButton)this.findViewById(R.id.local_pb_play_btn);
        this.back = (ImageButton)this.findViewById(R.id.local_pb_back);
        this.topBar = (RelativeLayout)this.findViewById(R.id.local_pb_top_layout);
        this.bottomBar = (LinearLayout)this.findViewById(R.id.local_pb_bottom_layout);
        this.mSurfaceViewImage = (TextureVideoView)this.findViewById(R.id.m_surfaceView);
        this.localVideoNameTxv = (TextView)this.findViewById(R.id.local_pb_video_name);
        this.progressWheel = (ProgressWheel)this.findViewById(R.id.local_pb_spinner);
        this.panoramaTypeBtn = (ImageButton)this.findViewById(R.id.panorama_type_btn);
        this.panoramaTypeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LocalVideoPbActivity.this.presenter.setPanoramaType();
            }
        });
        Intent intent = this.getIntent();
        Bundle data = intent.getExtras();
        this.videoPath = data.getString("curfilePath");
        AppLog.i(this.TAG, "videoPath=" + this.videoPath);
        this.presenter = new LocalVideoPbPresenter((Activity)this, this.videoPath);
        this.presenter.setView(this);
        this.presenter.initZoomView();
        this.getWindow().setFlags(128, 128);
        this.getWindow().addFlags(1024);
        this.mSurfaceViewImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppLog.d(LocalVideoPbActivity.this.TAG, "mSurfaceViewImage ClickListener");
                LocalVideoPbActivity.this.presenter.showBar(LocalVideoPbActivity.this.topBar.getVisibility() != 0);
            }
        });
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LocalVideoPbActivity.this.presenter.back();
            }
        });
        this.play.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LocalVideoPbActivity.this.presenter.play();
            }
        });
        this.seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                LocalVideoPbActivity.this.presenter.setTimeLapsedValue(progress);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                LocalVideoPbActivity.this.presenter.startSeekTouch();
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                LocalVideoPbActivity.this.presenter.completedSeekToPosition();
            }
        });
        AppLog.d(this.TAG, "mSurfaceView = " + (Object)((Object)this.mSurfaceViewImage));
        this.mSurfaceViewImage.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                LocalVideoPbActivity.this.presenter.initSurface(LocalVideoPbActivity.this.mSurfaceViewImage);
                LocalVideoPbActivity.this.presenter.play();
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                LocalVideoPbActivity.this.presenter.setDrawingArea(width, height);
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                AppLog.d(LocalVideoPbActivity.this.TAG, " 12233 surfaceDestroyed");
                LocalVideoPbActivity.this.presenter.destroyVideo();
                return false;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
        this.mSurfaceViewImage.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        LocalVideoPbActivity.this.presenter.onSufaceViewTouchDown(event);
                        break;
                    }
                    case 5: {
                        LocalVideoPbActivity.this.presenter.onSufaceViewPointerDown(event);
                        break;
                    }
                    case 2: {
                        LocalVideoPbActivity.this.presenter.onSufaceViewTouchMove(event);
                        break;
                    }
                    case 1: {
                        LocalVideoPbActivity.this.presenter.onSufaceViewTouchUp();
                        break;
                    }
                    case 6: {
                        LocalVideoPbActivity.this.presenter.onSufaceViewTouchPointerUp();
                    }
                }
                return true;
            }
        });
        this.moreSettingLayout = (LinearLayout)this.findViewById(R.id.more_setting_layout);
        this.moreBtn = (ImageButton)this.findViewById(R.id.more_btn);
        this.cancelBtn = (ImageButton)this.findViewById(R.id.cancel_btn);
        this.eisSwitch = (Switch)this.findViewById(R.id.eis_switch);
        this.moreBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LocalVideoPbActivity.this.presenter.showMoreSettingLayout(true);
            }
        });
        this.cancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LocalVideoPbActivity.this.presenter.showMoreSettingLayout(false);
            }
        });
        this.eisSwitch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean isChecked = LocalVideoPbActivity.this.eisSwitch.isChecked();
                LocalVideoPbActivity.this.presenter.enableEIS(isChecked);
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.presenter.submitAppInfo();
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.presenter.removeActivity();
    }

    @Override
    public void setTopBarVisibility(int visibility) {
        this.topBar.setVisibility(visibility);
    }

    @Override
    public void setBottomBarVisibility(int visibility) {
        this.bottomBar.setVisibility(visibility);
    }

    @Override
    public void setTimeLapsedValue(String value) {
        this.timeLapsed.setText((CharSequence)value);
    }

    @Override
    public void setTimeDurationValue(String value) {
        this.timeDuration.setText((CharSequence)value);
    }

    @Override
    public void setSeekBarProgress(int value) {
        this.seekBar.setProgress(value);
    }

    @Override
    public void setSeekBarMaxValue(int value) {
        this.seekBar.setMax(value);
    }

    @Override
    public int getSeekBarProgress() {
        return this.seekBar.getProgress();
    }

    @Override
    public void setSeekBarSecondProgress(int value) {
        this.seekBar.setSecondaryProgress(value);
    }

    @Override
    public void setPlayBtnSrc(int resid) {
        this.play.setImageResource(resid);
    }

    @Override
    public void showLoadingCircle(boolean isShow) {
        AppLog.d(this.TAG, "showLoadingCircle isShow=" + isShow);
        if (isShow) {
            this.progressWheel.setVisibility(0);
            this.progressWheel.setText("0%");
            this.progressWheel.startSpinning();
        } else {
            this.progressWheel.stopSpinning();
            this.progressWheel.setVisibility(8);
        }
    }

    @Override
    public void setLoadPercent(int value) {
        String temp = value + "%";
        this.progressWheel.setText(temp);
    }

    @Override
    public void setVideoNameTxv(String value) {
        this.localVideoNameTxv.setText((CharSequence)value);
    }

    @Override
    public void setZoomMinValue(float minValue) {
    }

    @Override
    public void setZoomMaxValue(float maxValue) {
    }

    @Override
    public void updateZoomRateTV(float zoomRate) {
    }

    @Override
    public void setProgress(float progress) {
    }

    @Override
    public void showZoomView(int visibility) {
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 3: {
                Log.d((String)"AppStart", (String)"home");
                break;
            }
            case 4: {
                Log.d((String)"AppStart", (String)"back");
                this.presenter.back();
                break;
            }
            default: {
                return super.onKeyDown(keyCode, event);
            }
        }
        return true;
    }

    @Override
    public int getSurfaceViewWidth() {
        View parentView = (View)this.mSurfaceViewImage.getParent();
        int width = parentView.getWidth();
        return width;
    }

    @Override
    public int getSurfaceViewHeight() {
        View parentView = (View)this.mSurfaceViewImage.getParent();
        int heigth = parentView.getHeight();
        return heigth;
    }

    @Override
    public void setPanoramaTypeImageResource(int resId) {
        this.panoramaTypeBtn.setImageResource(resId);
    }

    @Override
    public void setPanoramaTypeBtnVisibility(int visibility) {
        this.panoramaTypeBtn.setVisibility(visibility);
    }

    @Override
    public void setMoreSettingLayoutVisibility(int visibility) {
        this.moreSettingLayout.setVisibility(visibility);
    }

    @Override
    public void setEisSwitchChecked(boolean checked) {
        this.eisSwitch.setChecked(checked);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                LocalVideoPbActivity.this.presenter.redrawSurface();
            }
        }, 50L);
        AppLog.d(this.TAG, "onConfigurationChanged newConfig Orientation=" + newConfig.orientation);
    }
}

