/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.icatch.panorama.Application.PanoramaSDK;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.Presenter.PanoramaPreviewPresenter;
import com.icatch.panorama.R;
import com.icatch.panorama.data.GlobalApp.ExitApp;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import com.icatch.panorama.data.SystemInfo.MWifiManager;
import com.icatch.panorama.tcp.SocketTransceiver;
import com.icatch.panorama.tcp.TcpClient;
import com.icatch.panorama.ui.Interface.PanoramaPreviewView;
import com.icatch.panorama.ui.activity.CompositeV50Activity;
import com.icatch.panorama.ui.activity.ThumbActivity;
import com.icatch.panorama.ui.view.TextureVideoView;
import com.icatch.panorama.utils.CamPrefUtils;
import com.icatch.panorama.utils.VoiceUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PanoramaPreviewV50Activity
extends AppCompatActivity
implements View.OnClickListener,
PanoramaPreviewView,
TcpClient.StatusListener,
TcpClient.DataListener {
    private static final String TAG = PanoramaPreviewV50Activity.class.getSimpleName();
    private PanoramaPreviewPresenter presenter;
    private TextureVideoView mSurfaceView;
    private ImageView pbBtn;
    private ImageButton captureBtn;
    private ImageView wbStatus;
    private ImageView burstStatus;
    private ImageView wifiStatus;
    private ImageView batteryStatus;
    private ImageView timelapseMode;
    private ImageView slowMotion;
    private ImageView carMode;
    private TextView recordingTime;
    private ImageView autoDownloadImagview;
    private RelativeLayout imageSizeLayout;
    private RelativeLayout videoSizeLayout;
    private TextView remainRecordingTimeText;
    private TextView remainCaptureCountText;
    private TextView imageSizeTxv;
    private TextView videoSizeTxv;
    private TextView noSupportPreviewTxv;
    private PopupWindow pvModePopupWindow;
    private RadioButton captureRadioBtn;
    private RadioButton videoRadioBtn;
    private RadioButton timepLapseRadioBtn;
    private RelativeLayout cam_container;
    private TextView tv_battery;
    private TextView tv_ssid;
    private TextView tv_status;
    private View contentView;
    private boolean isAdd = true;
    private int mExp;
    private int mAgc;
    private long calcTime;
    private Handler mHandler = new Handler();
    private TcpClient mTcpClient;
    private int binLen;
    private FileOutputStream fos;
    private int receiveSize;
    private File binFile;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_panorama_preview);
        this.initView();
        this.tv_status = (TextView)this.findViewById(R.id.tv_status);
        this.presenter = new PanoramaPreviewPresenter((Activity)this);
        this.presenter.setView(this);
        this.presenter.addEvent();
        this.mSurfaceView = (TextureVideoView)this.findViewById(R.id.preview);
        this.mSurfaceView.setRotateDegree(-90.0f);
        this.cam_container = (RelativeLayout)this.findViewById(R.id.cam_container);
        this.pbBtn = (ImageView)this.findViewById(R.id.multi_pb);
        this.pbBtn.setOnClickListener((View.OnClickListener)this);
        this.captureBtn = (ImageButton)this.findViewById(R.id.doCapture);
        this.captureBtn.setOnClickListener((View.OnClickListener)this);
        this.wbStatus = (ImageView)this.findViewById(R.id.wb_status);
        this.burstStatus = (ImageView)this.findViewById(R.id.burst_status);
        this.wifiStatus = (ImageView)this.findViewById(R.id.wifi_status);
        this.batteryStatus = (ImageView)this.findViewById(R.id.battery_status);
        this.timelapseMode = (ImageView)this.findViewById(R.id.timelapse_mode);
        this.slowMotion = (ImageView)this.findViewById(R.id.slow_motion);
        this.carMode = (ImageView)this.findViewById(R.id.car_mode);
        this.recordingTime = (TextView)this.findViewById(R.id.recording_time);
        this.autoDownloadImagview = (ImageView)this.findViewById(R.id.auto_download_imageview);
        this.imageSizeLayout = (RelativeLayout)this.findViewById(R.id.image_size_layout);
        this.imageSizeTxv = (TextView)this.findViewById(R.id.image_size_txv);
        this.remainCaptureCountText = (TextView)this.findViewById(R.id.remain_capture_count_text);
        this.videoSizeLayout = (RelativeLayout)this.findViewById(R.id.video_size_layout);
        this.videoSizeTxv = (TextView)this.findViewById(R.id.video_size_txv);
        this.remainRecordingTimeText = (TextView)this.findViewById(R.id.remain_recording_time_text);
        this.noSupportPreviewTxv = (TextView)this.findViewById(R.id.not_support_preview_txv);
        this.contentView = LayoutInflater.from((Context)this).inflate(R.layout.camer_mode_switch_layout, null);
        this.pvModePopupWindow = new PopupWindow(this.contentView, -2, -2, true);
        this.pvModePopupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable());
        this.pvModePopupWindow.setFocusable(true);
        this.pvModePopupWindow.setOutsideTouchable(true);
        this.captureRadioBtn = (RadioButton)this.contentView.findViewById(R.id.capture_radio);
        this.videoRadioBtn = (RadioButton)this.contentView.findViewById(R.id.video_radio);
        this.timepLapseRadioBtn = (RadioButton)this.contentView.findViewById(R.id.timeLapse_radio);
        this.captureRadioBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PanoramaPreviewV50Activity.this.presenter.changePreviewMode(4097);
            }
        });
        this.videoRadioBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PanoramaPreviewV50Activity.this.presenter.changePreviewMode(4098);
            }
        });
        this.timepLapseRadioBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PanoramaPreviewV50Activity.this.presenter.changePreviewMode(4099);
            }
        });
        this.mSurfaceView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                AppLog.d(TAG, "surfaceCreated!!!");
                PanoramaPreviewV50Activity.this.presenter.initSurface(PanoramaPreviewV50Activity.this.mSurfaceView);
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                AppLog.d(TAG, "surfaceChanged!!!");
                PanoramaPreviewV50Activity.this.presenter.setDrawingArea(width, height);
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                PanoramaPreviewV50Activity.this.presenter.destroyPreview();
                return false;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
        this.mSurfaceView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        PanoramaPreviewV50Activity.this.presenter.onSufaceViewTouchDown(event);
                        break;
                    }
                    case 5: {
                        PanoramaPreviewV50Activity.this.presenter.onSufaceViewPointerDown(event);
                        break;
                    }
                    case 2: {
                        PanoramaPreviewV50Activity.this.presenter.onSufaceViewTouchMove(event);
                        break;
                    }
                    case 1: {
                        PanoramaPreviewV50Activity.this.presenter.onSufaceViewTouchUp();
                        break;
                    }
                    case 6: {
                        PanoramaPreviewV50Activity.this.presenter.onSufaceViewTouchPointerUp();
                    }
                }
                return true;
            }
        });
        GlobalInfo.getInstance().addEventListener(19);
        this.tv_ssid.setText((CharSequence)CameraManager.getInstance().getCurCamera().getCameraName());
        this.mTcpClient = TcpClient.getInstance();
        this.mTcpClient.registerStatusListener(this);
        this.mTcpClient.registerDataListener(this);
        this.presenter.onSelect(0, true);
        this.connectTCP();
    }

    protected void onPause() {
        super.onPause();
        if (this.presenter.isCapturing()) {
            ExitApp.getInstance().exit();
        } else {
            if (this.isAdd) {
                this.cam_container.removeView((View)this.mSurfaceView);
                this.isAdd = false;
            }
            this.presenter.unregisterWifiSSReceiver();
        }
    }

    protected void onResume() {
        super.onResume();
        if (!this.isAdd) {
            this.cam_container.addView((View)this.mSurfaceView);
            this.isAdd = true;
        }
        AppLog.d(TAG, "onResume");
        this.presenter.submitAppInfo();
        this.presenter.initPreview();
        this.presenter.initStatus();
    }

    protected void onStop() {
        AppLog.d(TAG, "onStop");
        super.onStop();
        this.presenter.isAppBackground();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 3: {
                AppLog.d("AppStart", "home");
                break;
            }
            case 4: {
                AppLog.d("AppStart", "back");
                this.presenter.finishActivity();
                break;
            }
            default: {
                return super.onKeyDown(keyCode, event);
            }
        }
        return true;
    }

    protected void onDestroy() {
        GlobalInfo.getInstance().delEventListener(19);
        AppLog.d(TAG, "onDestroy");
        super.onDestroy();
        this.presenter.removeActivity();
        this.presenter.destroyPreview();
        this.presenter.delEvent();
        this.presenter.disconnectCamera();
        this.presenter.delConnectFailureListener();
        this.presenter.shutDownThreadPool();
        VoiceUtils.getVoiceUtils((Context)this).end();
        this.mTcpClient.unregisterDataListener(this);
        this.mTcpClient.unregisterStatusListener(this);
        this.mTcpClient.disconnect();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.multi_pb) {
            AppLog.i(TAG, "click the multi_pb");
        } else if (v.getId() == R.id.doCapture) {
            if (!TextUtils.isEmpty((CharSequence)PanoramaSDK.getInstance().getOutputFolder())) {
                this.startCapture("pano", true);
                return;
            }
            View dialog_view = View.inflate((Context)this, (int)R.layout.dialog_rename, null);
            final EditText et_input = (EditText)dialog_view.findViewById(R.id.et_input);
            View.OnClickListener clickListener = new View.OnClickListener(){

                public void onClick(View v) {
                    if (v instanceof TextView) {
                        et_input.setText((CharSequence)((TextView)v).getText().toString());
                    }
                }
            };
            dialog_view.findViewById(R.id.tv_01).setOnClickListener(clickListener);
            dialog_view.findViewById(R.id.tv_02).setOnClickListener(clickListener);
            dialog_view.findViewById(R.id.tv_03).setOnClickListener(clickListener);
            dialog_view.findViewById(R.id.tv_04).setOnClickListener(clickListener);
            dialog_view.findViewById(R.id.tv_05).setOnClickListener(clickListener);
            dialog_view.findViewById(R.id.tv_06).setOnClickListener(clickListener);
            dialog_view.findViewById(R.id.tv_07).setOnClickListener(clickListener);
            final AlertDialog dialog = new AlertDialog.Builder((Context)this).setView(dialog_view).create();
            dialog.setCanceledOnTouchOutside(false);
            dialog.show();
            dialog_view.findViewById(R.id.btn_stitch_now).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String name = et_input.getText().toString().trim();
                    if (TextUtils.isEmpty((CharSequence)name)) {
                        Toast.makeText((Context)PanoramaPreviewV50Activity.this, (CharSequence)"\u8bf7\u8f93\u5165\u5168\u666f\u540d\u5b57", (int)0).show();
                        return;
                    }
                    dialog.dismiss();
                    PanoramaPreviewV50Activity.this.startCapture(name, true);
                }
            });
            dialog_view.findViewById(R.id.btn_stitch_later).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String name = et_input.getText().toString().trim();
                    if (TextUtils.isEmpty((CharSequence)name)) {
                        Toast.makeText((Context)PanoramaPreviewV50Activity.this, (CharSequence)"\u8bf7\u8f93\u5165\u5168\u666f\u540d\u5b57", (int)0).show();
                        return;
                    }
                    dialog.dismiss();
                    PanoramaPreviewV50Activity.this.startCapture(name, false);
                }
            });
            dialog_view.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    dialog.dismiss();
                }
            });
        }
    }

    private void startCapture(String photoName, boolean stitchNow) {
        Pattern pattern = Pattern.compile("[\\s\\\\/:\\*\\?\\\"<>\\|]");
        Matcher matcher = pattern.matcher(photoName);
        photoName = matcher.replaceAll("");
        CamPrefUtils.setStitchNow((Context)this, stitchNow);
        CamPrefUtils.setPhotoName((Context)this, photoName);
        AppLog.i(TAG, "click the doCapture");
        this.presenter.disableCaptureBtn();
        this.presenter.resetCount();
        this.tv_status.setVisibility(0);
        this.presenter.startOrStopCapture();
        VoiceUtils.getVoiceUtils((Context)this).playVoice("\u62cd\u6444\u63d0\u9192.mp3");
    }

    @Override
    public void setWbStatusVisibility(int visibility) {
        this.wbStatus.setVisibility(visibility);
    }

    @Override
    public void setBurstStatusVisibility(int visibility) {
        this.burstStatus.setVisibility(visibility);
    }

    @Override
    public void setWifiStatusVisibility(int visibility) {
        this.wifiStatus.setVisibility(visibility);
    }

    @Override
    public void setWifiIcon(int drawableId) {
        this.wifiStatus.setBackgroundResource(drawableId);
    }

    @Override
    public void setBatteryStatusVisibility(int visibility) {
        this.batteryStatus.setVisibility(visibility);
    }

    @Override
    public void setBatteryIcon(int drawableId) {
        this.batteryStatus.setBackgroundResource(drawableId);
    }

    @Override
    public void setBatteryText(String text) {
        this.tv_battery.setText((CharSequence)text);
    }

    @Override
    public void settimeLapseModeVisibility(int visibility) {
        this.timelapseMode.setVisibility(visibility);
    }

    @Override
    public void settimeLapseModeIcon(int drawableId) {
        this.timelapseMode.setBackgroundResource(drawableId);
    }

    @Override
    public void setSlowMotionVisibility(int visibility) {
        this.slowMotion.setVisibility(visibility);
    }

    @Override
    public void setCarModeVisibility(int visibility) {
        this.carMode.setVisibility(visibility);
    }

    @Override
    public void setRecordingTimeVisibility(int visibility) {
        this.recordingTime.setVisibility(visibility);
    }

    @Override
    public void setAutoDownloadVisibility(int visibility) {
        this.autoDownloadImagview.setVisibility(visibility);
    }

    @Override
    public void setCaptureBtnBackgroundResource(int id2) {
        this.captureBtn.setBackgroundResource(id2);
    }

    @Override
    public void setRecordingTime(String laspeTime) {
        this.recordingTime.setText((CharSequence)laspeTime);
    }

    @Override
    public void setImageSizeLayoutVisibility(int visibility) {
        this.imageSizeLayout.setVisibility(visibility);
    }

    @Override
    public void setRemainCaptureCount(String remainCaptureCount) {
        this.remainCaptureCountText.setText((CharSequence)remainCaptureCount);
    }

    @Override
    public void setVideoSizeLayoutVisibility(int visibility) {
        this.videoSizeLayout.setVisibility(visibility);
        this.remainRecordingTimeText.setVisibility(visibility);
    }

    @Override
    public void setRemainRecordingTimeText(String remainRecordingTime) {
        this.remainRecordingTimeText.setText((CharSequence)remainRecordingTime);
    }

    @Override
    public void setBurstStatusIcon(int drawableId) {
        this.burstStatus.setBackgroundResource(drawableId);
    }

    @Override
    public void setWbStatusIcon(int drawableId) {
        this.wbStatus.setBackgroundResource(drawableId);
    }

    @Override
    public void setUpsideVisibility(int visibility) {
        this.carMode.setVisibility(visibility);
    }

    @Override
    public void setCaptureBtnEnability(boolean enablity) {
        this.captureBtn.setEnabled(enablity);
    }

    @Override
    public void setVideoSizeInfo(String sizeInfo) {
        AppLog.i(TAG, "sizeInfo = " + sizeInfo);
        this.videoSizeTxv.setText((CharSequence)sizeInfo);
    }

    @Override
    public void setImageSizeInfo(String sizeInfo) {
        AppLog.i(TAG, "sizeInfo = " + sizeInfo);
        this.imageSizeTxv.setText((CharSequence)sizeInfo);
    }

    @Override
    public void setAutoDownloadBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            this.autoDownloadImagview.setImageBitmap(bitmap);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                PanoramaPreviewV50Activity.this.presenter.redrawSurface();
            }
        }, 200L);
        AppLog.d(TAG, "onConfigurationChanged newConfig Orientation=" + newConfig.orientation);
    }

    @Override
    public void setSupportPreviewTxvVisibility(int visibility) {
        this.noSupportPreviewTxv.setVisibility(visibility);
    }

    @Override
    public void setPvModeBtnBackgroundResource(int drawableId) {
    }

    @Override
    public void setTimepLapseRadioBtnVisibility(int visibility) {
        this.timepLapseRadioBtn.setVisibility(visibility);
    }

    @Override
    public void setCaptureRadioBtnVisibility(int visibility) {
        this.captureRadioBtn.setVisibility(visibility);
    }

    @Override
    public void setVideoRadioBtnVisibility(int visibility) {
        this.videoRadioBtn.setVisibility(visibility);
    }

    @Override
    public void setTimepLapseRadioChecked(boolean checked) {
        this.timepLapseRadioBtn.setChecked(checked);
    }

    @Override
    public void setCaptureRadioBtnChecked(boolean checked) {
        this.captureRadioBtn.setChecked(checked);
    }

    @Override
    public void setVideoRadioBtnChecked(boolean checked) {
        this.videoRadioBtn.setChecked(checked);
    }

    @Override
    public void showPopupWindow(int curMode) {
    }

    @Override
    public void dismissPopupWindow() {
        if (this.pvModePopupWindow != null && this.pvModePopupWindow.isShowing()) {
            this.pvModePopupWindow.dismiss();
        }
    }

    @Override
    public int getSurfaceViewWidth() {
        View parentView = (View)this.mSurfaceView.getParent();
        int width = parentView.getWidth();
        return width;
    }

    @Override
    public int getSurfaceViewHeight() {
        View parentView = (View)this.mSurfaceView.getParent();
        int heigth = parentView.getHeight();
        return heigth;
    }

    @Override
    public void onCapture(int count) {
        this.presenter.setCapturing(false);
        this.tv_status.setVisibility(8);
        if (CamPrefUtils.isStitchNow((Context)this)) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PanoramaPreviewV50Activity.this.startActivityForResult(new Intent((Context)PanoramaPreviewV50Activity.this, CompositeV50Activity.class), 1024);
                }
            }, 1000L);
        } else {
            this.startActivityForResult(new Intent((Context)this, ThumbActivity.class), 1024);
        }
    }

    @Override
    public void onMotorFinished() {
        this.presenter.setCapturing(false);
        this.tv_status.setVisibility(8);
        if (CamPrefUtils.isStitchNow((Context)this)) {
            this.startActivityForResult(new Intent((Context)this, CompositeV50Activity.class), 1024);
        } else {
            this.startActivityForResult(new Intent((Context)this, ThumbActivity.class), 1024);
        }
    }

    private void lightAE() {
        this.setAE((int)((float)this.mExp * 0.7f), (int)((float)this.mAgc * 1.3f));
    }

    private void darkAE() {
        this.setAE((int)((float)this.mExp * 1.5f), (int)((float)this.mAgc * 0.5f));
    }

    private void normalAE() {
        this.setAE(this.mExp, this.mAgc);
    }

    private void initView() {
        this.tv_battery = (TextView)this.findViewById(R.id.tv_battery);
        this.tv_ssid = (TextView)this.findViewById(R.id.tv_ssid);
        this.findViewById(R.id.btn_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PanoramaPreviewV50Activity.this.presenter.finishActivity();
            }
        });
    }

    @Override
    public void onDisconnect(SocketTransceiver transceiver) {
    }

    @Override
    public void onConnect(SocketTransceiver transceiver) {
    }

    @Override
    public void onConnectFailed() {
        System.out.println("onConnectFailed");
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (PanoramaPreviewV50Activity.this.presenter.enableTCP()) {
                    PanoramaPreviewV50Activity.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            PanoramaPreviewV50Activity.this.connectTCP();
                        }
                    }, 500L);
                }
            }
        }, 1000L);
    }

    @Override
    public void onReceive(SocketTransceiver transceiver, byte[] datas) {
        if (datas.length == 3 && datas[0] == -69) {
            byte[] lens = new byte[]{datas[1], datas[2]};
            this.binLen = Integer.parseInt(this.bytes2hex(lens), 16);
            try {
                this.fos = new FileOutputStream(this.binFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.fos != null) {
            this.receiveSize += datas.length;
            try {
                this.fos.write(datas, 0, datas.length);
                if (this.receiveSize == this.binLen) {
                    this.fos.close();
                    this.fos = null;
                    this.mTcpClient.disconnect();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void connectTCP() {
        File binFolder = new File(PanoramaSDK.getContext().getExternalFilesDir(null), "/SmartPano/");
        if (!binFolder.exists()) {
            binFolder.mkdirs();
        }
        this.binFile = new File(binFolder, MWifiManager.getSsid((Context)this) + ".bin");
        if (this.binFile.exists()) {
            if (TextUtils.isEmpty((CharSequence)MWifiManager.getSsid((Context)this))) {
                this.binFile.delete();
                this.mTcpClient.connect("192.168.1.1", 8089);
            }
        } else {
            this.mTcpClient.connect("192.168.1.1", 8089);
        }
    }

    private String bytes2hex(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs.toUpperCase();
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode != 1024 || resultCode == -1) {
            // empty if block
        }
    }

    private void autoAE() {
        CameraManager.getInstance().getCurCamera().getCameraProperties().setPropertyValue(55137, 1);
    }

    private void setAE(int exp, int agc) {
        if (exp > 207) {
            exp = 207;
        }
        if (exp < 26) {
            exp = 26;
        }
        if (agc > 80) {
            agc = 80;
        }
        if (agc < 0) {
            agc = 0;
        }
        int sendValue = exp << 8 | this.mAgc & 0xFF;
        CameraManager.getInstance().getCurCamera().getCameraProperties().setPropertyValue(55136, sendValue);
    }

    private void getAE() {
        int readValue = CameraManager.getInstance().getCurCamera().getCameraProperties().getCurrentPropertyValue(55136);
        this.mExp = readValue >> 8;
        this.mAgc = readValue & 0xFF;
    }
}

