/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.activity;

import android.app.Activity;
import android.content.res.Configuration;
import android.graphics.SurfaceTexture;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.Switch;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.Presenter.PanoramaVideoPbPresenter;
import com.icatch.panorama.R;
import com.icatch.panorama.ui.ExtendComponent.ProgressWheel;
import com.icatch.panorama.ui.Interface.PanoramaVideoPbView;
import com.icatch.panorama.ui.view.TextureVideoView;

public class PanoramaVideoPbActivity
extends AppCompatActivity
implements PanoramaVideoPbView {
    private String TAG = PanoramaVideoPbActivity.class.getSimpleName();
    private TextView timeLapsed;
    private TextView timeDuration;
    private SeekBar seekBar;
    private ImageButton play;
    private ImageButton back;
    private ImageButton deleteBtn;
    private ImageButton downloadBtn;
    private LinearLayout topBar;
    private LinearLayout bottomBar;
    private TextView videoNameTxv;
    private ProgressWheel progressWheel;
    private PanoramaVideoPbPresenter presenter;
    private TextureVideoView mSurfaceView;
    private ImageButton panoramaTypeBtn;
    private LinearLayout moreSettingLayout;
    private ImageButton moreBtn;
    private ImageButton cancelBtn;
    private Switch eisSwitch;
    private TextView deleteTxv;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_panorama_video_pb);
        this.timeLapsed = (TextView)this.findViewById(R.id.video_pb_time_lapsed);
        this.timeDuration = (TextView)this.findViewById(R.id.video_pb_time_duration);
        this.seekBar = (SeekBar)this.findViewById(R.id.video_pb_seekBar);
        this.play = (ImageButton)this.findViewById(R.id.video_pb_play_btn);
        this.back = (ImageButton)this.findViewById(R.id.video_pb_back);
        this.topBar = (LinearLayout)this.findViewById(R.id.video_pb_top_layout);
        this.bottomBar = (LinearLayout)this.findViewById(R.id.video_pb_bottom_layout);
        this.mSurfaceView = (TextureVideoView)this.findViewById(R.id.m_surfaceView);
        this.videoNameTxv = (TextView)this.findViewById(R.id.video_pb_video_name);
        this.progressWheel = (ProgressWheel)this.findViewById(R.id.video_pb_spinner);
        this.deleteBtn = (ImageButton)this.findViewById(R.id.delete);
        this.downloadBtn = (ImageButton)this.findViewById(R.id.download);
        this.moreSettingLayout = (LinearLayout)this.findViewById(R.id.more_setting_layout);
        this.moreBtn = (ImageButton)this.findViewById(R.id.more_btn);
        this.cancelBtn = (ImageButton)this.findViewById(R.id.cancel_btn);
        this.eisSwitch = (Switch)this.findViewById(R.id.eis_switch);
        this.deleteTxv = (TextView)this.findViewById(R.id.delete_txv);
        this.panoramaTypeBtn = (ImageButton)this.findViewById(R.id.panorama_type_btn);
        this.presenter = new PanoramaVideoPbPresenter((Activity)this);
        this.presenter.setView(this);
        this.getWindow().setFlags(128, 128);
        this.getWindow().addFlags(1024);
        this.moreBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PanoramaVideoPbActivity.this.presenter.showMoreSettingLayout(true);
            }
        });
        this.cancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PanoramaVideoPbActivity.this.presenter.showMoreSettingLayout(false);
            }
        });
        this.eisSwitch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean isChecked = PanoramaVideoPbActivity.this.eisSwitch.isChecked();
                PanoramaVideoPbActivity.this.presenter.enableEIS(isChecked);
            }
        });
        this.deleteTxv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PanoramaVideoPbActivity.this.presenter.delete();
            }
        });
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PanoramaVideoPbActivity.this.presenter.stopVideoStream();
                PanoramaVideoPbActivity.this.presenter.removeEventListener();
                PanoramaVideoPbActivity.this.finish();
            }
        });
        this.panoramaTypeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PanoramaVideoPbActivity.this.presenter.setPanoramaType();
            }
        });
        this.play.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PanoramaVideoPbActivity.this.presenter.play();
            }
        });
        this.deleteBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PanoramaVideoPbActivity.this.presenter.delete();
            }
        });
        this.downloadBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PanoramaVideoPbActivity.this.presenter.download();
            }
        });
        this.seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                PanoramaVideoPbActivity.this.presenter.setTimeLapsedValue(progress);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                PanoramaVideoPbActivity.this.presenter.seekBarOnStartTrackingTouch();
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                PanoramaVideoPbActivity.this.presenter.seekBarOnStopTrackingTouch();
            }
        });
        this.mSurfaceView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppLog.d(PanoramaVideoPbActivity.this.TAG, "mSurfaceViewImage ClickListener");
                PanoramaVideoPbActivity.this.presenter.showBar(PanoramaVideoPbActivity.this.topBar.getVisibility() != 0);
            }
        });
        this.mSurfaceView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int i, int i1, int i2, int i3, int i4, int i5, int i6, int i7) {
                View parentView = (View)PanoramaVideoPbActivity.this.mSurfaceView.getParent();
                int heigth = parentView.getHeight();
                int width = parentView.getWidth();
                AppLog.d(PanoramaVideoPbActivity.this.TAG, "onLayoutChange heigth=" + heigth + " width=" + width);
                PanoramaVideoPbActivity.this.presenter.redrawSurface();
            }
        });
        this.mSurfaceView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                AppLog.d(PanoramaVideoPbActivity.this.TAG, "surfaceCreated");
                PanoramaVideoPbActivity.this.presenter.initSurface(PanoramaVideoPbActivity.this.mSurfaceView);
                PanoramaVideoPbActivity.this.presenter.play();
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                PanoramaVideoPbActivity.this.presenter.setDrawingArea(width, height);
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                return false;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
                PanoramaVideoPbActivity.this.presenter.destroyVideo(1);
            }
        });
        this.mSurfaceView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        PanoramaVideoPbActivity.this.presenter.onSufaceViewTouchDown(event);
                        break;
                    }
                    case 5: {
                        PanoramaVideoPbActivity.this.presenter.onSufaceViewPointerDown(event);
                        break;
                    }
                    case 2: {
                        PanoramaVideoPbActivity.this.presenter.onSufaceViewTouchMove(event);
                        break;
                    }
                    case 1: {
                        PanoramaVideoPbActivity.this.presenter.onSufaceViewTouchUp();
                        break;
                    }
                    case 6: {
                        PanoramaVideoPbActivity.this.presenter.onSufaceViewTouchPointerUp();
                    }
                }
                return true;
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.presenter.submitAppInfo();
    }

    protected void onStop() {
        super.onStop();
        this.presenter.isAppBackground();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.presenter.removeActivity();
        this.presenter.destroyVideo(1);
    }

    @Override
    public void setTopBarVisibility(int visibility) {
        this.topBar.setVisibility(visibility);
    }

    @Override
    public void setBottomBarVisibility(int visibility) {
        this.bottomBar.setVisibility(visibility);
    }

    @Override
    public void setTimeLapsedValue(String value) {
        this.timeLapsed.setText((CharSequence)value);
    }

    @Override
    public void setTimeDurationValue(String value) {
        this.timeDuration.setText((CharSequence)value);
    }

    @Override
    public void setSeekBarProgress(int value) {
        this.seekBar.setProgress(value);
    }

    @Override
    public void setSeekBarMaxValue(int value) {
        this.seekBar.setMax(value);
    }

    @Override
    public int getSeekBarProgress() {
        return this.seekBar.getProgress();
    }

    @Override
    public void setSeekBarSecondProgress(int value) {
        this.seekBar.setSecondaryProgress(value);
    }

    @Override
    public void setPlayBtnSrc(int resid) {
        this.play.setImageResource(resid);
    }

    @Override
    public void showLoadingCircle(boolean isShow) {
        if (isShow) {
            AppLog.d(this.TAG, "showLoadingCircle");
            this.progressWheel.setVisibility(0);
            this.progressWheel.setText("0%");
            this.progressWheel.startSpinning();
        } else {
            AppLog.d(this.TAG, "display LoadingCircle");
            this.progressWheel.stopSpinning();
            this.progressWheel.setVisibility(8);
        }
    }

    @Override
    public void setLoadPercent(int value) {
        String temp = value + "%";
        this.progressWheel.setText(temp);
    }

    @Override
    public void setVideoNameTxv(String value) {
        this.videoNameTxv.setText((CharSequence)value);
    }

    @Override
    public void setProgress(float progress) {
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 3: {
                Log.d((String)"AppStart", (String)"home");
                break;
            }
            case 4: {
                Log.d((String)"AppStart", (String)"back");
                this.presenter.destroyVideo(1);
                this.finish();
                break;
            }
            default: {
                return super.onKeyDown(keyCode, event);
            }
        }
        return true;
    }

    @Override
    public int getSurfaceViewWidth() {
        View parentView = (View)this.mSurfaceView.getParent();
        int width = parentView.getWidth();
        return width;
    }

    @Override
    public int getSurfaceViewHeight() {
        View parentView = (View)this.mSurfaceView.getParent();
        int heigth = parentView.getHeight();
        return heigth;
    }

    @Override
    public void setPanoramaTypeImageResource(int resId) {
        this.panoramaTypeBtn.setImageResource(resId);
    }

    @Override
    public void setPanoramaTypeBtnVisibility(int visibility) {
        this.panoramaTypeBtn.setVisibility(visibility);
    }

    @Override
    public void setMoreSettingLayoutVisibility(int visibility) {
        this.moreSettingLayout.setVisibility(visibility);
    }

    @Override
    public void setEisSwitchChecked(boolean checked) {
        this.eisSwitch.setChecked(checked);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                PanoramaVideoPbActivity.this.presenter.redrawSurface();
            }
        }, 50L);
        AppLog.d(this.TAG, "onConfigurationChanged newConfig Orientation=" + newConfig.orientation);
    }
}

