/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.activity;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.Presenter.PhotoPbPresenter;
import com.icatch.panorama.R;
import com.icatch.panorama.ui.ExtendComponent.HackyViewPager;
import com.icatch.panorama.ui.Interface.PhotoPbView;

public class PhotoPbActivity
extends AppCompatActivity
implements PhotoPbView {
    private static final String TAG = PhotoPbActivity.class.getSimpleName();
    private HackyViewPager viewPager;
    private ImageButton downloadBtn;
    private ImageButton deleteBtn;
    private TextView indexInfoTxv;
    private RelativeLayout topBar;
    private LinearLayout bottomBar;
    private PhotoPbPresenter presenter;
    private ImageButton back;
    private SurfaceView mSurfaceView;
    private ImageButton doPrevious;
    private ImageButton doNext;
    private TextView panoramaTypeTxv;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_photo_pb);
        this.viewPager = (HackyViewPager)this.findViewById(R.id.viewpager);
        this.indexInfoTxv = (TextView)this.findViewById(R.id.pb_index_info);
        this.downloadBtn = (ImageButton)this.findViewById(R.id.photo_pb_download);
        this.deleteBtn = (ImageButton)this.findViewById(R.id.photo_pb_delete);
        this.topBar = (RelativeLayout)this.findViewById(R.id.pb_top_layout);
        this.bottomBar = (LinearLayout)this.findViewById(R.id.pb_bottom_layout);
        this.back = (ImageButton)this.findViewById(R.id.pb_back);
        this.doPrevious = (ImageButton)this.findViewById(R.id.do_previous);
        this.doNext = (ImageButton)this.findViewById(R.id.do_next);
        this.mSurfaceView = (SurfaceView)this.findViewById(R.id.m_surfaceView);
        this.panoramaTypeTxv = (TextView)this.findViewById(R.id.panorama_type_btn);
        this.presenter = new PhotoPbPresenter((Activity)this);
        this.presenter.setView(this);
        this.viewPager.setPageMargin(30);
        this.panoramaTypeTxv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PhotoPbActivity.this.presenter.setPanoramaType();
            }
        });
        this.doPrevious.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppLog.d(TAG, "....doPrevious");
                PhotoPbActivity.this.presenter.loadPreviousImage();
            }
        });
        this.doNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppLog.d(TAG, "....doNext");
                PhotoPbActivity.this.presenter.loadNextImage();
            }
        });
        this.mSurfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                AppLog.d(TAG, "surfaceCreated");
                PhotoPbActivity.this.presenter.initPanorama();
                PhotoPbActivity.this.presenter.setShowArea(PhotoPbActivity.this.mSurfaceView.getHolder().getSurface());
                PhotoPbActivity.this.presenter.loadPanoramaImage();
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                AppLog.d(TAG, "surfaceChanged........width=" + width);
                PhotoPbActivity.this.presenter.setDrawingArea(width, height);
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                AppLog.d(TAG, "surfaceDestroyed");
                PhotoPbActivity.this.presenter.destroyImage(1);
            }
        });
        this.mSurfaceView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        PhotoPbActivity.this.presenter.onSufaceViewTouchDown(event);
                        break;
                    }
                    case 5: {
                        PhotoPbActivity.this.presenter.onSufaceViewPointerDown(event);
                        break;
                    }
                    case 2: {
                        PhotoPbActivity.this.presenter.onSufaceViewTouchMove(event);
                        break;
                    }
                    case 1: {
                        PhotoPbActivity.this.presenter.onSufaceViewTouchUp();
                        break;
                    }
                    case 6: {
                        PhotoPbActivity.this.presenter.onSufaceViewTouchPointerUp();
                    }
                }
                return true;
            }
        });
        this.viewPager.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppLog.d(TAG, "viewPager.setOnClickListener");
            }
        });
        this.downloadBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoPbActivity.this.presenter.download();
            }
        });
        this.deleteBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoPbActivity.this.presenter.delete();
            }
        });
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoPbActivity.this.presenter.destroyImage(1);
                PhotoPbActivity.this.finish();
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.presenter.initView();
        this.presenter.submitAppInfo();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 3: {
                Log.d((String)"AppStart", (String)"home");
                break;
            }
            case 4: {
                Log.d((String)"AppStart", (String)"back");
                this.presenter.destroyImage(1);
                this.finish();
                break;
            }
            default: {
                return super.onKeyDown(keyCode, event);
            }
        }
        return true;
    }

    protected void onStop() {
        super.onStop();
        this.presenter.isAppBackground();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.presenter.removeActivity();
    }

    @Override
    public void setViewPagerAdapter(PagerAdapter adapter) {
        if (adapter != null) {
            this.viewPager.setAdapter(adapter);
        }
    }

    @Override
    public void setTopBarVisibility(int visibility) {
        this.topBar.setVisibility(visibility);
    }

    @Override
    public void setBottomBarVisibility(int visibility) {
        this.bottomBar.setVisibility(visibility);
    }

    @Override
    public void setIndexInfoTxv(String photoName) {
        this.indexInfoTxv.setText((CharSequence)photoName);
    }

    @Override
    public void setViewPagerCurrentItem(int position) {
        this.viewPager.setCurrentItem(position);
    }

    @Override
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.viewPager.addOnPageChangeListener(listener);
    }

    @Override
    public int getViewPagerCurrentItem() {
        return this.viewPager.getCurrentItem();
    }

    @Override
    public int getTopBarVisibility() {
        return this.topBar.getVisibility();
    }

    @Override
    public void setSurfaceviewTransparent(boolean value) {
        if (value) {
            this.mSurfaceView.setVisibility(8);
        } else {
            this.mSurfaceView.setVisibility(0);
        }
    }

    @Override
    public void setPanoramaTypeTxv(int resId) {
        this.panoramaTypeTxv.setText(resId);
    }

    @Override
    public void setViewPagerVisibility(int visibility) {
        this.viewPager.setVisibility(visibility);
    }
}

