/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.ImageButton;
import androidx.appcompat.app.AppCompatActivity;
import com.icatch.panorama.Application.PanoramaSDK;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.LocalSession;
import com.icatch.panorama.R;
import com.icatch.panorama.SdkApi.PanoramaPhotoPlayback;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.GlobalApp.ExitApp;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import com.icatch.panorama.data.Mode.TouchMode;
import com.icatch.panorama.ui.ExtendComponent.MyProgressDialog;
import com.icatch.panorama.utils.CamPrefUtils;
import com.icatch.panorama.utils.FileOpertion.FileTools;
import com.icatch.panorama.utils.GlideUtils;
import com.icatch.panorama.utils.MediaRefresh;
import com.icatchtek.pancam.customer.exception.IchGLSurfaceNotSetException;
import com.icatchtek.pancam.customer.surface.ICatchSurfaceContext;
import com.icatchtek.pancam.customer.type.ICatchGLImage;
import com.icatchtek.pancam.customer.type.ICatchGLPoint;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SavePhotoActivity
extends AppCompatActivity
implements SensorEventListener {
    private static final String TAG = SavePhotoActivity.class.getSimpleName();
    private SurfaceView mSurfaceView;
    private ImageButton shareBtn;
    private ImageButton deleteBtn;
    private ImageButton back;
    private ExecutorService executor;
    private Handler handler;
    private PanoramaPhotoPlayback panoramaPhotoPlayback;
    private static final float MIN_ZOOM = 0.5f;
    private static final float MAX_ZOOM = 2.2f;
    private static final float FIXED_INSIDE_DISTANCE = 0.45454544f;
    private TouchMode touchMode = TouchMode.NONE;
    private float mPreviousY;
    private float mPreviousX;
    private float beforeLenght;
    private float afterLenght;
    private float currentZoomRate = 2.2f;
    private SensorManager sensorManager;
    private Sensor gyroscopeSensor;
    private ICatchSurfaceContext iCatchSurfaceContext;
    private String photoPath;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_hhmmss");

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_photo_save);
        this.photoPath = this.getIntent().getStringExtra("path");
        this.mSurfaceView = (SurfaceView)this.findViewById(R.id.m_surfaceView);
        this.shareBtn = (ImageButton)this.findViewById(R.id.local_photo_pb_share);
        this.deleteBtn = (ImageButton)this.findViewById(R.id.local_photo_pb_delete);
        this.back = (ImageButton)this.findViewById(R.id.local_pb_back);
        this.handler = new Handler();
        this.initCfg();
        this.initClient();
        this.shareBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SavePhotoActivity.this.saveDialog(new File(SavePhotoActivity.this.photoPath));
            }
        });
        this.deleteBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SavePhotoActivity.this.delete();
            }
        });
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SavePhotoActivity.this.finishActivity();
            }
        });
        this.mSurfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                AppLog.d(TAG, "surfaceCreated");
                SavePhotoActivity.this.setShowArea(SavePhotoActivity.this.mSurfaceView.getHolder().getSurface());
                SavePhotoActivity.this.loadPanoramaImage();
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                AppLog.d(TAG, "surfaceChanged........width=" + width);
                SavePhotoActivity.this.setDrawingArea(width, height);
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                AppLog.d(TAG, "surfaceDestroyed");
                SavePhotoActivity.this.clearImage(1);
            }
        });
        this.mSurfaceView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        SavePhotoActivity.this.onSufaceViewTouchDown(event);
                        break;
                    }
                    case 1: {
                        SavePhotoActivity.this.onSufaceViewTouchUp();
                        break;
                    }
                    case 5: {
                        SavePhotoActivity.this.onSufaceViewPointerDown(event);
                        break;
                    }
                    case 6: {
                        SavePhotoActivity.this.onSufaceViewTouchPointerUp();
                        break;
                    }
                    case 2: {
                        SavePhotoActivity.this.onSufaceViewTouchMove(event);
                    }
                }
                return true;
            }
        });
        this.initPanorama();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 3: {
                Log.d((String)"AppStart", (String)"home");
                break;
            }
            case 4: {
                break;
            }
            default: {
                return super.onKeyDown(keyCode, event);
            }
        }
        return true;
    }

    protected void onResume() {
        AppLog.d(TAG, "onResume");
        super.onResume();
        this.loadPanoramaImage();
        this.submitAppInfo();
    }

    protected void onStop() {
        AppLog.d(TAG, "onStop");
        super.onStop();
        this.isAppBackground();
    }

    protected void onDestroy() {
        AppLog.d(TAG, "onDestroy");
        super.onDestroy();
        this.removeActivity();
    }

    protected void onPause() {
        super.onPause();
    }

    private void initClient() {
        LocalSession.getInstance().preparePanoramaSession();
        this.panoramaPhotoPlayback = LocalSession.getInstance().getPanoramaPhotoPlayback();
    }

    private void destroySession() {
        LocalSession.getInstance().destroyPanoramaSession();
    }

    void loadPanoramaImage() {
        this.loadPanoramaPhoto(new File(this.photoPath));
    }

    private void loadPanoramaPhoto(File file) {
        GlideUtils.getPanoramaBitmap((Context)this, file, new GlideUtils.GlideListener(){

            @Override
            public void onStart() {
            }

            @Override
            public void onComplete(Bitmap loadedImage) {
                if (loadedImage != null) {
                    SavePhotoActivity.this.panoramaPhotoPlayback.pancamGLSetFormat(130, loadedImage.getWidth(), loadedImage.getHeight());
                    SavePhotoActivity.this.panoramaPhotoPlayback.update(new ICatchGLImage(loadedImage));
                    SavePhotoActivity.this.insidePanorama();
                }
            }

            @Override
            public void onFailed() {
            }
        });
    }

    public void delete() {
        this.showDeleteEnsureDialog();
    }

    private void showDeleteEnsureDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setCancelable(false);
        builder.setTitle(R.string.image_delete_des);
        builder.setNegativeButton(R.string.gallery_delete, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                MyProgressDialog.showProgressDialog((Context)SavePhotoActivity.this, R.string.dialog_deleting);
                SavePhotoActivity.this.executor = Executors.newSingleThreadExecutor();
                SavePhotoActivity.this.executor.submit(new DeleteThread(), null);
            }
        });
        builder.setPositiveButton(R.string.gallery_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    public void setShowArea(Surface surface) {
        AppLog.d(TAG, "start initSurface");
        this.iCatchSurfaceContext = new ICatchSurfaceContext(surface);
        this.panoramaPhotoPlayback.setSurface(1, this.iCatchSurfaceContext);
        AppLog.d(TAG, "end initSurface");
    }

    public void insidePanorama() {
        this.locate(0.45454544f);
    }

    private void locate(float distance) {
        this.panoramaPhotoPlayback.pancamGLTransLocate(distance);
    }

    public void clearImage(int iCatchSphereType) {
        this.removeGyroscopeListener();
        if (this.panoramaPhotoPlayback != null) {
            if (this.iCatchSurfaceContext != null) {
                this.panoramaPhotoPlayback.removeSurface(iCatchSphereType, this.iCatchSurfaceContext);
                this.iCatchSurfaceContext = null;
            }
            this.panoramaPhotoPlayback.clear();
        }
    }

    public void destroyImage(int iCatchSphereType) {
        if (this.panoramaPhotoPlayback != null) {
            this.panoramaPhotoPlayback.clear();
            if (this.iCatchSurfaceContext != null) {
                this.panoramaPhotoPlayback.removeSurface(iCatchSphereType, this.iCatchSurfaceContext);
                this.iCatchSurfaceContext = null;
            }
            this.panoramaPhotoPlayback.release();
        }
    }

    public void finishActivity() {
        this.destroySession();
        if (PanoramaSDK.getInstance().isOneShoot()) {
            ExitApp.getInstance().exit();
        }
        this.finish();
    }

    public void rotateB(MotionEvent e, float prevX, float prevY) {
        ICatchGLPoint prev = new ICatchGLPoint(prevX, prevY);
        ICatchGLPoint curr = new ICatchGLPoint(e.getX(), e.getY());
        this.panoramaPhotoPlayback.pancamGLTransformRotate(prev, curr);
    }

    public void onSufaceViewTouchDown(MotionEvent event) {
        this.touchMode = TouchMode.DRAG;
        this.mPreviousY = event.getY();
        this.mPreviousX = event.getX();
        this.beforeLenght = 0.0f;
        this.afterLenght = 0.0f;
    }

    public void onSufaceViewPointerDown(MotionEvent event) {
        Log.d((String)"2222", (String)("event.getPointerCount()................=" + event.getPointerCount()));
        if (event.getPointerCount() == 2) {
            this.touchMode = TouchMode.ZOOM;
            this.beforeLenght = this.getDistance(event);
        }
    }

    public void onSufaceViewTouchMove(MotionEvent event) {
        if (this.touchMode == TouchMode.DRAG) {
            this.rotateB(event, this.mPreviousX, this.mPreviousY);
            this.mPreviousY = event.getY();
            this.mPreviousX = event.getX();
        } else if (this.touchMode == TouchMode.ZOOM) {
            this.afterLenght = this.getDistance(event);
            float gapLenght = this.afterLenght - this.beforeLenght;
            if (Math.abs(gapLenght) > 5.0f) {
                float scale_temp = this.afterLenght / this.beforeLenght;
                this.setScale(scale_temp);
                this.beforeLenght = this.afterLenght;
            }
        }
    }

    float getDistance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)StrictMath.sqrt(x * x + y * y);
    }

    void setScale(float scale) {
        if (this.currentZoomRate >= 2.2f && scale > 1.0f || this.currentZoomRate <= 0.5f && scale < 1.0f) {
            return;
        }
        float temp = this.currentZoomRate * scale;
        if (scale > 1.0f) {
            if (temp <= 2.2f) {
                this.currentZoomRate *= scale;
                this.zoom(this.currentZoomRate);
            } else {
                this.currentZoomRate = 2.2f;
                this.zoom(this.currentZoomRate);
            }
        } else if (scale < 1.0f) {
            if (temp >= 0.5f) {
                this.currentZoomRate *= scale;
                this.zoom(this.currentZoomRate);
            } else {
                this.currentZoomRate = 0.5f;
                this.zoom(this.currentZoomRate);
            }
        }
    }

    private void zoom(float currentZoomRate) {
        this.locate(1.0f / currentZoomRate);
    }

    public void onSufaceViewTouchUp() {
        this.touchMode = TouchMode.NONE;
    }

    public void onSufaceViewTouchPointerUp() {
        this.touchMode = TouchMode.NONE;
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor == null) {
            return;
        }
        if (event.sensor.getType() == 4) {
            float speedX = event.values[0];
            float speedY = event.values[1];
            float speedZ = event.values[2];
            if ((double)Math.abs(speedY) < 0.02 && (double)Math.abs(speedZ) < 0.02) {
                return;
            }
            this.rotate(speedX, speedY, speedZ, event.timestamp);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void rotate(float speedX, float speedY, float speedZ, long timestamp) {
        int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        this.panoramaPhotoPlayback.pancamGLTransformRotate(rotation, speedX, speedY, speedZ, timestamp);
    }

    public void registerGyroscopeSensor() {
        this.sensorManager = (SensorManager)this.getSystemService("sensor");
        this.gyroscopeSensor = this.sensorManager.getDefaultSensor(4);
        this.sensorManager.registerListener((SensorEventListener)this, this.gyroscopeSensor, 1);
    }

    public void removeGyroscopeListener() {
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
    }

    public void setDrawingArea(int windowW, int windowH) {
        AppLog.d(TAG, "start setDrawingArea windowW= " + windowW + " windowH= " + windowH);
        if (this.iCatchSurfaceContext != null) {
            try {
                this.iCatchSurfaceContext.setViewPort(0, 0, windowW, windowH);
            }
            catch (IchGLSurfaceNotSetException e) {
                e.printStackTrace();
            }
        }
        AppLog.d(TAG, "end setDrawingArea");
    }

    public void initPanorama() {
        this.panoramaPhotoPlayback.pancamGLInit();
    }

    public void initCfg() {
        GlobalInfo.getInstance().setCurrentApp((Activity)this);
        this.getWindow().setFlags(128, 128);
        this.getWindow().addFlags(1024);
    }

    public void isAppBackground() {
        if (AppInfo.isAppSentToBackground((Context)this)) {
            ExitApp.getInstance().exit();
        }
    }

    public void submitAppInfo() {
        GlobalInfo.getInstance().setCurrentApp((Activity)this);
        ExitApp.getInstance().addActivity((Activity)this);
    }

    public void removeActivity() {
        ExitApp.getInstance().removeActivity((Activity)this);
    }

    private void saveFile(File oldFile, String newName) {
        if (TextUtils.isEmpty((CharSequence)newName)) {
            newName = "Pano";
        }
        Pattern pattern = Pattern.compile("[\\s\\\\/:\\*\\?\\\"<>\\|]");
        Matcher matcher = pattern.matcher(newName);
        newName = matcher.replaceAll("");
        String uniquePath = FileTools.chooseUniqueFilename(Environment.getExternalStorageDirectory().toString() + "/DCIM/720Cam/720photo/" + newName + ".jpg");
        File newFile = new File(uniquePath);
        oldFile.renameTo(newFile);
        MediaRefresh.scanFileAsync((Context)this, newFile.getPath());
        this.finishActivity();
    }

    private void saveDialog(File oldFile) {
        this.saveFile(oldFile, CamPrefUtils.getPhotoName((Context)this));
    }

    private class DeleteThread
    implements Runnable {
        private DeleteThread() {
        }

        @Override
        public void run() {
            File tempFile = new File(SavePhotoActivity.this.photoPath);
            if (tempFile.exists()) {
                tempFile.delete();
                MediaRefresh.notifySystemToScan(tempFile);
            }
            SavePhotoActivity.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    MyProgressDialog.closeProgressDialog();
                    SavePhotoActivity.this.finishActivity();
                }
            });
            AppLog.d(TAG, "end DeleteThread");
        }
    }
}

