/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.util.LruCache;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.icatch.panorama.MyCamera.LocalSession;
import com.icatch.panorama.R;
import com.icatch.panorama.SdkApi.PanoramaPhotoPlayback;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import com.icatch.panorama.data.Mode.TouchMode;
import com.icatch.panorama.ui.ExtendComponent.MyProgressDialog;
import com.icatch.panorama.ui.activity.SavePhotoActivity;
import com.icatch.panorama.utils.BitmapTools;
import com.icatch.panorama.utils.CamPrefUtils;
import com.icatch.panorama.utils.FileOpertion.FileOper;
import com.icatch.panorama.utils.FileOpertion.FileTools;
import com.icatchtek.pancam.customer.exception.IchGLSurfaceNotSetException;
import com.icatchtek.pancam.customer.surface.ICatchSurfaceContext;
import com.icatchtek.pancam.customer.type.ICatchGLImage;
import com.icatchtek.pancam.customer.type.ICatchGLPoint;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jni.pano.JniTools;

public class SaveThumbActivity
extends AppCompatActivity
implements SensorEventListener,
View.OnClickListener {
    private SurfaceView mSurfaceView;
    private ImageButton back;
    private LinkedList<Asytask> asytaskList;
    private Asytask curAsytask;
    private LruCache<String, Bitmap> mLruCache;
    private ExecutorService executor;
    private Handler handler;
    private PanoramaPhotoPlayback panoramaPhotoPlayback;
    private static final float MIN_ZOOM = 0.5f;
    private static final float MAX_ZOOM = 2.2f;
    private static final float FIXED_INSIDE_DISTANCE = 0.45454544f;
    private TouchMode touchMode = TouchMode.NONE;
    private float mPreviousY;
    private float mPreviousX;
    private float beforeLenght;
    private float afterLenght;
    private float currentZoomRate = 2.2f;
    private SensorManager sensorManager;
    private Sensor gyroscopeSensor;
    private ICatchSurfaceContext iCatchSurfaceContext;
    private String photoPath;
    private TextView btn_del;
    private TextView btn_save;
    private TextView btn_stitch;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_thumb_save);
        this.initView();
        this.photoPath = this.getIntent().getStringExtra("path");
        this.mSurfaceView = (SurfaceView)this.findViewById(R.id.m_surfaceView);
        this.back = (ImageButton)this.findViewById(R.id.local_pb_back);
        this.handler = new Handler();
        this.initLruCache();
        this.initCfg();
        this.initClient();
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SaveThumbActivity.this.finishActivity();
            }
        });
        this.mSurfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                SaveThumbActivity.this.initPanorama();
                SaveThumbActivity.this.setShowArea(SaveThumbActivity.this.mSurfaceView.getHolder().getSurface(), SaveThumbActivity.this.mSurfaceView.getWidth(), SaveThumbActivity.this.mSurfaceView.getHeight());
                SaveThumbActivity.this.loadPanoramaImage();
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                SaveThumbActivity.this.setDrawingArea(width, height);
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
            }
        });
        this.mSurfaceView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        SaveThumbActivity.this.onSufaceViewTouchDown(event);
                        break;
                    }
                    case 1: {
                        SaveThumbActivity.this.onSufaceViewTouchUp();
                        break;
                    }
                    case 5: {
                        SaveThumbActivity.this.onSufaceViewPointerDown(event);
                        break;
                    }
                    case 6: {
                        SaveThumbActivity.this.onSufaceViewTouchPointerUp();
                        break;
                    }
                    case 2: {
                        SaveThumbActivity.this.onSufaceViewTouchMove(event);
                    }
                }
                return true;
            }
        });
        boolean formList = this.getIntent().getBooleanExtra("formList", false);
        if (formList) {
            this.btn_del.setText((CharSequence)"\u5220\u9664");
            this.btn_save.setVisibility(8);
            this.btn_stitch.setVisibility(0);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 3: {
                Log.d((String)"AppStart", (String)"home");
                break;
            }
            case 4: {
                break;
            }
            default: {
                return super.onKeyDown(keyCode, event);
            }
        }
        return true;
    }

    protected void onResume() {
        super.onResume();
        this.loadPanoramaImage();
    }

    protected void onPause() {
        super.onPause();
    }

    private void initClient() {
        LocalSession.getInstance().preparePanoramaSession();
        this.panoramaPhotoPlayback = LocalSession.getInstance().getPanoramaPhotoPlayback();
    }

    private void destroySession() {
        LocalSession.getInstance().destroyPanoramaSession();
    }

    private void initLruCache() {
        int maxMemory = (int)Runtime.getRuntime().maxMemory();
        int cacheMemory = maxMemory / 16;
        this.mLruCache = new LruCache<String, Bitmap>(cacheMemory){

            protected int sizeOf(String key, Bitmap value) {
                return value.getByteCount();
            }

            protected void entryRemoved(boolean evicted, String key, Bitmap oldValue, Bitmap newValue) {
                super.entryRemoved(evicted, (Object)key, (Object)oldValue, (Object)newValue);
                if (oldValue != null) {
                    oldValue.recycle();
                    oldValue = null;
                }
            }
        };
    }

    public Bitmap getBitmapFromLruCache(String fileName) {
        return (Bitmap)this.mLruCache.get((Object)fileName);
    }

    protected void addBitmapToLruCache(String fileName, Bitmap bm) {
        if (bm == null) {
            return;
        }
        if (bm.getByteCount() > this.mLruCache.maxSize()) {
            return;
        }
        if (this.getBitmapFromLruCache(fileName) == null && bm != null && fileName != null) {
            this.mLruCache.put((Object)fileName, (Object)bm);
        }
    }

    void loadPanoramaImage() {
        if (this.curAsytask != null && !this.curAsytask.isCancelled()) {
            this.curAsytask.cancel(true);
        }
        if (this.asytaskList == null) {
            this.asytaskList = new LinkedList();
        } else {
            this.asytaskList.clear();
        }
        Asytask task1 = new Asytask();
        this.asytaskList.add(task1);
        if (this.asytaskList != null && this.asytaskList.size() > 0) {
            this.curAsytask = this.asytaskList.removeFirst();
            this.curAsytask.execute(new String[0]);
        }
    }

    private void initView() {
        this.btn_del = (TextView)this.findViewById(R.id.btn_del);
        this.btn_save = (TextView)this.findViewById(R.id.btn_save);
        this.btn_stitch = (TextView)this.findViewById(R.id.btn_stitch);
        this.btn_del.setOnClickListener((View.OnClickListener)this);
        this.btn_save.setOnClickListener((View.OnClickListener)this);
        this.btn_stitch.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btn_del) {
            this.delete();
        } else if (v.getId() == R.id.btn_save) {
            this.finishActivity();
        } else if (v.getId() == R.id.btn_stitch) {
            MyProgressDialog.showProgressDialog((Context)this, "\u5408\u6210\u4e2d...");
            new Thread(new DownloadThread()).start();
        }
    }

    public void delete() {
        this.showDeleteEnsureDialog();
    }

    private void showDeleteEnsureDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setCancelable(false);
        builder.setTitle((CharSequence)"\u786e\u8ba4\u4e22\u5f03\u8fd9\u5f20\u7167\u7247\u5417\uff1f");
        builder.setNegativeButton(R.string.gallery_delete, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                MyProgressDialog.showProgressDialog((Context)SaveThumbActivity.this, R.string.dialog_deleting);
                SaveThumbActivity.this.asytaskList.clear();
                SaveThumbActivity.this.executor = Executors.newSingleThreadExecutor();
                SaveThumbActivity.this.executor.submit(new DeleteThread(), null);
            }
        });
        builder.setPositiveButton(R.string.gallery_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    public void setShowArea(Surface surface, int width, int height) {
        this.iCatchSurfaceContext = new ICatchSurfaceContext(surface);
        this.panoramaPhotoPlayback.setSurface(1, this.iCatchSurfaceContext);
        try {
            this.iCatchSurfaceContext.setViewPort(0, 0, width, height);
        }
        catch (IchGLSurfaceNotSetException e) {
            e.printStackTrace();
        }
        this.panoramaPhotoPlayback.pancamGLSetFormat(130, BitmapTools.getImageWidth(this.photoPath), BitmapTools.getImageHeight(this.photoPath));
    }

    public void startRendering(ICatchGLImage image) {
        if (this.panoramaPhotoPlayback == null) {
            return;
        }
        this.panoramaPhotoPlayback.update(image);
        this.insidePanorama();
    }

    public void stopRendering() {
        if (this.panoramaPhotoPlayback == null) {
            return;
        }
        this.panoramaPhotoPlayback.clear();
    }

    public void insidePanorama() {
        this.locate(0.45454544f);
    }

    private void locate(float distance) {
        this.panoramaPhotoPlayback.pancamGLTransLocate(distance);
    }

    public void destroyImage(int iCatchSphereType) {
        if (this.panoramaPhotoPlayback != null) {
            this.panoramaPhotoPlayback.clear();
            if (this.iCatchSurfaceContext != null) {
                this.panoramaPhotoPlayback.removeSurface(iCatchSphereType, this.iCatchSurfaceContext);
                this.iCatchSurfaceContext = null;
            }
            this.panoramaPhotoPlayback.release();
        }
    }

    public void finishActivity() {
        this.destroyImage(1);
        this.destroySession();
        this.finish();
    }

    public void rotateB(MotionEvent e, float prevX, float prevY) {
        ICatchGLPoint prev = new ICatchGLPoint(prevX, prevY);
        ICatchGLPoint curr = new ICatchGLPoint(e.getX(), e.getY());
        this.panoramaPhotoPlayback.pancamGLTransformRotate(prev, curr);
    }

    public void onSufaceViewTouchDown(MotionEvent event) {
        this.touchMode = TouchMode.DRAG;
        this.mPreviousY = event.getY();
        this.mPreviousX = event.getX();
        this.beforeLenght = 0.0f;
        this.afterLenght = 0.0f;
    }

    public void onSufaceViewPointerDown(MotionEvent event) {
        Log.d((String)"2222", (String)("event.getPointerCount()................=" + event.getPointerCount()));
        if (event.getPointerCount() == 2) {
            this.touchMode = TouchMode.ZOOM;
            this.beforeLenght = this.getDistance(event);
        }
    }

    public void onSufaceViewTouchMove(MotionEvent event) {
        if (this.touchMode == TouchMode.DRAG) {
            this.rotateB(event, this.mPreviousX, this.mPreviousY);
            this.mPreviousY = event.getY();
            this.mPreviousX = event.getX();
        } else if (this.touchMode == TouchMode.ZOOM) {
            this.afterLenght = this.getDistance(event);
            float gapLenght = this.afterLenght - this.beforeLenght;
            if (Math.abs(gapLenght) > 5.0f) {
                float scale_temp = this.afterLenght / this.beforeLenght;
                this.setScale(scale_temp);
                this.beforeLenght = this.afterLenght;
            }
        }
    }

    float getDistance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)StrictMath.sqrt(x * x + y * y);
    }

    void setScale(float scale) {
        if (this.currentZoomRate >= 2.2f && scale > 1.0f || this.currentZoomRate <= 0.5f && scale < 1.0f) {
            return;
        }
        float temp = this.currentZoomRate * scale;
        if (scale > 1.0f) {
            if (temp <= 2.2f) {
                this.currentZoomRate *= scale;
                this.zoom(this.currentZoomRate);
            } else {
                this.currentZoomRate = 2.2f;
                this.zoom(this.currentZoomRate);
            }
        } else if (scale < 1.0f) {
            if (temp >= 0.5f) {
                this.currentZoomRate *= scale;
                this.zoom(this.currentZoomRate);
            } else {
                this.currentZoomRate = 0.5f;
                this.zoom(this.currentZoomRate);
            }
        }
    }

    private void zoom(float currentZoomRate) {
        this.locate(1.0f / currentZoomRate);
    }

    public void onSufaceViewTouchUp() {
        this.touchMode = TouchMode.NONE;
    }

    public void onSufaceViewTouchPointerUp() {
        this.touchMode = TouchMode.NONE;
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor == null) {
            return;
        }
        if (event.sensor.getType() == 4) {
            float speedX = event.values[0];
            float speedY = event.values[1];
            float speedZ = event.values[2];
            if ((double)Math.abs(speedY) < 0.02 && (double)Math.abs(speedZ) < 0.02) {
                return;
            }
            this.rotate(speedX, speedY, speedZ, event.timestamp);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void rotate(float speedX, float speedY, float speedZ, long timestamp) {
        int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        this.panoramaPhotoPlayback.pancamGLTransformRotate(rotation, speedX, speedY, speedZ, timestamp);
    }

    public void registerGyroscopeSensor() {
        this.sensorManager = (SensorManager)this.getSystemService("sensor");
        this.gyroscopeSensor = this.sensorManager.getDefaultSensor(4);
        this.sensorManager.registerListener((SensorEventListener)this, this.gyroscopeSensor, 1);
    }

    public void removeGyroscopeListener() {
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
    }

    public void setDrawingArea(int windowW, int windowH) {
        Bitmap bitmap;
        if (this.iCatchSurfaceContext != null) {
            try {
                this.iCatchSurfaceContext.setViewPort(0, 0, windowW, windowH);
            }
            catch (IchGLSurfaceNotSetException e) {
                e.printStackTrace();
            }
        }
        if ((bitmap = this.getBitmapFromLruCache(this.photoPath)) != null) {
            this.panoramaPhotoPlayback.update(new ICatchGLImage(bitmap));
        }
    }

    public void initPanorama() {
        this.panoramaPhotoPlayback.pancamGLInit();
    }

    public void initCfg() {
        GlobalInfo.getInstance().setCurrentApp((Activity)this);
        this.getWindow().setFlags(128, 128);
        this.getWindow().addFlags(1024);
    }

    private class DownloadThread
    implements Runnable {
        private DownloadThread() {
        }

        @Override
        public void run() {
            File folder = new File(SaveThumbActivity.this.photoPath).getParentFile();
            File tmpFolder = new File(folder, "temp");
            File[] paths = tmpFolder.listFiles();
            ArrayList<String> cachePaths = new ArrayList<String>();
            for (File f : paths) {
                cachePaths.add(f.getPath());
            }
            Collections.sort(cachePaths);
            final File panoFile = new File(folder.getParentFile(), "pano.jpg");
            ArrayList<String> merges = new ArrayList<String>();
            JniTools.mixMultipleImgs((String)cachePaths.get(0), 3);
            merges.add(((String)cachePaths.get(0)).replace("SA", "WL"));
            merges.add(((String)cachePaths.get(1)).replace("SA", "WL"));
            merges.add(((String)cachePaths.get(2)).replace("SA", "WL"));
            merges.add(((String)cachePaths.get(3)).replace("SA", "WL"));
            File binFile = new File(folder, "stitch.bin");
            JniTools.setProcessResolution(8000, 4000);
            String[] images = merges.toArray(new String[merges.size()]);
            JniTools.setInputPaths(images);
            JniTools.setOutputPath(panoFile.getPath());
            JniTools.stitch(binFile.getPath());
            JniTools.saveFinalImg();
            File txtFile = new File(folder, "name.txt");
            String photoName = FileOper.getTxtContent(txtFile.getPath());
            if (TextUtils.isEmpty((CharSequence)photoName)) {
                photoName = folder.getName();
            }
            CamPrefUtils.setPhotoName((Context)SaveThumbActivity.this, photoName);
            if (panoFile.exists()) {
                FileTools.deleteFile(folder);
                SaveThumbActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        MyProgressDialog.closeProgressDialog();
                        Intent intent = new Intent((Context)SaveThumbActivity.this, SavePhotoActivity.class);
                        intent.putExtra("path", panoFile.getPath());
                        SaveThumbActivity.this.startActivity(intent);
                        SaveThumbActivity.this.finishActivity();
                    }
                });
            }
        }
    }

    private class DeleteThread
    implements Runnable {
        private DeleteThread() {
        }

        @Override
        public void run() {
            File folder = new File(SaveThumbActivity.this.photoPath).getParentFile();
            FileTools.deleteFile(folder);
            SaveThumbActivity.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    MyProgressDialog.closeProgressDialog();
                    SaveThumbActivity.this.finishActivity();
                }
            });
        }
    }

    class Asytask
    extends AsyncTask<String, Integer, Bitmap> {
        protected Bitmap doInBackground(String ... params) {
            Bitmap bm = SaveThumbActivity.this.getBitmapFromLruCache(SaveThumbActivity.this.photoPath);
            if (bm != null) {
                return bm;
            }
            bm = BitmapTools.getImageByPath(SaveThumbActivity.this.photoPath, BitmapTools.getImageWidth(SaveThumbActivity.this.photoPath), BitmapTools.getImageHeight(SaveThumbActivity.this.photoPath));
            if (bm != null) {
                SaveThumbActivity.this.addBitmapToLruCache(SaveThumbActivity.this.photoPath, bm);
            }
            return bm;
        }

        protected void onProgressUpdate(Integer ... progress) {
        }

        protected void onPostExecute(Bitmap result) {
            if (result == null) {
                SaveThumbActivity.this.finishActivity();
                return;
            }
            SaveThumbActivity.this.panoramaPhotoPlayback.pancamGLSetFormat(130, result.getWidth(), result.getHeight());
            SaveThumbActivity.this.startRendering(new ICatchGLImage(result));
        }
    }
}

