/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.text.TextUtils;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.icatch.panorama.Application.PanoramaSDK;
import com.icatch.panorama.CameraConstants;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.R;
import com.icatch.panorama.SdkApi.FileOperation;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.SystemInfo.MWifiManager;
import com.icatch.panorama.data.SystemInfo.SystemInfo;
import com.icatch.panorama.ui.ExtendComponent.MyToast;
import com.icatch.panorama.ui.activity.SaveThumbActivity;
import com.icatch.panorama.utils.CamPrefUtils;
import com.icatch.panorama.utils.FileOpertion.FileOper;
import com.icatch.panorama.utils.FileOpertion.FileTools;
import com.icatch.panorama.utils.VoiceUtils;
import com.icatchtek.reliant.customer.type.ICatchFile;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jni.pano.JniTools;

public class ThumbActivity
extends AppCompatActivity {
    private ExecutorService executor;
    private Future<Object> future;
    private Handler handler = new Handler();
    private Context activity;
    private FileOperation fileOperation = CameraManager.getInstance().getCurCamera().getFileOperation();
    private List<ICatchFile> downFileList = new ArrayList<ICatchFile>();
    private String path;
    private boolean isFromSDK;
    private int amount = CameraConstants.PICTURE_AMOUNT;
    private long calcTime;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setFlags(128, 128);
        this.setContentView(R.layout.activity_composite);
        this.activity = this;
        this.isFromSDK = !TextUtils.isEmpty((CharSequence)PanoramaSDK.getInstance().getOutputFolder());
        List<ICatchFile> remoteFiles = this.fileOperation.getFileList(1);
        if (remoteFiles.size() < this.amount) {
            Toast.makeText((Context)this, (CharSequence)"\u62cd\u6444\u6570\u91cf\u9519\u8bef!", (int)0).show();
            this.finish();
            return;
        }
        long size = 0L;
        for (int i = 0; i < this.amount; ++i) {
            size += remoteFiles.get(i).getFileSize();
            this.downFileList.add(remoteFiles.get(i));
        }
        if (SystemInfo.getSDFreeSize() < size) {
            MyToast.show((Context)this, R.string.text_sd_card_memory_shortage);
        } else {
            this.executor = Executors.newSingleThreadExecutor();
            this.future = this.executor.submit(new DownloadThread(), null);
        }
    }

    private class DownloadThread
    implements Runnable {
        private DownloadThread() {
        }

        @Override
        public void run() {
            AppInfo.isDownloading = true;
            if (!Environment.getExternalStorageState().equals("mounted")) {
                ThumbActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        MyToast.show(ThumbActivity.this.activity, R.string.message_download_failed);
                        ThumbActivity.this.finish();
                    }
                });
                return;
            }
            ThumbActivity.this.path = ThumbActivity.this.activity.getExternalCacheDir().getPath() + "/" + "pano" + "/" + ThumbActivity.this.sdf.format(new Date());
            ThumbActivity.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    VoiceUtils.getVoiceUtils((Context)ThumbActivity.this).playVoice("\u5168\u666f\u626b\u63cf.mp3");
                }
            });
            ArrayList<String> cachePaths = new ArrayList<String>();
            FileOper.createDirectory(ThumbActivity.this.path);
            FileOper.createDirectory(ThumbActivity.this.path + "/" + "temp");
            for (ICatchFile ic : ThumbActivity.this.downFileList) {
                String fileName = ic.getFileName();
                String cachePath = FileTools.chooseUniqueFilename(ThumbActivity.this.path + "/" + "temp" + "/" + fileName);
                cachePaths.add(cachePath);
                boolean temp = ThumbActivity.this.fileOperation.downloadFile(ic, cachePath);
                if (temp) continue;
                ThumbActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        MyToast.show(ThumbActivity.this.activity, R.string.message_download_failed);
                        ThumbActivity.this.finish();
                    }
                });
                AppInfo.isDownloading = false;
                return;
            }
            AppInfo.isDownloading = false;
            CameraManager.getInstance().getCurCamera().getCameraAction().formatStorage();
            final File panoFile = new File(ThumbActivity.this.path, "thumb.jpg");
            if (cachePaths.size() == ThumbActivity.this.amount) {
                Collections.sort(cachePaths);
                ThumbActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        VoiceUtils.getVoiceUtils((Context)ThumbActivity.this).playVoice("\u5168\u666f\u626b\u63cf.mp3");
                    }
                });
                File binFolder = new File(PanoramaSDK.getContext().getExternalFilesDir(null), "/SmartPano/");
                if (!binFolder.exists()) {
                    binFolder.mkdirs();
                }
                File binFile = new File(binFolder, MWifiManager.getSsid((Context)ThumbActivity.this) + ".bin");
                File newBin = new File(ThumbActivity.this.path, "stitch.bin");
                File nameTxt = new File(ThumbActivity.this.path, "name.txt");
                FileOper.writeTxtToFile(CamPrefUtils.getPhotoName((Context)ThumbActivity.this), nameTxt.getPath());
                FileTools.copyFile(binFile.getPath(), newBin.getPath());
                JniTools.setProcessResolution(1000, 500);
                String[] images = new String[]{(String)cachePaths.get(1), (String)cachePaths.get(4), (String)cachePaths.get(7), (String)cachePaths.get(10)};
                JniTools.setInputPaths(images);
                JniTools.setOutputPath(panoFile.getPath());
                JniTools.stitch(binFile.getPath());
                JniTools.saveFinalImg();
            }
            if (panoFile.exists()) {
                ThumbActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        VoiceUtils.getVoiceUtils((Context)ThumbActivity.this).playVoice("\u62cd\u6444\u5b8c\u6210.mp3");
                        Intent intent = new Intent((Context)ThumbActivity.this, SaveThumbActivity.class);
                        intent.putExtra("path", panoFile.getPath());
                        ThumbActivity.this.startActivity(intent);
                        ThumbActivity.this.finish();
                    }
                });
            }
        }
    }
}

