/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PointF;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageButton;
import androidx.appcompat.app.AppCompatActivity;
import com.davemorrissey.labs.subscaleview.ImageSource;
import com.davemorrissey.labs.subscaleview.ImageViewState;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.icatch.panorama.Application.PanoramaSDK;
import com.icatch.panorama.Listener.PanoramaCallback;
import com.icatch.panorama.R;
import com.icatch.panorama.data.GlobalApp.ExitApp;
import java.io.File;

public class ViewPhotoActivity
extends AppCompatActivity
implements View.OnClickListener {
    private ImageButton local_photo_pb_delete;
    private ImageButton local_photo_pb_share;
    private String path;
    private SubsamplingScaleImageView scale_view;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_view_photo);
        this.initView();
        this.path = this.getIntent().getStringExtra("path");
        this.scale_view.setMaxScale(10.0f);
        float scale = ViewPhotoActivity.getImageScale((Context)this, this.path);
        this.scale_view.setImage(ImageSource.uri((String)this.path), new ImageViewState(scale, new PointF(0.0f, 0.0f), 0));
    }

    private void initView() {
        this.local_photo_pb_delete = (ImageButton)this.findViewById(R.id.local_photo_pb_delete);
        this.local_photo_pb_share = (ImageButton)this.findViewById(R.id.local_photo_pb_share);
        this.local_photo_pb_delete.setOnClickListener((View.OnClickListener)this);
        this.local_photo_pb_share.setOnClickListener((View.OnClickListener)this);
        this.scale_view = (SubsamplingScaleImageView)this.findViewById(R.id.scale_view);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.local_photo_pb_delete) {
            this.delPano();
        } else if (v.getId() == R.id.local_photo_pb_share) {
            PanoramaCallback callback = PanoramaSDK.getInstance().getCallback();
            if (callback != null) {
                callback.onCapture(this.path);
            }
            if (PanoramaSDK.getInstance().isOneShoot()) {
                ExitApp.getInstance().exit();
            }
            this.finish();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.delPano();
        }
        return super.onKeyDown(keyCode, event);
    }

    private void delPano() {
        new File(this.path).delete();
        this.finish();
    }

    public static float getImageScale(Context context, String imagePath) {
        if (TextUtils.isEmpty((CharSequence)imagePath)) {
            return 2.0f;
        }
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeFile((String)imagePath);
        }
        catch (OutOfMemoryError error) {
            error.printStackTrace();
        }
        if (bitmap == null) {
            return 2.0f;
        }
        int dw = bitmap.getWidth();
        int dh = bitmap.getHeight();
        WindowManager wm = ((Activity)context).getWindowManager();
        int width = wm.getDefaultDisplay().getWidth();
        int height = wm.getDefaultDisplay().getHeight();
        float scale = 1.0f;
        if (dw > width && dh <= height) {
            scale = (float)width * 1.0f / (float)dw;
        }
        if (dw <= width && dh > height) {
            scale = (float)width * 1.0f / (float)dw;
        }
        if (dw < width && dh < height) {
            scale = (float)width * 1.0f / (float)dw;
        }
        if (dw > width && dh > height) {
            scale = (float)width * 1.0f / (float)dw;
        }
        bitmap.recycle();
        return scale;
    }
}

