/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.icatch.panorama.R;
import com.icatch.panorama.utils.WifiAPUtil;

public class WifiApActivity
extends AppCompatActivity {
    private String TAG = "WifiApActivity";
    public static final boolean DEBUG = true;
    private Button mBtStartWifiAp;
    private Button mBtStopWifiAp;
    private EditText mWifiSsid;
    private EditText mWifiPassword;
    private RadioGroup mRgWifiSerurity;
    private RadioButton mRdNo;
    private RadioButton mRdWpa;
    private RadioButton mRdWpa2;
    private TextView mWifiApState;
    private WifiAPUtil.WifiSecurityType mWifiType = WifiAPUtil.WifiSecurityType.WIFICIPHER_NOPASS;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            Log.i((String)WifiApActivity.this.TAG, (String)("WifiApActivity message.what=" + msg.what));
            switch (msg.what) {
                case 1: {
                    String ssid = WifiAPUtil.getInstance((Context)WifiApActivity.this).getValidApSsid();
                    String pw = WifiAPUtil.getInstance((Context)WifiApActivity.this).getValidPassword();
                    int security = WifiAPUtil.getInstance((Context)WifiApActivity.this).getValidSecurity();
                    WifiApActivity.this.mWifiApState.setText((CharSequence)("wifi\u70ed\u70b9\u5f00\u542f\u6210\u529f\nSSID = " + ssid + "\nPassword = " + pw + "\nSecurity = " + security));
                    break;
                }
                case 2: {
                    WifiApActivity.this.mWifiApState.setText((CharSequence)"wifi\u70ed\u70b9\u5173\u95ed");
                    break;
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_wifi_ap);
        WifiAPUtil.getInstance(this.getApplicationContext());
        WifiAPUtil.getInstance((Context)this).regitsterHandler(this.mHandler);
        this.mBtStartWifiAp = (Button)this.findViewById(R.id.bt_start_wifiap);
        this.mWifiSsid = (EditText)this.findViewById(R.id.et_ssid);
        this.mWifiPassword = (EditText)this.findViewById(R.id.et_password);
        this.mRgWifiSerurity = (RadioGroup)this.findViewById(R.id.rg_security);
        this.mRdNo = (RadioButton)this.findViewById(R.id.rd_no);
        this.mRdWpa = (RadioButton)this.findViewById(R.id.rd_wpa);
        this.mRdWpa2 = (RadioButton)this.findViewById(R.id.rd_wpa2);
        this.mWifiApState = (TextView)this.findViewById(R.id.tv_state);
        this.mBtStopWifiAp = (Button)this.findViewById(R.id.bt_stop_wifiap);
    }

    protected void onResume() {
        super.onResume();
        this.mRgWifiSerurity.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup arg0, int arg1) {
                if (arg1 == WifiApActivity.this.mRdNo.getId()) {
                    WifiApActivity.this.mWifiType = WifiAPUtil.WifiSecurityType.WIFICIPHER_NOPASS;
                } else if (arg1 == WifiApActivity.this.mRdWpa.getId()) {
                    WifiApActivity.this.mWifiType = WifiAPUtil.WifiSecurityType.WIFICIPHER_WPA;
                } else if (arg1 == WifiApActivity.this.mRdWpa2.getId()) {
                    WifiApActivity.this.mWifiType = WifiAPUtil.WifiSecurityType.WIFICIPHER_WPA2;
                }
                Log.i((String)WifiApActivity.this.TAG, (String)("radio check mWifiType = " + (Object)((Object)WifiApActivity.this.mWifiType)));
            }
        });
        this.mBtStartWifiAp.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                String ssid = WifiApActivity.this.mWifiSsid.getText().toString();
                String password = WifiApActivity.this.mWifiPassword.getText().toString();
                Log.d((String)WifiApActivity.this.TAG, (String)("ssid = " + ssid + "password = " + password));
                if (null == ssid || "".equals(ssid)) {
                    Toast.makeText((Context)WifiApActivity.this, (CharSequence)"\u8bf7\u8f93\u5165ssid", (int)0).show();
                    return;
                }
                WifiApActivity.this.mWifiApState.setText((CharSequence)"\u6b63\u5728\u5f00\u542f");
                WifiAPUtil.getInstance((Context)WifiApActivity.this).turnOnWifiAp(ssid, password, WifiApActivity.this.mWifiType);
            }
        });
        this.mBtStopWifiAp.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WifiAPUtil.getInstance((Context)WifiApActivity.this).closeWifiAp();
            }
        });
    }

    public void onBackPressed() {
        super.onBackPressed();
        Log.i((String)this.TAG, (String)"WifiApActivity onBackPressed");
        this.finish();
    }

    protected void onStop() {
        super.onStop();
        Log.i((String)this.TAG, (String)"WifiApActivity onStop");
    }

    protected void onDestroy() {
        super.onDestroy();
        Log.i((String)this.TAG, (String)"WifiApActivity onDestroy");
        WifiAPUtil.getInstance((Context)this).unregitsterHandler();
    }
}

