/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.icatch.panorama.R;
import com.icatch.panorama.data.entity.BluetoothAppDevice;
import java.util.List;

public class BlueToothListAdapter
extends BaseAdapter {
    LayoutInflater inflater;
    private Context context;
    private List<BluetoothAppDevice> list;
    private boolean isBLE;

    public BlueToothListAdapter(Context context, List<BluetoothAppDevice> list, boolean isBLE) {
        this.inflater = LayoutInflater.from((Context)context);
        this.list = list;
        this.context = context;
        this.isBLE = isBLE;
    }

    public int getCount() {
        return this.list.size();
    }

    public Object getItem(int position) {
        return position;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View view = null;
        view = this.inflater.inflate(R.layout.bluetooth_status, null);
        String name = this.list.get(position).getBluetoothName();
        if (name == null) {
            name = "Unknown";
        }
        TextView bluetoothName = (TextView)view.findViewById(R.id.bluetooth_name);
        bluetoothName.setText((CharSequence)name);
        TextView bluetoothMac = (TextView)view.findViewById(R.id.bluetooth_mac);
        bluetoothMac.setText((CharSequence)this.list.get(position).getBluetoothAddr());
        TextView bluetoothConnect = (TextView)view.findViewById(R.id.bluetooth_connect);
        if (!this.isBLE) {
            bluetoothConnect.setVisibility(0);
            if (this.list.get(position).getBluetoothConnect()) {
                bluetoothConnect.setText((CharSequence)"Binded");
                bluetoothConnect.setTextColor(this.context.getResources().getColor(R.color.green));
            } else {
                bluetoothConnect.setText((CharSequence)"Unbinded");
                bluetoothConnect.setTextColor(this.context.getResources().getColor(R.color.red));
            }
        } else {
            bluetoothConnect.setVisibility(8);
        }
        return view;
    }
}

