/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.icatch.panorama.R;
import com.icatch.panorama.data.entity.CameraSlot;
import java.util.List;

public class CamAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<CameraSlot> camSlotList;
    private CameraClickListener mListener;

    public CamAdapter(List<CameraSlot> camSlotList) {
        this.camSlotList = camSlotList;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_rv_cam, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        final CameraSlot cameraSlot = this.camSlotList.get(position);
        holder.tv_cam_name.setText((CharSequence)cameraSlot.cameraName);
        if (cameraSlot.isReady) {
            holder.ll_bg.setBackgroundResource(R.mipmap.ic_cam_frame_bg_nor);
            holder.iv_cam_status.setImageResource(R.mipmap.ic_cam_connected);
            holder.iv_wifi_status.setVisibility(0);
            holder.iv_del.setVisibility(8);
            holder.tv_cam_status.setText((CharSequence)"\u76f8\u673a\u5df2\u8fde\u63a5");
            holder.tv_cam_status.setTextColor(Color.parseColor((String)"#FFF74548"));
        } else {
            holder.ll_bg.setBackgroundResource(R.mipmap.ic_cam_frame_bg_del);
            holder.iv_cam_status.setImageResource(R.mipmap.ic_cam_disconnected);
            holder.iv_wifi_status.setVisibility(4);
            holder.iv_del.setVisibility(0);
            holder.tv_cam_status.setText((CharSequence)"\u76f8\u673a\u672a\u8fde\u63a5");
            holder.tv_cam_status.setTextColor(Color.parseColor((String)"#FF858585"));
        }
        holder.iv_cam_status.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CamAdapter.this.mListener != null) {
                    CamAdapter.this.mListener.onConnect(cameraSlot);
                }
            }
        });
        holder.iv_del.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CamAdapter.this.mListener != null) {
                    CamAdapter.this.mListener.onDelete(cameraSlot);
                }
            }
        });
    }

    public int getItemCount() {
        return this.camSlotList == null ? 0 : this.camSlotList.size();
    }

    public void setListener(CameraClickListener listener) {
        this.mListener = listener;
    }

    public static interface CameraClickListener {
        public void onConnect(CameraSlot var1);

        public void onDelete(CameraSlot var1);
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        FrameLayout ll_bg;
        ImageView iv_cam_status;
        ImageView iv_wifi_status;
        TextView tv_cam_name;
        TextView tv_cam_status;
        ImageView iv_del;

        public ViewHolder(View view) {
            super(view);
            this.ll_bg = (FrameLayout)view.findViewById(R.id.ll_bg);
            this.iv_cam_status = (ImageView)view.findViewById(R.id.iv_cam_status);
            this.iv_wifi_status = (ImageView)view.findViewById(R.id.iv_wifi_status);
            this.tv_cam_name = (TextView)view.findViewById(R.id.tv_cam_name);
            this.tv_cam_status = (TextView)view.findViewById(R.id.tv_cam_status);
            this.iv_del = (ImageView)view.findViewById(R.id.iv_del);
        }
    }
}

