/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.adapter;

import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageButton;
import android.widget.TextView;
import com.icatch.panorama.R;
import com.icatch.panorama.data.entity.DownloadInfo;
import com.icatch.panorama.ui.ExtendComponent.NumberProgressBar;
import com.icatchtek.reliant.customer.type.ICatchFile;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;

public class DownloadManagerAdapter
extends BaseAdapter {
    private String TAG = "DownloadManagerAdapter";
    private Context context;
    private HashMap<ICatchFile, DownloadInfo> chooseListMap;
    private List<ICatchFile> actList;
    private Handler handler;
    private boolean isDownloadComplete = false;

    public DownloadManagerAdapter(Context context, HashMap<ICatchFile, DownloadInfo> downloadDataList, List<ICatchFile> actList, Handler handler) {
        this.context = context;
        this.chooseListMap = downloadDataList;
        this.actList = actList;
        this.handler = handler;
    }

    public int getCount() {
        return this.actList.size();
    }

    public Object getItem(int arg0) {
        return null;
    }

    public long getItemId(int arg0) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup arg2) {
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.context).inflate(R.layout.download, null);
        }
        if (position >= this.actList.size()) {
            return convertView;
        }
        this.isDownloadComplete = false;
        ImageButton cancelImv = (ImageButton)convertView.findViewById(R.id.doAction);
        TextView fileName = (TextView)convertView.findViewById(R.id.fileName);
        TextView downloadStatus = (TextView)convertView.findViewById(R.id.downloadStatus);
        fileName.setText((CharSequence)this.actList.get(position).getFileName());
        NumberProgressBar numberProgressBar = (NumberProgressBar)convertView.findViewById(R.id.numberbar);
        final ICatchFile downloadFile = this.actList.get(position);
        final DownloadInfo downloadInfo = this.chooseListMap.get(downloadFile);
        numberProgressBar.setProgress(downloadInfo.progress);
        DecimalFormat df = new DecimalFormat("#.#");
        String curFileLength = df.format((double)downloadInfo.curFileLength / 1024.0 / 1024.0) + "M";
        String fileSize = df.format((double)downloadInfo.fileSize / 1024.0 / 1024.0) + "M";
        if (downloadInfo.progress >= 100) {
            downloadStatus.setText((CharSequence)(curFileLength + "/" + fileSize));
            cancelImv.setImageResource(R.drawable.ic_done_cyan);
            cancelImv.setClickable(false);
            this.isDownloadComplete = true;
        } else if (downloadInfo.progress <= 0) {
            downloadStatus.setText((CharSequence)(curFileLength + "/" + fileSize));
            cancelImv.setImageResource(R.drawable.ic_close_black);
            this.isDownloadComplete = false;
        } else {
            downloadStatus.setText((CharSequence)(curFileLength + "/" + fileSize));
            cancelImv.setImageResource(R.drawable.ic_close_black);
            this.isDownloadComplete = false;
        }
        cancelImv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                if (downloadInfo.progress < 100) {
                    DownloadManagerAdapter.this.handler.obtainMessage(769, 0, 0, (Object)downloadFile).sendToTarget();
                }
            }
        });
        return convertView;
    }
}

