/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.icatch.panorama.R;
import com.icatch.panorama.data.Mode.OperationMode;
import com.icatch.panorama.data.entity.LocalPbItemInfo;
import com.icatch.panorama.data.type.FileType;
import com.icatch.panorama.utils.GlideUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class LocalMultiPbWallListAdapter
extends BaseAdapter {
    private String TAG = "LocalMultiPbWallListAdapter";
    private Context context;
    private List<LocalPbItemInfo> list;
    private OperationMode curMode = OperationMode.MODE_BROWSE;
    private FileType fileType;

    public LocalMultiPbWallListAdapter(Context context, List<LocalPbItemInfo> list, FileType fileType) {
        this.context = context;
        this.list = list;
        this.fileType = fileType;
    }

    public int getCount() {
        return this.list.size();
    }

    public Object getItem(int position) {
        return this.list.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        String curFileDate = this.list.get(position).getFileDate();
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.context).inflate(R.layout.item_local_photo_wall_list, null);
            holder = new ViewHolder(convertView);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.local_photo_name.setText((CharSequence)this.list.get(position).getFileName());
        holder.local_photo_size.setText((CharSequence)this.list.get(position).getFileSize());
        holder.local_photo_date.setText((CharSequence)this.list.get(position).getFileDateMMSS());
        if (this.fileType == FileType.FILE_PHOTO) {
            holder.video_sign.setVisibility(8);
        } else {
            holder.video_sign.setVisibility(0);
        }
        if (this.list.get(position).isPanorama()) {
            holder.is_panorama.setVisibility(8);
        } else {
            holder.is_panorama.setVisibility(8);
        }
        if (this.curMode == OperationMode.MODE_EDIT) {
            holder.local_photo_wall_list_edit.setVisibility(0);
            if (this.list.get((int)position).isItemChecked) {
                holder.local_photo_wall_list_edit.setImageResource(R.drawable.ic_check_box_blue);
            } else {
                holder.local_photo_wall_list_edit.setImageResource(R.drawable.ic_check_box_blank_grey);
            }
        } else {
            holder.local_photo_wall_list_edit.setVisibility(8);
        }
        if (position == 0 || !this.list.get(position - 1).getFileDate().equals(curFileDate)) {
            holder.mLayout.setVisibility(0);
            holder.photo_wall_header.setText((CharSequence)this.list.get(position).getFileDate());
        } else {
            holder.mLayout.setVisibility(8);
        }
        File file = this.list.get((int)position).file;
        if (file != null) {
            GlideUtils.loadImageViewLoding(this.context, file, holder.local_photo_thumbnail_list, R.drawable.pictures_no, R.drawable.pictures_no);
        }
        return convertView;
    }

    public void setOperationMode(OperationMode operationMode) {
        this.curMode = operationMode;
    }

    public void changeSelectionState(int position) {
        this.list.get((int)position).isItemChecked = !this.list.get((int)position).isItemChecked;
        this.notifyDataSetChanged();
    }

    public List<LocalPbItemInfo> getSelectedList() {
        LinkedList<LocalPbItemInfo> checkedList = new LinkedList<LocalPbItemInfo>();
        for (int ii = 0; ii < this.list.size(); ++ii) {
            if (!this.list.get((int)ii).isItemChecked) continue;
            checkedList.add(this.list.get(ii));
        }
        return checkedList;
    }

    public void quitEditMode() {
        this.curMode = OperationMode.MODE_BROWSE;
        for (int ii = 0; ii < this.list.size(); ++ii) {
            this.list.get((int)ii).isItemChecked = false;
        }
        this.notifyDataSetChanged();
    }

    public void selectAllItems() {
        for (int ii = 0; ii < this.list.size(); ++ii) {
            this.list.get((int)ii).isItemChecked = true;
        }
        this.notifyDataSetChanged();
    }

    public void cancelAllSelections() {
        for (int ii = 0; ii < this.list.size(); ++ii) {
            this.list.get((int)ii).isItemChecked = false;
        }
        this.notifyDataSetChanged();
    }

    public int getSelectedCount() {
        int checkedNum = 0;
        for (int ii = 0; ii < this.list.size(); ++ii) {
            if (!this.list.get((int)ii).isItemChecked) continue;
            ++checkedNum;
        }
        return checkedNum;
    }

    public static class ViewHolder {
        public View rootView;
        public TextView photo_wall_header;
        public ImageView local_photo_wall_list_edit;
        public ImageView local_photo_thumbnail_list;
        public ImageView video_sign;
        public ImageView is_panorama;
        public TextView local_photo_name;
        public TextView local_photo_size;
        public TextView local_photo_date;
        public RelativeLayout mLayout;

        public ViewHolder(View rootView) {
            this.rootView = rootView;
            this.photo_wall_header = (TextView)rootView.findViewById(R.id.photo_wall_header);
            this.local_photo_wall_list_edit = (ImageView)rootView.findViewById(R.id.local_photo_wall_list_edit);
            this.local_photo_thumbnail_list = (ImageView)rootView.findViewById(R.id.local_photo_thumbnail_list);
            this.video_sign = (ImageView)rootView.findViewById(R.id.video_sign);
            this.is_panorama = (ImageView)rootView.findViewById(R.id.is_panorama);
            this.local_photo_name = (TextView)rootView.findViewById(R.id.local_photo_name);
            this.local_photo_size = (TextView)rootView.findViewById(R.id.local_photo_size);
            this.local_photo_date = (TextView)rootView.findViewById(R.id.local_photo_date);
            this.mLayout = (RelativeLayout)rootView.findViewById(R.id.local_photo_wall_header_layout);
        }
    }
}

