/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.viewpager.widget.PagerAdapter;
import com.github.chrisbanes.photoview.PhotoView;
import com.icatch.panorama.R;
import com.icatch.panorama.data.entity.LocalPbItemInfo;
import com.icatch.panorama.ui.ExtendComponent.ProgressWheel;
import com.icatch.panorama.utils.GlideUtils;
import java.util.List;

public class LocalPhotoPbViewPagerAdapter
extends PagerAdapter {
    private static final String TAG = "PhotoPbViewPagerAdapter";
    private List<LocalPbItemInfo> filesList;
    private Context context;
    private OnPhotoTapListener onPhotoTapListener;

    public LocalPhotoPbViewPagerAdapter(Context context, List<LocalPbItemInfo> filesList) {
        this.filesList = filesList;
        this.context = context;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (position < this.filesList.size()) {
            container.removeView((View)object);
        }
    }

    public Object instantiateItem(ViewGroup container, int position) {
        View v = View.inflate((Context)this.context, (int)R.layout.pb_photo_item, null);
        LocalPbItemInfo itemInfo = this.filesList.get(position);
        final PhotoView photoView = (PhotoView)v.findViewById(R.id.photo);
        final ProgressWheel progressBar = (ProgressWheel)v.findViewById(R.id.progress_wheel);
        if (photoView != null && !itemInfo.isPanorama()) {
            GlideUtils.getPanoramaBitmap(this.context, itemInfo.file, new GlideUtils.GlideListener(){

                @Override
                public void onStart() {
                    progressBar.setVisibility(0);
                    progressBar.startSpinning();
                }

                @Override
                public void onComplete(Bitmap loadedImage) {
                    photoView.setImageBitmap(loadedImage);
                    progressBar.setVisibility(8);
                    progressBar.stopSpinning();
                }

                @Override
                public void onFailed() {
                    progressBar.setVisibility(8);
                    progressBar.stopSpinning();
                }
            });
            photoView.setOnPhotoTapListener(new com.github.chrisbanes.photoview.OnPhotoTapListener(){

                public void onPhotoTap(ImageView view, float x, float y) {
                    if (LocalPhotoPbViewPagerAdapter.this.onPhotoTapListener != null) {
                        LocalPhotoPbViewPagerAdapter.this.onPhotoTapListener.onPhotoTap();
                    }
                }
            });
        }
        container.addView(v, 0);
        return v;
    }

    public int getCount() {
        return this.filesList.size();
    }

    public boolean isViewFromObject(View arg0, Object arg1) {
        return arg0 == arg1;
    }

    public void setOnPhotoTapListener(OnPhotoTapListener onPhotoTapListener) {
        this.onPhotoTapListener = onPhotoTapListener;
    }

    public static interface OnPhotoTapListener {
        public void onPhotoTap();
    }
}

