/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.LruCache;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.icatch.panorama.R;
import com.icatch.panorama.data.Mode.OperationMode;
import com.icatch.panorama.data.entity.MultiPbItemInfo;
import com.icatch.panorama.data.type.FileType;
import java.util.LinkedList;
import java.util.List;

public class MultiPbPhotoWallListAdapter
extends BaseAdapter {
    private String TAG = "MultiPbPhotoWallListAdapter";
    private Context context;
    private List<MultiPbItemInfo> list;
    private OperationMode curMode = OperationMode.MODE_BROWSE;
    LruCache<Integer, Bitmap> mLruCache;
    private FileType fileType;

    public MultiPbPhotoWallListAdapter(Context context, List<MultiPbItemInfo> list, LruCache<Integer, Bitmap> mLruCache, FileType fileType) {
        this.context = context;
        this.list = list;
        this.mLruCache = mLruCache;
        this.fileType = fileType;
    }

    public int getCount() {
        return this.list.size();
    }

    public Object getItem(int position) {
        return this.list.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int fileHandle = this.list.get(position).getFileHandle();
        String curFileDate = this.list.get(position).getFileDate();
        View view = convertView == null ? LayoutInflater.from((Context)this.context).inflate(R.layout.item_local_photo_wall_list, null) : convertView;
        ImageView imageView = (ImageView)view.findViewById(R.id.local_photo_thumbnail_list);
        TextView mTextView = (TextView)view.findViewById(R.id.photo_wall_header);
        RelativeLayout mLayout = (RelativeLayout)view.findViewById(R.id.local_photo_wall_header_layout);
        TextView imageNameTextView = (TextView)view.findViewById(R.id.local_photo_name);
        TextView imageSizeTextView = (TextView)view.findViewById(R.id.local_photo_size);
        TextView imageDateTextView = (TextView)view.findViewById(R.id.local_photo_date);
        ImageView mCheckImageView = (ImageView)view.findViewById(R.id.local_photo_wall_list_edit);
        ImageView videoSignImageView = (ImageView)view.findViewById(R.id.video_sign);
        ImageView mIsPanoramaSign = (ImageView)view.findViewById(R.id.is_panorama);
        imageNameTextView.setText((CharSequence)this.list.get(position).getFileName());
        imageSizeTextView.setText((CharSequence)this.list.get(position).getFileSize());
        imageDateTextView.setText((CharSequence)this.list.get(position).getFileDateMMSS());
        if (this.fileType == FileType.FILE_PHOTO) {
            videoSignImageView.setVisibility(8);
        } else {
            videoSignImageView.setVisibility(0);
        }
        if (this.list.get(position).isPanorama()) {
            mIsPanoramaSign.setVisibility(0);
        } else {
            mIsPanoramaSign.setVisibility(8);
        }
        if (this.curMode == OperationMode.MODE_EDIT) {
            mCheckImageView.setVisibility(0);
            if (this.list.get((int)position).isItemChecked) {
                mCheckImageView.setImageResource(R.drawable.ic_check_box_blue);
            } else {
                mCheckImageView.setImageResource(R.drawable.ic_check_box_blank_grey);
            }
        } else {
            mCheckImageView.setVisibility(8);
        }
        imageView.setTag((Object)fileHandle);
        if (position == 0 || !this.list.get(position - 1).getFileDate().equals(curFileDate)) {
            mLayout.setVisibility(0);
            mTextView.setText((CharSequence)this.list.get(position).getFileDate());
        } else {
            mLayout.setVisibility(8);
        }
        Bitmap bitmap = (Bitmap)this.mLruCache.get((Object)fileHandle);
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        } else {
            imageView.setImageResource(R.drawable.pictures_no);
        }
        return view;
    }

    public void setOperationMode(OperationMode operationMode) {
        this.curMode = operationMode;
    }

    public void changeSelectionState(int position) {
        this.list.get((int)position).isItemChecked = !this.list.get((int)position).isItemChecked;
        this.notifyDataSetChanged();
    }

    public List<MultiPbItemInfo> getSelectedList() {
        LinkedList<MultiPbItemInfo> checkedList = new LinkedList<MultiPbItemInfo>();
        for (int ii = 0; ii < this.list.size(); ++ii) {
            if (!this.list.get((int)ii).isItemChecked) continue;
            checkedList.add(this.list.get(ii));
        }
        return checkedList;
    }

    public void quitEditMode() {
        this.curMode = OperationMode.MODE_BROWSE;
        for (int ii = 0; ii < this.list.size(); ++ii) {
            this.list.get((int)ii).isItemChecked = false;
        }
        this.notifyDataSetChanged();
    }

    public void selectAllItems() {
        for (int ii = 0; ii < this.list.size(); ++ii) {
            this.list.get((int)ii).isItemChecked = true;
        }
        this.notifyDataSetChanged();
    }

    public void cancelAllSelections() {
        for (int ii = 0; ii < this.list.size(); ++ii) {
            this.list.get((int)ii).isItemChecked = false;
        }
        this.notifyDataSetChanged();
    }

    public int getSelectedCount() {
        int checkedNum = 0;
        for (int ii = 0; ii < this.list.size(); ++ii) {
            if (!this.list.get((int)ii).isItemChecked) continue;
            ++checkedNum;
        }
        return checkedNum;
    }
}

