/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.LruCache;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.viewpager.widget.PagerAdapter;
import com.github.chrisbanes.photoview.PhotoView;
import com.icatch.panorama.R;
import com.icatch.panorama.data.entity.MultiPbItemInfo;
import com.icatch.panorama.ui.ExtendComponent.ProgressWheel;
import java.util.List;

public class PhotoPbViewPagerAdapter
extends PagerAdapter {
    private static final String TAG = "PhotoPbViewPagerAdapter";
    private List<MultiPbItemInfo> filesList;
    private Context context;
    LruCache<Integer, Bitmap> mLruCache;
    private List<View> viewList;
    private OnPhotoTapListener onPhotoTapListener;

    public PhotoPbViewPagerAdapter(Context context, List<MultiPbItemInfo> filesList, List<View> viewList, LruCache<Integer, Bitmap> mLruCache) {
        this.filesList = filesList;
        this.context = context;
        this.viewList = viewList;
        this.mLruCache = mLruCache;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (position < this.filesList.size()) {
            container.removeView((View)object);
        }
    }

    public Object instantiateItem(ViewGroup container, int position) {
        View v = View.inflate((Context)this.context, (int)R.layout.pb_photo_item, null);
        Bitmap bitmap = (Bitmap)this.mLruCache.get((Object)this.filesList.get(position).getFileHandle());
        PhotoView photoView = (PhotoView)v.findViewById(R.id.photo);
        ProgressWheel progressBar = (ProgressWheel)v.findViewById(R.id.progress_wheel);
        if (photoView != null) {
            photoView.setImageBitmap(bitmap);
            photoView.setOnPhotoTapListener(new com.github.chrisbanes.photoview.OnPhotoTapListener(){

                public void onPhotoTap(ImageView view, float x, float y) {
                    if (PhotoPbViewPagerAdapter.this.onPhotoTapListener != null) {
                        PhotoPbViewPagerAdapter.this.onPhotoTapListener.onPhotoTap();
                    }
                }
            });
        }
        this.viewList.set(position, v);
        container.addView(v, 0);
        return v;
    }

    public int getCount() {
        return this.filesList.size();
    }

    public boolean isViewFromObject(View arg0, Object arg1) {
        return arg0 == arg1;
    }

    public void setOnPhotoTapListener(OnPhotoTapListener onPhotoTapListener) {
        this.onPhotoTapListener = onPhotoTapListener;
    }

    public static interface OnPhotoTapListener {
        public void onPhotoTap();
    }
}

