/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.appdialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.R;
import com.icatch.panorama.data.GlobalApp.ExitApp;

public class AppDialog {
    private static final String tag = "AppDialog";
    private static boolean needShown = true;
    private static AlertDialog dialog;

    public void showDialog(String title, String message, boolean cancelable) {
    }

    public static void showDialogQuit(final Context context, final int messageID) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setIcon(R.drawable.warning).setTitle((CharSequence)"Warning").setMessage(messageID);
        builder.setCancelable(false);
        builder.setPositiveButton(R.string.dialog_btn_exit, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AppLog.i(AppDialog.tag, "ExitApp because of " + context.getResources().getString(messageID));
                ExitApp.getInstance().exit();
            }
        });
        builder.create().show();
    }

    public static void showDialogQuit(Context context, final String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setIcon(R.drawable.warning).setTitle((CharSequence)"Warning").setMessage((CharSequence)message);
        builder.setCancelable(false);
        builder.setPositiveButton(R.string.dialog_btn_exit, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AppLog.i(AppDialog.tag, "ExitApp because of " + message);
                ExitApp.getInstance().exit();
            }
        });
        builder.create().show();
    }

    public static void showDialogWarn(Context context, String message) {
        Activity activity;
        if (context instanceof Activity && ((activity = (Activity)context).isDestroyed() || activity.isFinishing())) {
            return;
        }
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setIcon(R.drawable.warning).setTitle((CharSequence)"Warning").setMessage((CharSequence)message);
        builder.setCancelable(true);
        builder.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        dialog = builder.create();
        dialog.show();
    }

    public static void showDialogWifi(final Context context, String message) {
        Activity activity;
        if (context instanceof Activity && ((activity = (Activity)context).isDestroyed() || activity.isFinishing())) {
            return;
        }
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setIcon(R.drawable.warning).setTitle((CharSequence)"\u63d0\u793a").setMessage((CharSequence)message);
        builder.setCancelable(true);
        builder.setPositiveButton((CharSequence)"\u53bb\u8fde\u63a5WIFI", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                context.startActivity(new Intent("android.settings.WIFI_SETTINGS"));
            }
        });
        dialog = builder.create();
        dialog.show();
    }

    public static void showDialogWarn(Context context, int messageID) {
        Activity activity;
        if (context instanceof Activity && ((activity = (Activity)context).isDestroyed() || activity.isFinishing())) {
            return;
        }
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setIcon(R.drawable.warning).setTitle((CharSequence)"Warning").setMessage(messageID);
        builder.setCancelable(true);
        builder.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        dialog = builder.create();
        dialog.show();
    }

    public static void showConectFailureWarning(Context context) {
        if (!needShown) {
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setIcon(R.drawable.warning).setTitle((CharSequence)"Warning").setMessage(R.string.dialog_connect_failed);
        builder.setPositiveButton(R.string.dialog_btn_exit, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ExitApp.getInstance().exit();
            }
        });
        builder.setCancelable(false);
        builder.setNegativeButton(R.string.dialog_btn_reconnect, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                needShown = true;
            }
        });
        builder.create().show();
    }

    public static void showLowBatteryWarning(Context context) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setIcon(R.drawable.warning).setTitle((CharSequence)"Warning").setMessage(R.string.low_battery);
        builder.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }
}

