/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.appdialog;

import android.content.Context;
import android.view.View;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import com.icatch.panorama.R;
import com.icatch.panorama.data.entity.DownloadInfo;
import com.icatch.panorama.ui.ExtendComponent.NumberProgressBar;
import com.icatchtek.reliant.customer.type.ICatchFile;
import java.text.DecimalFormat;

public class SingleDownloadDialog {
    private ImageButton exitBtn;
    TextView fileNameTxv;
    TextView fileDownloadStatus;
    NumberProgressBar numberProgressBar;
    AlertDialog.Builder builder;
    AlertDialog alertDialog;
    Context context;
    ICatchFile curVideoFile;

    public SingleDownloadDialog(Context context, ICatchFile iCatchFile) {
        this.context = context;
        this.curVideoFile = iCatchFile;
        this.builder = new AlertDialog.Builder(context);
        View contentView = View.inflate((Context)context, (int)R.layout.single_download_content_dialog, null);
        View titleView = View.inflate((Context)context, (int)R.layout.download_dialog_title, null);
        this.exitBtn = (ImageButton)titleView.findViewById(R.id.exit);
        this.fileNameTxv = (TextView)contentView.findViewById(R.id.fileName);
        this.fileDownloadStatus = (TextView)contentView.findViewById(R.id.downloadStatus);
        this.numberProgressBar = (NumberProgressBar)contentView.findViewById(R.id.numberbar);
        this.fileNameTxv.setText((CharSequence)this.curVideoFile.getFileName());
        this.builder.setCustomTitle(titleView);
        this.builder.setView(contentView);
        this.builder.setCancelable(false);
        this.alertDialog = this.builder.create();
    }

    public void showDownloadDialog() {
        if (this.alertDialog != null) {
            this.alertDialog.show();
        }
    }

    public void dismissDownloadDialog() {
        if (this.alertDialog != null) {
            this.alertDialog.dismiss();
        }
    }

    public void setBackBtnOnClickListener(View.OnClickListener onClickListener) {
        if (onClickListener != null) {
            this.exitBtn.setOnClickListener(onClickListener);
        }
    }

    public void updateDownloadStatus(DownloadInfo downloadInfo) {
        this.numberProgressBar.setProgress(downloadInfo.progress);
        DecimalFormat df = new DecimalFormat("#.#");
        String curFileLength = df.format((double)downloadInfo.curFileLength / 1024.0 / 1024.0) + "M";
        String fileSize = df.format((double)downloadInfo.fileSize / 1024.0 / 1024.0) + "M";
        this.fileDownloadStatus.setText((CharSequence)(curFileLength + "/" + fileSize));
    }
}

