/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Scroller;
import android.widget.TextView;
import com.icatch.panorama.R;
import com.icatch.panorama.ui.view.IndicatorUtils;

public class IndicatorScroller
extends ViewGroup {
    public Scroller mScroller;
    public int leftIndex;
    public int rightIndex;
    public int duration = 300;
    boolean isOnLayoutCalled;

    public IndicatorScroller(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mScroller = new Scroller(context);
    }

    public final void scrollToNext(int preIndex, int nextIndex) {
        TextView selectedText = (TextView)this.getChildAt(preIndex);
        if (selectedText != null) {
            selectedText.setTextColor(this.getResources().getColor(R.color.cameraIndexTextColor));
        }
        if ((selectedText = (TextView)this.getChildAt(nextIndex)) != null) {
            selectedText.setTextColor(this.getResources().getColor(R.color.cameraIndexPointColor));
        }
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            this.invalidate();
        }
        super.computeScroll();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        View childView;
        int i;
        if (this.isOnLayoutCalled) {
            return;
        }
        this.isOnLayoutCalled = true;
        int cCount = this.getChildCount();
        int childLeft = 0;
        int childRight = 0;
        int selectedMode = IndicatorUtils.getCurrentSelectedIndex();
        int widthOffset = 0;
        for (i = 0; i < cCount; ++i) {
            childView = this.getChildAt(i);
            childView.setTag((Object)i);
            childView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int position = (Integer)v.getTag();
                    System.out.println("click:" + position);
                }
            });
            if (i >= selectedMode) continue;
            widthOffset += childView.getMeasuredWidth();
        }
        for (i = 0; i < cCount; ++i) {
            childView = this.getChildAt(i);
            if (i != 0) {
                View preView = this.getChildAt(i - 1);
                childLeft = preView.getRight();
                childRight = childLeft + childView.getMeasuredWidth();
            } else {
                childLeft = (this.getWidth() - this.getChildAt(selectedMode).getMeasuredWidth()) / 2 - widthOffset;
                childRight = childLeft + childView.getMeasuredWidth();
            }
            childView.layout(childLeft, top, childRight, bottom);
        }
        TextView indexText = (TextView)this.getChildAt(selectedMode);
        indexText.setTextColor(this.getResources().getColor(R.color.cameraIndexPointColor));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }
}

