/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.icatch.panorama.R;
import com.icatch.panorama.ui.view.IndicatorScroller;
import com.icatch.panorama.ui.view.IndicatorUtils;

public class IndicatorView
extends LinearLayout {
    private IndicatorScroller mIndicatorScroller;
    private Context mContext;
    private OnSelectListener mListener;

    public IndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        LayoutInflater.from((Context)context).inflate(R.layout.camera_scroller_layout, (ViewGroup)this, true);
    }

    public void init(OnSelectListener listener) {
        this.mIndicatorScroller = (IndicatorScroller)this.findViewById(R.id.camera_scroller);
        this.mListener = listener;
    }

    public void moveLeft() {
        IndicatorScroller indicatorScroller = this.mIndicatorScroller;
        indicatorScroller.leftIndex = IndicatorUtils.getCurrentSelectedIndex() - 1;
        indicatorScroller.rightIndex = IndicatorUtils.getCurrentSelectedIndex();
        int k = Math.round((float)(indicatorScroller.getChildAt(indicatorScroller.leftIndex).getWidth() + indicatorScroller.getChildAt(indicatorScroller.rightIndex).getWidth()) / 2.0f);
        indicatorScroller.mScroller.startScroll(indicatorScroller.getScrollX(), 0, -k, 0, indicatorScroller.duration);
        indicatorScroller.scrollToNext(indicatorScroller.rightIndex, indicatorScroller.leftIndex);
        IndicatorUtils.setSelectedIndex(IndicatorUtils.getCurrentSelectedIndex() - 1);
        indicatorScroller.invalidate();
        if (this.mListener != null) {
            this.mListener.onSelect(IndicatorUtils.getCurrentSelectedIndex());
        }
    }

    public void moveRight() {
        IndicatorScroller indicatorScroller = this.mIndicatorScroller;
        indicatorScroller.leftIndex = IndicatorUtils.getCurrentSelectedIndex();
        indicatorScroller.rightIndex = IndicatorUtils.getCurrentSelectedIndex() + 1;
        int k = Math.round((float)(indicatorScroller.getChildAt(indicatorScroller.leftIndex).getWidth() + indicatorScroller.getChildAt(indicatorScroller.rightIndex).getWidth()) / 2.0f);
        indicatorScroller.mScroller.startScroll(indicatorScroller.getScrollX(), 0, k, 0, indicatorScroller.duration);
        indicatorScroller.scrollToNext(indicatorScroller.leftIndex, indicatorScroller.rightIndex);
        IndicatorUtils.setSelectedIndex(IndicatorUtils.getCurrentSelectedIndex() + 1);
        indicatorScroller.invalidate();
        if (this.mListener != null) {
            this.mListener.onSelect(IndicatorUtils.getCurrentSelectedIndex());
        }
    }

    public static interface OnSelectListener {
        public void onSelect(int var1);
    }
}

