/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.ui.view;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.os.Build;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.annotation.RequiresApi;

public class TextureVideoView
extends TextureView {
    private int mVideoWidth;
    private int mVideoHeight;
    private boolean DEBUG = false;
    private float rotateDegree = 90.0f;

    public TextureVideoView(Context context) {
        this(context, null);
    }

    public TextureVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TextureVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public TextureVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public float getRotateDegree() {
        return this.rotateDegree;
    }

    public void setRotateDegree(float rotateDegree) {
        this.rotateDegree = rotateDegree;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = TextureVideoView.getDefaultSize((int)this.mVideoWidth, (int)widthMeasureSpec);
        int height = TextureVideoView.getDefaultSize((int)this.mVideoHeight, (int)heightMeasureSpec);
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (this.mVideoWidth * height < width * this.mVideoHeight) {
                    width = height * this.mVideoWidth / this.mVideoHeight;
                } else if (this.mVideoWidth * height > width * this.mVideoHeight) {
                    height = width * this.mVideoHeight / this.mVideoWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * this.mVideoHeight / this.mVideoWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * this.mVideoWidth / this.mVideoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                }
            } else {
                width = this.mVideoWidth;
                height = this.mVideoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * this.mVideoWidth / this.mVideoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * this.mVideoHeight / this.mVideoWidth;
                }
            }
        }
        this.setMeasuredDimension(width, height);
    }

    public CharSequence getAccessibilityClassName() {
        return TextureVideoView.class.getName();
    }

    private void init() {
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(new TextureVideoViewOutlineProvider());
            this.setClipToOutline(true);
        }
    }

    public void setFixedSize(int width, int height) {
        if (this.mVideoWidth != width && this.mVideoHeight != height) {
            this.mVideoWidth = width;
            this.mVideoHeight = height;
            this.requestLayout();
        }
    }

    public void adjustAspectRatio(int videoWidth, int videoHeight) {
        int newHeight;
        int newWidth;
        double aspectRatio;
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        if (viewHeight > (int)((double)viewWidth * (aspectRatio = (double)videoHeight / (double)videoWidth))) {
            newWidth = viewWidth;
            newHeight = (int)((double)viewWidth * aspectRatio);
        } else {
            newWidth = (int)((double)viewHeight / aspectRatio);
            newHeight = viewHeight;
        }
        newHeight = videoHeight;
        newWidth = videoWidth;
        int xoff = (viewWidth - newWidth) / 2;
        int yoff = (viewHeight - newHeight) / 2;
        final Matrix txform = new Matrix();
        this.getTransform(txform);
        txform.setScale((float)newWidth * 1.0f / (float)viewWidth, (float)newHeight * 1.0f / (float)viewHeight);
        txform.postTranslate((float)xoff, (float)yoff);
        txform.postRotate(this.rotateDegree, (float)viewWidth / 2.0f, (float)viewHeight / 2.0f);
        txform.postScale(-1.0f, 1.0f, (float)viewWidth / 2.0f, (float)viewHeight / 2.0f);
        this.post(new Runnable(){

            @Override
            public void run() {
                TextureVideoView.this.setTransform(txform);
            }
        });
    }

    @RequiresApi(api=21)
    public class TextureVideoViewOutlineProvider
    extends ViewOutlineProvider {
        public void getOutline(View view, Outline outline) {
            int left = 0;
            int top = (view.getHeight() - view.getWidth()) / 2;
            int right = view.getWidth();
            int bottom = (view.getHeight() - view.getWidth()) / 2 + view.getWidth();
            outline.setOval(left, top, right, bottom);
        }
    }
}

