/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.media.ThumbnailUtils;
import com.icatch.panorama.Log.AppLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class BitmapTools {
    private static String TAG = BitmapTools.class.getSimpleName();
    public static final int THUMBNAIL_WIDTH = 100;
    public static final int THUMBNAIL_HEIGHT = 100;
    private static final long LIMITED_IMGAE_SIZE = 0xA00000L;

    public static Bitmap getImageByPath(String imagePath, int width, int height) {
        AppLog.d(TAG, "Start getImageByPath imagePath=" + imagePath);
        if (imagePath == null) {
            return null;
        }
        Bitmap bitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        options.inSampleSize = BitmapTools.calculateInSampleSize(options, width, height);
        bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        return BitmapTools.zoomBitmap(bitmap, width, height);
    }

    public static Bitmap getImageByPath(String imagePath) {
        if (imagePath == null) {
            return null;
        }
        Bitmap bitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        return bitmap;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        while (height / inSampleSize > reqHeight || width / inSampleSize > reqWidth) {
            inSampleSize *= 2;
        }
        while ((long)(height * width / (inSampleSize * inSampleSize) * 4) > 0xA00000L) {
            inSampleSize *= 2;
        }
        return inSampleSize;
    }

    public static Bitmap getVideoThumbnail(String videoPath, int width, int height) {
        AppLog.i(TAG, "start getVideoThumbnail videoPath=" + videoPath);
        if (videoPath == null) {
            return null;
        }
        Bitmap bitmap = null;
        bitmap = ThumbnailUtils.createVideoThumbnail((String)videoPath, (int)2);
        AppLog.i(TAG, "End getVideoThumbnail bitmap=" + bitmap);
        return BitmapTools.zoomBitmap(bitmap, width, height);
    }

    public static Bitmap zoomBitmap(Bitmap bitmap, float width, float heigth) {
        if (bitmap == null) {
            return bitmap;
        }
        float zoomRate = 1.0f;
        if (!((float)bitmap.getWidth() >= width) && !((float)bitmap.getHeight() >= heigth)) {
            if (width * (float)bitmap.getHeight() > heigth * (float)bitmap.getWidth()) {
                zoomRate = heigth / (float)bitmap.getHeight();
            } else if (width * (float)bitmap.getHeight() <= heigth * (float)bitmap.getWidth()) {
                zoomRate = width / (float)bitmap.getWidth();
            }
        }
        Matrix matrix = new Matrix();
        matrix.postScale(zoomRate, zoomRate);
        try {
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            AppLog.e(TAG, "zoomBitmap OutOfMemoryError");
            bitmap.recycle();
            System.gc();
        }
        return bitmap;
    }

    public static Bitmap decodeByteArray(byte[] data) {
        AppLog.d(TAG, "start decodeByteArray");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        int sampleSize = BitmapTools.calculateInSampleSize(options, options.outWidth, options.outHeight);
        options.inJustDecodeBounds = false;
        options.inSampleSize = sampleSize;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        AppLog.d(TAG, "end decodeByteArray bitmap=" + bitmap);
        return bitmap;
    }

    public static Bitmap decodeByteArray(byte[] data, int reqWidth, int reqHeight) {
        AppLog.d(TAG, "start decodeByteArray");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        int sampleSize = BitmapTools.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        options.inSampleSize = sampleSize;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        AppLog.d(TAG, "end decodeByteArray");
        return BitmapTools.zoomBitmap(bitmap, reqWidth, reqHeight);
    }

    public static int getImageWidth(String path) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        return options.outWidth;
    }

    public static int getImageHeight(String path) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        return options.outHeight;
    }

    public static Bitmap getTransparentBitmap(Bitmap sourceImg, int number) {
        int[] argb = new int[sourceImg.getWidth() * sourceImg.getHeight()];
        sourceImg.getPixels(argb, 0, sourceImg.getWidth(), 0, 0, sourceImg.getWidth(), sourceImg.getHeight());
        number = number * 255 / 100;
        for (int i = 0; i < argb.length; ++i) {
            argb[i] = number << 24 | argb[i] & 0xFFFFFF;
        }
        sourceImg = Bitmap.createBitmap((int[])argb, (int)sourceImg.getWidth(), (int)sourceImg.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        return sourceImg;
    }

    public static Bitmap rotateBitmap(Bitmap sourceImg) {
        Matrix matrix = new Matrix();
        matrix.setRotate(-90.0f);
        return Bitmap.createBitmap((Bitmap)sourceImg, (int)0, (int)0, (int)sourceImg.getWidth(), (int)sourceImg.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static void saveBitmap(String savePath, Bitmap bitmap) {
        File f = new File(savePath);
        if (f.exists()) {
            f.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(f);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Bitmap mergeBitmap(Bitmap background, Bitmap foreground) {
        int bgWidth = background.getWidth();
        int bgHeight = background.getHeight();
        Bitmap newbmp = Bitmap.createBitmap((int)bgWidth, (int)bgHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas cv = new Canvas(newbmp);
        cv.drawBitmap(background, 0.0f, 0.0f, null);
        cv.drawBitmap(foreground, 0.0f, 0.0f, null);
        cv.save();
        cv.restore();
        return newbmp;
    }
}

