/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.utils;

import com.icatch.panorama.Log.AppLog;
import java.text.DecimalFormat;

public class ConvertTools {
    private static String TAG = "ConvertTools";
    static int GB = 0x40000000;
    static int MB = 0x100000;
    static int KB = 1024;

    public static String secondsToMinuteOrHours(int remainTime) {
        String time = "";
        Integer h = remainTime / 3600;
        Integer m = remainTime % 3600 / 60;
        Integer s = remainTime % 60;
        if (h > 0) {
            time = h < 10 ? "0" + h.toString() : h.toString();
            time = time + ":";
        }
        time = m < 10 ? time + "0" + m.toString() : time + m.toString();
        time = time + ":";
        time = s < 10 ? time + "0" + s.toString() : time + s.toString();
        return time;
    }

    public static String secondsToHours(int remainTime) {
        String time = "";
        Integer h = remainTime / 3600;
        Integer m = remainTime % 3600 / 60;
        Integer s = remainTime % 60;
        time = h < 10 ? "0" + h.toString() : h.toString();
        time = time + ":";
        time = m < 10 ? time + "0" + m.toString() : time + m.toString();
        time = time + ":";
        time = s < 10 ? time + "0" + s.toString() : time + s.toString();
        return time;
    }

    public static String ByteConversionGBMBKB(Integer KSize) {
        DecimalFormat df = new DecimalFormat("######0.0");
        if (KSize / GB >= 1) {
            return df.format((float)KSize.intValue() / (float)GB).toString() + "G";
        }
        if (KSize / MB >= 1) {
            return df.format((float)KSize.intValue() / (float)MB).toString() + "M";
        }
        if (KSize / KB >= 1) {
            return df.format((float)KSize.intValue() / (float)KB).toString() + "K";
        }
        return KSize.toString() + "B";
    }

    public static String resolutionConvert(String resolution) {
        AppLog.d(TAG, "start resolution = " + resolution);
        String ret = null;
        String[] temp = resolution.split("\\?|&");
        temp[1] = temp[1].replace("W=", "");
        temp[2] = temp[2].replace("H=", "");
        temp[3] = temp[3].replace("BR=", "");
        ret = temp[0] + "?W=" + temp[1] + "&H=" + temp[2] + "&BR=" + temp[3];
        ret = resolution.contains("FPS") ? (temp[2].equals("720") ? ret + "&FPS=15&" : (temp[2].equals("1080") ? ret + "&FPS=10&" : resolution)) : resolution;
        AppLog.d(TAG, "end ret = " + ret);
        return ret;
    }
}

