/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.widget.Toast;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.R;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import com.icatch.panorama.ui.ExtendComponent.MyToast;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "CrashHandler";
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private Handler handler = new Handler();
    private static CrashHandler INSTANCE = new CrashHandler();
    private Context mContext;
    private Map<String, String> infos = new HashMap<String, String>();
    private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");

    private CrashHandler() {
    }

    public static CrashHandler getInstance() {
        return INSTANCE;
    }

    public void init(Context context) {
        this.mContext = context;
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (!this.handleException(ex) && this.mDefaultHandler != null) {
            AppLog.e(TAG, "....default process!");
            this.mDefaultHandler.uncaughtException(thread, ex);
        } else {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                AppLog.e(TAG, e.toString());
            }
            AppLog.e(TAG, "....show custom process!");
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)GlobalInfo.getInstance().getAppContext(), (int)R.string.app_exception, (int)1).show();
                }
            });
            Process.killProcess((int)Process.myPid());
            System.exit(1);
        }
    }

    private boolean handleException(final Throwable ex) {
        if (ex == null) {
            return false;
        }
        new Thread(){

            @Override
            public void run() {
                Looper.prepare();
                MyToast.show(CrashHandler.this.mContext, CrashHandler.this.mContext.getResources().getString(R.string.app_exception) + "\n" + ex.toString());
                Looper.loop();
            }
        }.start();
        AppLog.e(TAG, ex.toString());
        this.collectDeviceInfo(this.mContext);
        return true;
    }

    public void collectDeviceInfo(Context ctx) {
        Field[] fields;
        try {
            PackageManager pm = ctx.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(ctx.getPackageName(), 1);
            if (pi != null) {
                String versionName = pi.versionName == null ? "null" : pi.versionName;
                String versionCode = pi.versionCode + "";
                this.infos.put("versionName", versionName);
                this.infos.put("versionCode", versionCode);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            AppLog.d(TAG, e.toString());
        }
        for (Field field : fields = Build.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                this.infos.put(field.getName(), field.get(null).toString());
                AppLog.d(TAG, field.getName() + " : " + field.get(null));
            }
            catch (Exception e) {
                AppLog.e(TAG, e.toString());
            }
        }
    }
}

