/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.utils.FileOpertion;

import android.util.Log;
import com.icatch.panorama.Application.PanoramaSDK;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import com.icatch.panorama.data.type.FileType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class FileTools {
    private static final String TAG = "FileTools";
    private static String[] Urls = null;
    private static final String FILENAME_SEQUENCE_SEPARATOR = "-";

    public static List<File> getFilesOrderByLength(String fliePath) {
        List<File> files = Arrays.asList(new File(fliePath).listFiles());
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                long diff = f1.length() - f2.length();
                if (diff > 0L) {
                    return 1;
                }
                if (diff == 0L) {
                    return 0;
                }
                return -1;
            }

            @Override
            public boolean equals(Object obj) {
                return true;
            }
        });
        for (File f : files) {
            if (!f.isDirectory()) continue;
        }
        return files;
    }

    public static List<File> getFilesOrderByName(String fliePath) {
        List<File> files = Arrays.asList(new File(fliePath).listFiles());
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.isDirectory() && o2.isFile()) {
                    return -1;
                }
                if (o1.isFile() && o2.isDirectory()) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (File f : files) {
            AppLog.i(TAG, f.getName());
        }
        return files;
    }

    public static List<File> getFilesOrderByDate(String filePath) {
        AppLog.i(TAG, "Start getFilesOrderByDate filePath=" + filePath);
        File file = new File(filePath);
        AppLog.i(TAG, "Start getFilesOrderByDate file=" + file);
        File[] fileArray = file.listFiles();
        AppLog.i(TAG, "Start getFilesOrderByDate fileArray=" + fileArray);
        if (fileArray == null) {
            return null;
        }
        AppLog.i(TAG, "Start getFilesOrderByDate size=" + fileArray.length);
        List<File> files = Arrays.asList(fileArray);
        AppLog.i(TAG, "Start getFilesOrderByDate 2");
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                long diff = f1.lastModified() - f2.lastModified();
                if (diff < 0L) {
                    return 1;
                }
                if (diff == 0L) {
                    return 0;
                }
                return -1;
            }

            @Override
            public boolean equals(Object obj) {
                return true;
            }
        });
        AppLog.i(TAG, "End getFilesOrderByDate");
        return files;
    }

    public static String[] getFileUrls(String path, FileType fileType) {
        int ii;
        AppLog.i(TAG, "Start getUrls path=" + path);
        File folder = new File(path);
        String[] temp = folder.list();
        AppLog.i(TAG, "Start getUrls temp=" + temp);
        AppLog.i(TAG, "Start getUrls temp size=" + temp.length);
        LinkedList<String> tempList = new LinkedList<String>();
        tempList.clear();
        if (fileType == FileType.FILE_PHOTO) {
            for (ii = 0; ii < temp.length; ++ii) {
                if (!temp[ii].endsWith(".jpg") && !temp[ii].endsWith(".png") && !temp[ii].endsWith(".PNG") && !temp[ii].endsWith(".JPG")) continue;
                tempList.addLast(temp[ii]);
            }
        } else {
            for (ii = 0; ii < temp.length; ++ii) {
                if (!temp[ii].endsWith(".MP4") && !temp[ii].endsWith(".wmv") && !temp[ii].endsWith(".mp4") && !temp[ii].endsWith(".3gp") && !temp[ii].endsWith(".MOV") && !temp[ii].endsWith(".mov") && !temp[ii].endsWith(".AVI") && !temp[ii].endsWith(".avi")) continue;
                tempList.addLast(temp[ii]);
            }
        }
        Urls = new String[tempList.size()];
        for (ii = 0; ii < tempList.size(); ++ii) {
            FileTools.Urls[ii] = path + (String)tempList.get(ii);
        }
        AppLog.d(TAG, "Urls.length ==" + Urls.length);
        return Urls;
    }

    public static String getFileDate(String fileName) {
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        long time = file.lastModified();
        AppLog.d(TAG, "file neme" + fileName);
        AppLog.d(TAG, "file.lastModified()" + time);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(new Date(time));
    }

    public static long getFileSize(File f) {
        long size = 0L;
        File[] flist = f.listFiles();
        for (int i = 0; i < flist.length; ++i) {
            if (flist[i].isDirectory()) {
                size += FileTools.getFileSize(flist[i]);
                continue;
            }
            size += flist[i].length();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(int resourceId) {
        File Folder = new File(PanoramaSDK.getContext().getExternalFilesDir(null), "SportCamResoure");
        if (!Folder.exists()) {
            Folder.mkdir();
        }
        Log.d((String)"1111", (String)("copyFile filename ==" + Folder));
        InputStream in = null;
        OutputStream out = null;
        File outFile = null;
        String fileName1 = "sphost.BRN";
        File file = new File(Folder, fileName1);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            int read;
            in = GlobalInfo.getInstance().getAppContext().getResources().openRawResource(resourceId);
            outFile = new File(Folder + fileName1);
            Log.d((String)"1111", (String)("output file" + outFile.getAbsolutePath()));
            out = new FileOutputStream(outFile);
            byte[] buffer = new byte[1024];
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            Log.e((String)"1111", (String)"Failed to copy file", (Throwable)e);
        }
        finally {
            try {
                in.close();
                out.flush();
                out.close();
                in = null;
                out = null;
            }
            catch (Exception exception) {}
        }
    }

    public static String chooseUniqueFilename(String fileNamePath) {
        if (fileNamePath == null) {
            return "error";
        }
        String filename = fileNamePath.substring(0, fileNamePath.lastIndexOf("."));
        String extension = fileNamePath.substring(fileNamePath.lastIndexOf("."), fileNamePath.length());
        String fullFilename = filename + extension;
        if (!new File(fullFilename).exists()) {
            return fullFilename;
        }
        int sequence = 1;
        for (int iteration = 0; iteration < 1000000; ++iteration) {
            fullFilename = filename + sequence + extension;
            if (!new File(fullFilename).exists()) {
                return fullFilename;
            }
            ++sequence;
        }
        return fullFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveSerializable(String fileName, Serializable data) {
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            fileOutputStream = new FileOutputStream(fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable readSerializable(String fileName) {
        Serializable data = null;
        ObjectInputStream ois = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            ois = new ObjectInputStream(fileInputStream);
            data = (Serializable)ois.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return data;
    }

    public static void copyFile(String oldPath, String newPath) {
        try {
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                FileInputStream inStream = new FileInputStream(oldPath);
                FileOutputStream fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1024];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    fs.write(buffer, 0, byteread);
                }
                ((InputStream)inStream).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyFolder(String oldPath, String newPath) {
        try {
            new File(newPath).mkdirs();
            File a = new File(oldPath);
            String[] file = a.list();
            File temp = null;
            for (int i = 0; i < file.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                if (temp.isFile()) {
                    int len;
                    FileInputStream input = new FileInputStream(temp);
                    FileOutputStream output = new FileOutputStream(newPath + "/" + temp.getName().toString());
                    byte[] b = new byte[5120];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                    output.close();
                    input.close();
                }
                if (!temp.isDirectory()) continue;
                FileTools.copyFolder(oldPath + "/" + file[i], newPath + "/" + file[i]);
            }
        }
        catch (Exception e) {
            System.out.println("\u590d\u5236\u6574\u4e2a\u6587\u4ef6\u5939\u5185\u5bb9\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
    }

    public static void deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                FileTools.deleteFile(f);
            }
            file.delete();
        } else if (file.exists()) {
            file.delete();
        }
    }
}

