/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.utils.FileOpertion;

import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.utils.FileOpertion.FileTools;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class MFileTools
extends FileTools {
    private static final String TAG = MFileTools.class.getSimpleName();

    public static String getNewestPhotoFromDirectory(String directoryPath) {
        List<File> files = MFileTools.getPhotosOrderByDate(directoryPath);
        if (files == null || files.isEmpty() || files.size() < 0) {
            AppLog.i(TAG, "getNewestPhotoFromDirectory = null");
            return null;
        }
        AppLog.i(TAG, "getNewestPhotoFromDirectory path =" + files.get(0).getPath());
        return files.get(0).getPath();
    }

    public static String getNewestVideoFromDirectory(String directoryPath) {
        List<File> files = MFileTools.getVideosOrderByDate(directoryPath);
        if (files == null || files.isEmpty() || files.size() < 0) {
            return null;
        }
        AppLog.i(TAG, "getNewestVideoFromDirectory path =" + files.get(0).getPath());
        return files.get(0).getPath();
    }

    public static List<File> getPhotosOrderByDate(String directoryPath) {
        AppLog.i(TAG, "start getPhotosOrderByDate");
        List<File> files = MFileTools.getFilesOrderByDate(directoryPath);
        if (files == null || files.isEmpty() || files.size() < 0) {
            return null;
        }
        LinkedList<File> tempFiles = new LinkedList<File>();
        for (File f : files) {
            String fileName = f.getName();
            if (!fileName.endsWith(".jpg") && !fileName.endsWith(".png") && !fileName.endsWith(".PNG") && !fileName.endsWith(".JPG")) continue;
            tempFiles.add(f);
        }
        AppLog.i(TAG, "end getPhotosOrderByDate");
        return tempFiles;
    }

    public static List<File> getVideosOrderByDate(String directoryPath) {
        List<File> files = MFileTools.getFilesOrderByDate(directoryPath);
        if (files == null || files.isEmpty() || files.size() < 0) {
            return null;
        }
        LinkedList<File> tempFiles = new LinkedList<File>();
        for (File f : files) {
            String fileName = f.getName();
            if (!fileName.endsWith(".MP4") && !fileName.endsWith(".wmv") && !fileName.endsWith(".mp4") && !fileName.endsWith(".3gp") && !fileName.endsWith(".MOV") && !fileName.endsWith(".mov") && !fileName.endsWith(".AVI") && !fileName.endsWith(".avi")) continue;
            tempFiles.add(f);
        }
        return tempFiles;
    }

    public static int getPhotosSize(String directoryPath) {
        AppLog.i(TAG, "Start getPhotosSize filePath=" + directoryPath);
        int fileSize = 0;
        List<File> files = MFileTools.getPhotosOrderByDate(directoryPath);
        fileSize = files == null || files.isEmpty() || files.size() < 0 ? 0 : files.size();
        AppLog.i(TAG, "End getPhotosSize size=" + fileSize);
        return fileSize;
    }

    public static int getVideosSize(String directoryPath) {
        AppLog.i(TAG, "Start getVideosSize filePath=" + directoryPath);
        int fileSize = 0;
        List<File> files = MFileTools.getVideosOrderByDate(directoryPath);
        fileSize = files == null || files.isEmpty() || files.size() < 0 ? 0 : files.size();
        AppLog.i(TAG, "End getVideosSize size=" + fileSize);
        return fileSize;
    }
}

