/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.bumptech.glide.GenericTransitionOptions;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.signature.ObjectKey;
import java.io.File;

public class GlideUtils {
    public static void loadImageView(Context mContext, String path, ImageView mImageView) {
        Glide.with((Context)mContext).load(path).into(mImageView);
    }

    public static void loadImageViewSize(Context mContext, String path, int width, int height, ImageView mImageView) {
        Glide.with((Context)mContext).load(path).apply(new RequestOptions().override(width, height)).into(mImageView);
    }

    public static void loadImageViewLoding(Context mContext, String path, ImageView mImageView, int lodingImage, int errorImageView) {
        Glide.with((Context)mContext).load(path).apply(((RequestOptions)new RequestOptions().placeholder(lodingImage)).error(errorImageView)).into(mImageView);
    }

    public static void loadImageViewCenterCorp(Context mContext, String path, ImageView mImageView, int lodingImage, int errorImageView) {
        Glide.with((Context)mContext).load(path).apply(((RequestOptions)((RequestOptions)new RequestOptions().placeholder(lodingImage)).centerCrop()).error(errorImageView)).into(mImageView);
    }

    public static void loadImageViewLoding(Context mContext, File file, ImageView mImageView, int lodingImage, int errorImageView) {
        Glide.with((Context)mContext).load(file).apply(((RequestOptions)((RequestOptions)new RequestOptions().signature((Key)new ObjectKey((Object)String.valueOf(file.lastModified())))).placeholder(lodingImage)).error(errorImageView)).into(mImageView);
    }

    public static void loadImageViewCenterCorp(Context mContext, File file, ImageView mImageView, int lodingImage, int errorImageView) {
        Glide.with((Context)mContext).load(file).apply(((RequestOptions)((RequestOptions)new RequestOptions().signature((Key)new ObjectKey((Object)String.valueOf(file.lastModified())))).placeholder(lodingImage)).error(errorImageView)).into(mImageView);
    }

    public static void loadImageViewLodingSize(Context mContext, String path, int width, int height, ImageView mImageView, int lodingImage, int errorImageView) {
        Glide.with((Context)mContext).load(path).apply(((RequestOptions)((RequestOptions)new RequestOptions().override(width, height)).placeholder(lodingImage)).error(errorImageView)).into(mImageView);
    }

    public static void loadImageViewCache(Context mContext, String path, ImageView mImageView) {
        Glide.with((Context)mContext).load(path).apply(new RequestOptions().skipMemoryCache(true)).into(mImageView);
    }

    public static void loadImageViewSkipCacheSize(Context mContext, String path, int width, int height, ImageView mImageView) {
        Glide.with((Context)mContext).load(path).apply(new RequestOptions().override(width, height)).into(mImageView);
    }

    public static void loadImageViewPriority(Context mContext, String path, ImageView mImageView) {
        Glide.with((Context)mContext).load(path).apply(new RequestOptions().priority(Priority.NORMAL)).into(mImageView);
    }

    public static void loadImageViewDiskCache(Context mContext, String path, ImageView mImageView) {
        Glide.with((Context)mContext).load(path).apply(new RequestOptions().diskCacheStrategy(DiskCacheStrategy.ALL)).into(mImageView);
    }

    public static void loadImageViewAnim(Context mContext, String path, int anim, ImageView mImageView) {
        Glide.with((Context)mContext).load(path).transition((TransitionOptions)GenericTransitionOptions.with((int)anim)).into(mImageView);
    }

    public static void loadImageViewThumbnail(Context mContext, String path, ImageView mImageView) {
        Glide.with((Context)mContext).load(path).thumbnail(0.1f).into(mImageView);
    }

    public static void loadImageViewCrop(Context mContext, String path, ImageView mImageView) {
        Glide.with((Context)mContext).load(path).apply(new RequestOptions().centerCrop()).into(mImageView);
    }

    public static void loadImageViewDynamicGif(Context mContext, String path, ImageView mImageView) {
        Glide.with((Context)mContext).asGif().load(path).into(mImageView);
    }

    public static void loadImageViewStaticGif(Context mContext, String path, ImageView mImageView) {
        Glide.with((Context)mContext).asBitmap().load(path).into(mImageView);
    }

    public static void loadImageViewListener(Context mContext, String path, ImageView mImageView, RequestListener<Drawable> requstlistener) {
        Glide.with((Context)mContext).load(path).listener(requstlistener).into(mImageView);
    }

    public static void loadImageViewContent(Context mContext, String path, SimpleTarget<Drawable> simpleTarget) {
        Glide.with((Context)mContext).load(path).apply(new RequestOptions().centerCrop()).into(simpleTarget);
    }

    public static void GuideClearDiskCache(Context mContext) {
        Glide.get((Context)mContext).clearDiskCache();
    }

    public static void GuideClearMemory(Context mContext) {
        Glide.get((Context)mContext).clearMemory();
    }

    public static void clear(ImageView mImageView) {
    }

    public static void getPanoramaBitmap(Context context, File file, final GlideListener listener) {
        Glide.with((Context)context).asBitmap().apply(((RequestOptions)new RequestOptions().override(4000, 2000)).centerCrop()).load(file).into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                if (listener != null) {
                    listener.onComplete(resource);
                }
            }

            public void onLoadStarted(Drawable placeholder) {
                super.onLoadStarted(placeholder);
                if (listener != null) {
                    listener.onStart();
                }
            }

            public void onLoadFailed(Drawable errorDrawable) {
                super.onLoadFailed(errorDrawable);
                if (listener != null) {
                    listener.onFailed();
                }
            }
        });
    }

    public static interface GlideListener {
        public void onStart();

        public void onComplete(Bitmap var1);

        public void onFailed();
    }
}

