/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.utils;

import android.util.Log;
import com.icatch.panorama.Application.PanoramaSDK;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class LogUtils {
    private static String TAG = "LogToFile";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd", Locale.US);
    private static String logPath = PanoramaSDK.getContext().getExternalFilesDir(null) + "/SmartLog";
    private static String fileName = logPath + "/smart_log_" + sdf.format(new Date()) + ".txt";
    private static final long MAX_SIZE = 0xA00000L;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
    private static final char VERBOSE = 'v';
    private static final char DEBUG = 'd';
    private static final char INFO = 'i';
    private static final char WARN = 'w';
    private static final char ERROR = 'e';

    public static void v(String msg) {
        LogUtils.writeToFile('v', TAG, msg);
    }

    public static void d(String msg) {
        System.out.println(msg);
        LogUtils.writeToFile('d', TAG, msg);
    }

    public static void i(String msg) {
        LogUtils.writeToFile('i', TAG, msg);
    }

    public static void w(String msg) {
        LogUtils.writeToFile('w', TAG, msg);
    }

    public static void e(String msg) {
        LogUtils.writeToFile('e', TAG, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(char type, String tag, String msg) {
        if (null == logPath) {
            Log.e((String)TAG, (String)"logPath == null \uff0c\u672a\u521d\u59cb\u5316LogToFile");
            return;
        }
        Date date = new Date();
        String log = dateFormat.format(date) + " -> " + msg + "\n";
        File folder = new File(logPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        FileOutputStream fos = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(fileName, true);
            bw = new BufferedWriter(new OutputStreamWriter(fos));
            bw.write(log);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

