/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.provider.MediaStore;
import com.icatch.panorama.Application.PanoramaSDK;
import com.icatch.panorama.Log.AppLog;
import java.io.File;

public class MediaRefresh {
    private static final String ACTION_MEDIA_SCANNER_SCAN_DIR = "android.intent.action.MEDIA_SCANNER_SCAN_DIR";
    private static final String TAG = "MediaRefresh";

    public static void scanDirAsync(Context ctx, String dir) {
        Intent scanIntent = new Intent(ACTION_MEDIA_SCANNER_SCAN_DIR);
        scanIntent.setData(Uri.fromFile((File)new File(dir)));
        ctx.sendBroadcast(scanIntent);
    }

    public static void scanFileAsync(final Context ctx, String filename) {
        AppLog.d(TAG, "scanFileAsync");
        MediaScannerConnection.scanFile((Context)ctx, (String[])new String[]{filename}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

            public void onScanCompleted(String path, Uri uri) {
                Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
                mediaScanIntent.setData(uri);
                ctx.sendBroadcast(mediaScanIntent);
            }
        });
    }

    public static void addMediaToDB(Context ctx, String filePath, String fileType) {
        AppLog.d(TAG, "addMediaToDB filePath=" + filePath);
        AppLog.d(TAG, "addMediaToDB fileType=" + fileType);
        File videofile = new File(filePath);
        ContentValues values = new ContentValues(5);
        long current = System.currentTimeMillis();
        values.put("title", videofile.getName());
        values.put("date_added", Integer.valueOf((int)(current / 1000L)));
        values.put("mime_type", fileType);
        values.put("_data", videofile.getAbsolutePath());
        values.put("album", "");
        ContentResolver contentResolver = ctx.getContentResolver();
        Uri base = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
        contentResolver.insert(base, values);
    }

    public static void notifySystemToScan(String filePath, Context context) {
        Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        File file = new File(filePath);
        Uri uri = Uri.fromFile((File)file);
        intent.setData(uri);
        context.sendBroadcast(intent);
    }

    public static void notifySystemToScan(File file) {
        Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        Uri uri = Uri.fromFile((File)file);
        intent.setData(uri);
        Context context = PanoramaSDK.getContext();
        if (context != null) {
            context.sendBroadcast(intent);
        }
    }
}

