/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaMetadataRetriever;
import com.icatch.panorama.Log.AppLog;
import java.io.File;

public class PanoramaTools {
    private static final String TAG = PanoramaTools.class.getSimpleName();

    public static boolean isPanorama(String imagePath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        AppLog.e(TAG, "Bitmap Height == " + options.outHeight);
        AppLog.e(TAG, "Bitmap Width == " + options.outWidth);
        return options.outHeight == options.outWidth || options.outHeight * 2 == options.outWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPanoramaForVideo(String videoPath) {
        if (videoPath == null) {
            return false;
        }
        File file = new File(videoPath);
        if (file == null || !file.exists()) {
            return false;
        }
        MediaMetadataRetriever mmr = new MediaMetadataRetriever();
        boolean isPanorama = false;
        try {
            mmr.setDataSource(videoPath);
            String width = mmr.extractMetadata(18);
            String height = mmr.extractMetadata(19);
            AppLog.d(TAG, "isPanoramaForVideo w=" + width + " h=" + height);
            if (width == null || height == null) {
                isPanorama = false;
            } else {
                int widthInt = Integer.parseInt(width);
                int heightInt = Integer.parseInt(height);
                if (widthInt == 0 || heightInt == 0) {
                    isPanorama = false;
                } else if (heightInt * 2 == widthInt) {
                    isPanorama = true;
                }
            }
        }
        catch (Exception ex) {
            AppLog.e(TAG, "MediaMetadataRetriever exception " + ex);
        }
        finally {
            mmr.release();
        }
        return isPanorama;
    }

    public static boolean isPanorama(long width, long height) {
        AppLog.e(TAG, "isPanorama width=" + width + " height=" + height);
        if (width == 0L || height == 0L) {
            return false;
        }
        return height * 2L == width;
    }
}

