/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;

public class PhotoEnhance {
    private Bitmap mBitmap;
    private float saturationNum = 1.0f;
    private float mBrightNum = 0.0f;
    private float mContrastNum = 1.0f;
    private ColorMatrix mAllMatrix = null;
    private ColorMatrix saturationMatrix = null;
    private ColorMatrix contrastMatrix = null;
    private ColorMatrix brightnessMatrix = null;

    public PhotoEnhance(Bitmap bitmap) {
        this.mBitmap = bitmap;
    }

    public float getSaturation() {
        return this.saturationNum;
    }

    public void setSaturation(int saturationNum) {
        this.saturationNum = (float)saturationNum * 1.0f / 128.0f;
        if (this.saturationMatrix == null) {
            this.saturationMatrix = new ColorMatrix();
        }
        this.saturationMatrix.reset();
        this.saturationMatrix.setSaturation((float)saturationNum);
    }

    public float getBrightness() {
        return this.mBrightNum;
    }

    public void setBrightness(int brightNum) {
        this.mBrightNum = brightNum - 128;
        if (this.brightnessMatrix == null) {
            this.brightnessMatrix = new ColorMatrix();
        }
        this.brightnessMatrix.reset();
        this.brightnessMatrix.set(new float[]{1.0f, 0.0f, 0.0f, 0.0f, this.mBrightNum, 0.0f, 1.0f, 0.0f, 0.0f, this.mBrightNum, 0.0f, 0.0f, 1.0f, 0.0f, this.mBrightNum, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
    }

    public float getContrast() {
        return this.mContrastNum;
    }

    public void setContrast(int contrastNum) {
        this.mContrastNum = (float)((double)(contrastNum / 2 + 64) / 128.0);
        if (this.contrastMatrix == null) {
            this.contrastMatrix = new ColorMatrix();
        }
        float regulateBright = 0.0f;
        this.contrastMatrix.reset();
        this.contrastMatrix.set(new float[]{this.mContrastNum, 0.0f, 0.0f, 0.0f, regulateBright, 0.0f, this.mContrastNum, 0.0f, 0.0f, regulateBright, 0.0f, 0.0f, this.mContrastNum, 0.0f, regulateBright, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
    }

    public Bitmap handleImage() {
        Bitmap bmp = Bitmap.createBitmap((int)this.mBitmap.getWidth(), (int)this.mBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bmp);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        if (this.mAllMatrix == null) {
            this.mAllMatrix = new ColorMatrix();
        }
        this.mAllMatrix.reset();
        if (this.saturationMatrix != null) {
            this.mAllMatrix.postConcat(this.saturationMatrix);
        }
        if (this.brightnessMatrix != null) {
            this.mAllMatrix.postConcat(this.brightnessMatrix);
        }
        if (this.contrastMatrix != null) {
            this.mAllMatrix.postConcat(this.contrastMatrix);
        }
        paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(this.mAllMatrix));
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, paint);
        return bmp;
    }
}

