/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.utils;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import java.util.ArrayList;
import java.util.List;

public class VoiceUtils {
    private Context mContext;
    private MediaPlayer mBackgroundMediaPlayer;
    public static VoiceUtils sVoiceUtils;
    private List<String> sPaths = new ArrayList<String>();
    private boolean isPause;

    public static VoiceUtils getVoiceUtils(Context context) {
        if (sVoiceUtils == null) {
            sVoiceUtils = new VoiceUtils(context);
        }
        return sVoiceUtils;
    }

    private VoiceUtils(Context context) {
        this.mContext = context;
        this.initData();
    }

    private void initData() {
        this.sPaths.clear();
    }

    public void playVoice(String path) {
        this.sPaths.clear();
        if (this.mBackgroundMediaPlayer != null) {
            this.stopVoice();
            this.mBackgroundMediaPlayer.release();
        }
        this.mBackgroundMediaPlayer = this.createMediaplayerFromAssets(path);
        if (this.mBackgroundMediaPlayer != null) {
            this.mBackgroundMediaPlayer.start();
        }
    }

    public void playVoice(List<String> paths) {
        if (paths == null || paths.size() == 0) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>(paths);
        this.sPaths.clear();
        this.sPaths.addAll(list);
        if (this.mBackgroundMediaPlayer != null) {
            this.stopVoice();
            this.mBackgroundMediaPlayer.release();
        }
        this.mBackgroundMediaPlayer = this.createMediaplayerFromAssets(this.sPaths.get(0));
        if (this.mBackgroundMediaPlayer != null) {
            this.mBackgroundMediaPlayer.seekTo(0);
            this.mBackgroundMediaPlayer.start();
        }
    }

    public void continuePlay(String path) {
        this.sPaths.add(path);
        if (!this.isVoicePlaying()) {
            this.playVoice(this.sPaths);
        }
    }

    public void stopVoice() {
        this.isPause = false;
        if (this.mBackgroundMediaPlayer != null && this.mBackgroundMediaPlayer.isPlaying()) {
            this.mBackgroundMediaPlayer.stop();
        }
    }

    public void pauseVoice() {
        if (this.mBackgroundMediaPlayer != null && this.mBackgroundMediaPlayer.isPlaying()) {
            this.isPause = true;
            this.mBackgroundMediaPlayer.pause();
        }
    }

    public void resumeVoice() {
        if (this.mBackgroundMediaPlayer != null && this.isPause) {
            this.isPause = false;
            this.mBackgroundMediaPlayer.start();
        }
    }

    public boolean isVoicePlaying() {
        boolean ret = this.mBackgroundMediaPlayer == null ? false : this.mBackgroundMediaPlayer.isPlaying();
        return ret;
    }

    public void end() {
        this.stopVoice();
        if (this.mBackgroundMediaPlayer != null) {
            this.mBackgroundMediaPlayer.setOnCompletionListener(null);
            this.mBackgroundMediaPlayer.release();
            this.mBackgroundMediaPlayer = null;
        }
        this.initData();
    }

    private MediaPlayer createMediaplayerFromAssets(String path) {
        MediaPlayer mediaPlayer;
        try {
            AssetFileDescriptor assetFileDescriptor = this.mContext.getAssets().openFd(path);
            mediaPlayer = new MediaPlayer();
            mediaPlayer.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
            mediaPlayer.prepare();
            mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    if (VoiceUtils.this.sPaths.size() > 0) {
                        VoiceUtils.this.sPaths.remove(0);
                        VoiceUtils.this.playVoice(VoiceUtils.this.sPaths);
                    }
                }
            });
        }
        catch (Exception e) {
            mediaPlayer = null;
            e.printStackTrace();
        }
        return mediaPlayer;
    }
}

