/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.util.Log;
import com.icatch.panorama.Listener.WifiListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WifiAPUtil {
    private static final String TAG = "WifiAPUtil";
    public static final boolean DEBUG = true;
    public static final int MESSAGE_AP_STATE_ENABLED = 1;
    public static final int MESSAGE_AP_STATE_FAILED = 2;
    private static final String DEFAULT_AP_PASSWORD = "12345678";
    private static WifiAPUtil sInstance;
    private static Handler mHandler;
    private static Context mContext;
    private WifiManager mWifiManager;
    public static final String WIFI_AP_STATE_CHANGED_ACTION = "android.net.wifi.WIFI_AP_STATE_CHANGED";
    public static final String CONNECTIVITY_CHANGE_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";
    public static final String EXTRA_WIFI_AP_STATE = "wifi_state";
    public static int WIFI_AP_STATE_DISABLING;
    public static int WIFI_AP_STATE_DISABLED;
    public static int WIFI_AP_STATE_ENABLING;
    public static int WIFI_AP_STATE_ENABLED;
    public static int WIFI_AP_STATE_FAILED;
    WifiListener wifiListener;
    private BroadcastReceiver mWifiStateBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Log.i((String)WifiAPUtil.TAG, (String)("WifiAPUtils onReceive: " + intent.getAction()));
            if (WifiAPUtil.WIFI_AP_STATE_CHANGED_ACTION.equals(intent.getAction())) {
                int cstate = intent.getIntExtra(WifiAPUtil.EXTRA_WIFI_AP_STATE, -1);
                if (cstate == WIFI_AP_STATE_ENABLED && mHandler != null) {
                    mHandler.sendEmptyMessage(1);
                }
                if ((cstate == WIFI_AP_STATE_DISABLED || cstate == WIFI_AP_STATE_FAILED) && mHandler != null) {
                    mHandler.sendEmptyMessage(2);
                }
            }
        }
    };
    private BroadcastReceiver WifiReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (!intent.getAction().equals("android.net.wifi.RSSI_CHANGED")) {
                if (intent.getAction().equals("android.net.wifi.STATE_CHANGE")) {
                    NetworkInfo info = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    if (info.getState().equals((Object)NetworkInfo.State.DISCONNECTED)) {
                        Log.d((String)WifiAPUtil.TAG, (String)"\u7f51\u7edc\u8fde\u63a5\u65ad\u5f00");
                    } else if (info.getState().equals((Object)NetworkInfo.State.CONNECTED)) {
                        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                        Log.d((String)WifiAPUtil.TAG, (String)("\u8fde\u63a5\u5230\u7f51\u7edc " + wifiInfo.getSSID()));
                    }
                } else if (intent.getAction().equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                    int wifistate = intent.getIntExtra(WifiAPUtil.EXTRA_WIFI_AP_STATE, 1);
                    if (wifistate == 1) {
                        Log.d((String)WifiAPUtil.TAG, (String)"\u7cfb\u7edf\u5173\u95edwifi");
                    } else if (wifistate == 3) {
                        Log.d((String)WifiAPUtil.TAG, (String)"\u7cfb\u7edf\u5f00\u542fwifi");
                    }
                }
            }
        }
    };

    private WifiAPUtil(Context context) {
        Log.d((String)TAG, (String)"WifiAPUtils construct");
        mContext = context;
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
    }

    protected void finalize() {
        Log.d((String)TAG, (String)"finalize");
        mContext.unregisterReceiver(this.mWifiStateBroadcastReceiver);
    }

    public static WifiAPUtil getInstance(Context c) {
        if (null == sInstance) {
            sInstance = new WifiAPUtil(c);
        }
        return sInstance;
    }

    public boolean turnOnWifiAp(String str, String password, WifiSecurityType Type2) {
        String ssid = str;
        WifiConfiguration wcfg = new WifiConfiguration();
        wcfg.SSID = new String(ssid);
        wcfg.networkId = 1;
        wcfg.allowedAuthAlgorithms.clear();
        wcfg.allowedGroupCiphers.clear();
        wcfg.allowedKeyManagement.clear();
        wcfg.allowedPairwiseCiphers.clear();
        wcfg.allowedProtocols.clear();
        if (Type2 == WifiSecurityType.WIFICIPHER_NOPASS) {
            Log.d((String)TAG, (String)"wifi ap----no password");
            wcfg.allowedAuthAlgorithms.set(0, true);
            wcfg.wepKeys[0] = "";
            wcfg.allowedKeyManagement.set(0);
            wcfg.wepTxKeyIndex = 0;
        } else if (Type2 == WifiSecurityType.WIFICIPHER_WPA) {
            Log.d((String)TAG, (String)"wifi ap----wpa");
            wcfg.preSharedKey = null != password && password.length() >= 8 ? password : DEFAULT_AP_PASSWORD;
            wcfg.hiddenSSID = false;
            wcfg.allowedAuthAlgorithms.set(0);
            wcfg.allowedGroupCiphers.set(2);
            wcfg.allowedKeyManagement.set(1);
            wcfg.allowedPairwiseCiphers.set(1);
            wcfg.allowedProtocols.set(0);
            wcfg.allowedGroupCiphers.set(3);
            wcfg.allowedPairwiseCiphers.set(2);
        } else if (Type2 == WifiSecurityType.WIFICIPHER_WPA2) {
            Log.d((String)TAG, (String)"wifi ap---- wpa2");
            wcfg.preSharedKey = null != password && password.length() >= 8 ? password : DEFAULT_AP_PASSWORD;
            wcfg.hiddenSSID = false;
            wcfg.allowedAuthAlgorithms.set(0);
            wcfg.allowedGroupCiphers.set(2);
            wcfg.allowedKeyManagement.set(4);
            wcfg.allowedPairwiseCiphers.set(1);
            wcfg.allowedProtocols.set(0);
            wcfg.allowedGroupCiphers.set(3);
            wcfg.allowedPairwiseCiphers.set(2);
        }
        try {
            Method method = this.mWifiManager.getClass().getMethod("setWifiApConfiguration", wcfg.getClass());
            Boolean rt = (Boolean)method.invoke((Object)this.mWifiManager, wcfg);
            Log.d((String)TAG, (String)(" rt = " + rt));
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        return this.setWifiApEnabled();
    }

    public int getWifiAPState() {
        int state = -1;
        try {
            Method method2 = this.mWifiManager.getClass().getMethod("getWifiApState", new Class[0]);
            state = (Integer)method2.invoke((Object)this.mWifiManager, new Object[0]);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        Log.i((String)"WifiAP", (String)("getWifiAPState.state " + state));
        return state;
    }

    private boolean setWifiApEnabled() {
        Method method1;
        while (this.mWifiManager.getWifiState() != 1) {
            this.mWifiManager.setWifiEnabled(false);
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.getMessage());
                return false;
            }
        }
        while (this.getWifiAPState() != WIFI_AP_STATE_DISABLED) {
            try {
                method1 = this.mWifiManager.getClass().getMethod("setWifiApEnabled", WifiConfiguration.class, Boolean.TYPE);
                method1.invoke((Object)this.mWifiManager, null, false);
                Thread.sleep(200L);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.getMessage());
                return false;
            }
        }
        try {
            method1 = this.mWifiManager.getClass().getMethod("setWifiApEnabled", WifiConfiguration.class, Boolean.TYPE);
            method1.invoke((Object)this.mWifiManager, null, true);
            Thread.sleep(200L);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
            return false;
        }
        return true;
    }

    public void closeWifiAp() {
        if (this.getWifiAPState() != WIFI_AP_STATE_DISABLED) {
            try {
                Method method = this.mWifiManager.getClass().getMethod("getWifiApConfiguration", new Class[0]);
                method.setAccessible(true);
                WifiConfiguration config = (WifiConfiguration)method.invoke((Object)this.mWifiManager, new Object[0]);
                Method method2 = this.mWifiManager.getClass().getMethod("setWifiApEnabled", WifiConfiguration.class, Boolean.TYPE);
                method2.invoke((Object)this.mWifiManager, config, false);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void regitsterHandler(Handler handler) {
        mHandler = handler;
        IntentFilter filter = new IntentFilter();
        filter.addAction(WIFI_AP_STATE_CHANGED_ACTION);
        mContext.registerReceiver(this.mWifiStateBroadcastReceiver, filter);
    }

    public void unregitsterHandler() {
        mHandler = null;
        if (this.mWifiStateBroadcastReceiver != null) {
            mContext.unregisterReceiver(this.mWifiStateBroadcastReceiver);
            this.mWifiStateBroadcastReceiver = null;
        }
    }

    public String getValidApSsid() {
        try {
            Method method = this.mWifiManager.getClass().getMethod("getWifiApConfiguration", new Class[0]);
            WifiConfiguration configuration = (WifiConfiguration)method.invoke((Object)this.mWifiManager, new Object[0]);
            return configuration.SSID;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
            return null;
        }
    }

    public String getValidPassword() {
        try {
            Method method = this.mWifiManager.getClass().getMethod("getWifiApConfiguration", new Class[0]);
            WifiConfiguration configuration = (WifiConfiguration)method.invoke((Object)this.mWifiManager, new Object[0]);
            return configuration.preSharedKey;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
            return null;
        }
    }

    public int getValidSecurity() {
        WifiConfiguration configuration;
        try {
            Method method = this.mWifiManager.getClass().getMethod("getWifiApConfiguration", new Class[0]);
            configuration = (WifiConfiguration)method.invoke((Object)this.mWifiManager, new Object[0]);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
            return WifiSecurityType.WIFICIPHER_INVALID.ordinal();
        }
        Log.i((String)TAG, (String)("getSecurity security=" + configuration.allowedKeyManagement));
        if (configuration.allowedKeyManagement.get(0)) {
            return WifiSecurityType.WIFICIPHER_NOPASS.ordinal();
        }
        if (configuration.allowedKeyManagement.get(1)) {
            return WifiSecurityType.WIFICIPHER_WPA.ordinal();
        }
        if (configuration.allowedKeyManagement.get(4)) {
            return WifiSecurityType.WIFICIPHER_WPA2.ordinal();
        }
        return WifiSecurityType.WIFICIPHER_INVALID.ordinal();
    }

    static {
        WIFI_AP_STATE_DISABLING = 10;
        WIFI_AP_STATE_DISABLED = 11;
        WIFI_AP_STATE_ENABLING = 12;
        WIFI_AP_STATE_ENABLED = 13;
        WIFI_AP_STATE_FAILED = 14;
    }

    public static enum WifiSecurityType {
        WIFICIPHER_NOPASS,
        WIFICIPHER_WPA,
        WIFICIPHER_WEP,
        WIFICIPHER_INVALID,
        WIFICIPHER_WPA2;

    }
}

