/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Message;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.R;
import com.icatch.panorama.data.GlobalApp.ExitApp;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;

public class WifiCheck {
    private String TAG = "WifiCheck";
    private static final int CONNECT_FAILED = 2;
    private static final int IN_BACKGROUND = 3;
    private static final int RECONNECT_SUCCESS = 4;
    private static final int RECONNECT_FAILED = 5;
    public static final int WIFICIPHER_NOPASS = 6;
    public static final int WIFICIPHER_WEP = 7;
    public static final int WIFICIPHER_WAP = 8;
    private static final int RECONNECT_CAMERA = 9;
    private static int RECONNECT_WAITING = 10000;
    private static int RECONNECT_CHECKING_PERIOD = 5000;
    private WifiInfo mWifiInfo;
    private WifiManager mWifiManager;
    private Activity activity;
    private Timer reconnectTimer;
    private static int RECONNECT_TIME = 10;
    protected AlertDialog reconnectDialog;
    private AlertDialog dialog;
    private Boolean isShowed = false;
    ExecutorService executor;
    private int curReconnectTime = 0;
    private final Handler wifiCheckHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 9: {
                    WifiCheck.this.showReconnectDialog();
                }
            }
        }
    };

    public WifiCheck(Activity activity) {
        this.activity = activity;
        this.mWifiManager = (WifiManager)activity.getApplicationContext().getSystemService("wifi");
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
    }

    public void openWifi() {
        if (!this.mWifiManager.isWifiEnabled()) {
            this.mWifiManager.setWifiEnabled(true);
        }
    }

    public void closeWifi() {
        if (this.mWifiManager.isWifiEnabled()) {
            this.mWifiManager.setWifiEnabled(false);
        }
    }

    public int checkState() {
        return this.mWifiManager.getWifiState();
    }

    public boolean connectWifi(String SSID, String Password, int Type2) {
        AppLog.d(this.TAG, "connectWifi SSID=" + SSID + " Password=" + Password + " activity=" + this.activity);
        WifiManager wifiManager = (WifiManager)this.activity.getApplicationContext().getSystemService("wifi");
        WifiConfiguration config = this.CreateWifiInfo(SSID, Password, Type2);
        AppLog.d(this.TAG, "connectWifi start addNetwork\u3000config=" + config);
        int netID = wifiManager.addNetwork(config);
        AppLog.d(this.TAG, "connectWifi start enableNetwork netID=" + netID);
        boolean bRet = wifiManager.enableNetwork(netID, true);
        AppLog.d(this.TAG, "connectWifi end----bRet =" + bRet);
        return bRet;
    }

    public WifiConfiguration CreateWifiInfo(String SSID, String Password, int Type2) {
        AppLog.d(this.TAG, "start CreateWifiInfo");
        WifiConfiguration config = new WifiConfiguration();
        config.allowedAuthAlgorithms.clear();
        config.allowedGroupCiphers.clear();
        config.allowedKeyManagement.clear();
        config.allowedPairwiseCiphers.clear();
        config.allowedProtocols.clear();
        config.SSID = "\"" + SSID + "\"";
        if (Type2 == 6) {
            config.wepKeys[0] = "";
            config.allowedKeyManagement.set(0);
            config.wepTxKeyIndex = 0;
        }
        if (Type2 == 7) {
            if (Password.length() != 0) {
                int length = Password.length();
                config.wepKeys[0] = (length == 10 || length == 26 || length == 58) && Password.matches("[0-9A-Fa-f]*") ? Password : '\"' + Password + '\"';
            }
            config.allowedKeyManagement.set(0);
            config.allowedAuthAlgorithms.set(0);
            config.allowedAuthAlgorithms.set(1);
            config.wepTxKeyIndex = 0;
        }
        if (Type2 == 8) {
            config.preSharedKey = "\"" + Password + "\"";
            config.hiddenSSID = true;
            config.allowedAuthAlgorithms.set(0);
            config.allowedGroupCiphers.set(2);
            config.allowedKeyManagement.set(1);
            config.allowedPairwiseCiphers.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedPairwiseCiphers.set(2);
            config.status = 2;
        }
        AppLog.d(this.TAG, "end CreateWifiInfo config=" + config);
        return config;
    }

    public boolean isWifiConnected(Context context, String nameFilter) {
        WifiManager mWifi;
        WifiInfo wifiInfo;
        ConnectivityManager mConnectivityManager;
        NetworkInfo mWiFiNetworkInfo;
        return context != null && (mWiFiNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1)) != null && (wifiInfo = (mWifi = (WifiManager)this.activity.getApplicationContext().getSystemService("wifi")).getConnectionInfo()).getIpAddress() != 0 && wifiInfo.getSSID().contains(nameFilter);
    }

    public void showConectFailureWarningDlg(Context context) {
        if (this.isShowed.booleanValue()) {
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setIcon(R.drawable.warning).setTitle((CharSequence)"Warning").setMessage(R.string.dialog_connect_failed);
        builder.setPositiveButton(R.string.dialog_btn_exit, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AppLog.d(WifiCheck.this.TAG, "showConectFailureWarningDlg exit connect");
                ExitApp.getInstance().finishAllActivity();
            }
        });
        builder.setNegativeButton(R.string.dialog_btn_reconnect, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                WifiCheck.this.curReconnectTime = 0;
                WifiCheck.this.reconnectTimer = new Timer(true);
                ReconnectTask task = new ReconnectTask();
                WifiCheck.this.reconnectTimer.schedule((TimerTask)task, 3000L, (long)RECONNECT_CHECKING_PERIOD);
                WifiCheck.this.wifiCheckHandler.obtainMessage(9).sendToTarget();
            }
        });
        if (this.dialog == null) {
            this.dialog = builder.create();
            this.dialog.setCancelable(false);
            this.dialog.show();
        }
    }

    private void showReconnectDialog() {
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(GlobalInfo.getInstance().getAppContext());
        builder.setIcon(R.drawable.warning).setTitle(R.string.dialog_btn_reconnect).setMessage(R.string.message_reconnect);
        builder.setPositiveButton(R.string.dialog_btn_exit, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AppLog.d(WifiCheck.this.TAG, "showReconnectDialog exit connect");
                ExitApp.getInstance().finishAllActivity();
            }
        });
        this.reconnectDialog = builder.create();
        this.reconnectDialog.setCancelable(false);
        this.reconnectDialog.show();
    }

    private void showReconnectTimeoutDialog() {
        Activity activity;
        Context context = GlobalInfo.getInstance().getAppContext();
        if (context instanceof Activity && ((activity = (Activity)context).isDestroyed() || activity.isFinishing())) {
            return;
        }
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setIcon(R.drawable.warning).setTitle(R.string.text_reconnect_timeout).setMessage(R.string.message_reconnect_timeout);
        builder.setPositiveButton(R.string.dialog_btn_exit, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AppLog.d(WifiCheck.this.TAG, "showReconnectTimeoutDialog exit connect");
                ExitApp.getInstance().finishAllActivity();
            }
        });
        this.reconnectDialog = builder.create();
        this.reconnectDialog.setCancelable(false);
        this.reconnectDialog.show();
    }

    public void showAutoReconnectDialog() {
        this.reconnectTimer = new Timer(true);
        ReconnectTask task = new ReconnectTask();
        this.reconnectTimer.schedule((TimerTask)task, 3000L, (long)RECONNECT_CHECKING_PERIOD);
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(GlobalInfo.getInstance().getAppContext());
        builder.setIcon(R.drawable.warning).setTitle(R.string.dialog_btn_reconnect).setMessage(R.string.message_reconnect);
        builder.setPositiveButton(R.string.dialog_btn_exit, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AppLog.d(WifiCheck.this.TAG, "showAutoReconnectDialog exit connect");
                ExitApp.getInstance().finishAllActivity();
            }
        });
        this.reconnectDialog = builder.create();
        this.reconnectDialog.setCancelable(false);
        this.reconnectDialog.show();
    }

    private class ReconnectTask
    extends TimerTask {
        private ReconnectTask() {
        }

        @Override
        public void run() {
            WifiCheck.this.mWifiManager = (WifiManager)GlobalInfo.getInstance().getAppContext().getSystemService("wifi");
            WifiCheck.this.mWifiInfo = WifiCheck.this.mWifiManager.getConnectionInfo();
            String ssid = WifiCheck.this.mWifiInfo.getSSID().replaceAll("\"", "");
            AppLog.d("tigertiger", "reconnect mWifiInfo.getSSID()=" + ssid);
            String cameraSsid = CameraManager.getInstance().getCurCamera().getCameraName();
            if (ssid.equals(cameraSsid)) {
                AppLog.d(WifiCheck.this.TAG, "reconnect success!");
                if (WifiCheck.this.reconnectTimer != null) {
                    WifiCheck.this.reconnectTimer.cancel();
                }
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        if (WifiCheck.this.reconnectDialog != null) {
                            WifiCheck.this.reconnectDialog.dismiss();
                        }
                        AppLog.d(WifiCheck.this.TAG, "reconnect success! start finishAllActivity()");
                        ExitApp.getInstance().finishAllActivity();
                    }
                };
                Timer tempTimer = new Timer(true);
                tempTimer.schedule(task, RECONNECT_WAITING);
            }
            WifiCheck.this.curReconnectTime++;
            AppLog.d(WifiCheck.this.TAG, "reconnect curReconnectTime=" + WifiCheck.this.curReconnectTime);
            if (WifiCheck.this.curReconnectTime > RECONNECT_TIME) {
                if (WifiCheck.this.reconnectDialog != null) {
                    WifiCheck.this.reconnectDialog.dismiss();
                }
                if (WifiCheck.this.reconnectTimer != null) {
                    WifiCheck.this.reconnectTimer.cancel();
                }
                WifiCheck.this.wifiCheckHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        WifiCheck.this.showReconnectTimeoutDialog();
                    }
                });
            }
        }
    }
}

