/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core;

import com.icatchtek.pancam.core.util.VrLogger;
import com.icatchtek.pancam.customer.exception.IchGLFormatNotSupportedException;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchNotSupportedException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class VrImageRAW {
    public static final int VR_RAW_IMAGE_KEY_A_RGB = 1;
    public static final int VR_RAW_IMAGE_KEY_RGB_A = 2;
    public static final int VR_RAW_IMAGE_KEY_YUV_Y = 17;
    public static final int VR_RAW_IMAGE_KEY_YUV_U = 18;
    public static final int VR_RAW_IMAGE_KEY_YUV_V = 19;
    private int imageW;
    private int imageH;
    private int format;
    private Map<Integer, byte[]> imageData = new HashMap<Integer, byte[]>();

    public boolean init(int foramt, int imageW, int imageH) throws IchInvalidArgumentException, IchGLFormatNotSupportedException {
        if (imageW <= 0 || imageH <= 0) {
            throw new IchInvalidArgumentException("The imageW and imageH must be less or equal than zero.");
        }
        this.imageW = imageW;
        this.imageH = imageH;
        this.format = this.format;
        VrLogger.logI("vrImage_init", "imageW: " + imageW + ", imageH: " + imageH);
        if (this.format == 148 || this.format == 149) {
            int image_cnt = this.calculateDataSize(this.format, 0, imageW, imageH);
            byte[] image = new byte[image_cnt];
            int key = this.format == 148 ? 1 : 2;
            this.imageData.clear();
            this.imageData.put(key, image);
            return true;
        }
        if (this.format == 150 || this.format == 151) {
            int imageY_cnt = this.calculateDataSize(this.format, 17, imageW, imageH);
            int imageU_cnt = this.calculateDataSize(this.format, 18, imageW, imageH);
            int imageV_cnt = this.calculateDataSize(this.format, 19, imageW, imageH);
            byte[] imageY = new byte[imageY_cnt];
            byte[] imageU = new byte[imageU_cnt];
            byte[] imageV = new byte[imageV_cnt];
            this.imageData.put(17, imageY);
            this.imageData.put(18, imageU);
            this.imageData.put(19, imageV);
            return true;
        }
        throw new IchGLFormatNotSupportedException("This format not supported by VrImage, index: " + this.format);
    }

    public boolean putData(ByteBuffer buffer) throws IchInvalidArgumentException, IchNotSupportedException {
        int dataSize = buffer.remaining();
        if (this.format == 148) {
            return this.putData(1, buffer, dataSize);
        }
        if (this.format == 149) {
            return this.putData(2, buffer, dataSize);
        }
        if (this.format == 150 || this.format == 151) {
            int imageY_cnt = this.calculateDataSize(this.format, 17, this.imageW, this.imageH);
            int imageU_cnt = this.calculateDataSize(this.format, 18, this.imageW, this.imageH);
            int position = 0;
            position = 0;
            boolean retVal = this.putData(17, buffer, dataSize);
            if (!retVal) {
                return false;
            }
            retVal = this.putData(18, buffer, dataSize - (position += imageY_cnt));
            if (!retVal) {
                return false;
            }
            if (this.format == 151) {
                buffer.position(imageY_cnt);
            } else {
                position += imageU_cnt;
            }
            retVal = this.putData(19, buffer, dataSize - position);
            return retVal;
        }
        throw new IchNotSupportedException("The image format is not supported by icatchtek VR SDK");
    }

    public boolean putData(int key, ByteBuffer buffer, int dataSize) throws IchInvalidArgumentException {
        byte[] image;
        int image_cnt = this.calculateDataSize(this.format, key, this.imageW, this.imageH);
        if (image_cnt > dataSize + 1) {
            throw new IchInvalidArgumentException("The buffer does not contains enough data.");
        }
        if (image_cnt == dataSize + 1) {
            image_cnt = dataSize;
        }
        if ((image = this.imageData.get(key)) == null) {
            throw new IchInvalidArgumentException("Invalid key, not buffer bounded with image key: " + key);
        }
        buffer.get(image, 0, image_cnt);
        return true;
    }

    public byte[] getData(int key) throws IchInvalidArgumentException {
        byte[] image = this.imageData.get(key);
        if (image == null) {
            throw new IchInvalidArgumentException("Invalid key, not buffer bounded with image key: " + key);
        }
        return image;
    }

    public int getDataSize(int key) {
        return this.calculateDataSize(this.format, key, this.imageW, this.imageH);
    }

    private int calculateDataSize(int format, int imageKey, int imageW, int imageH) {
        double factor;
        if (format == 148 || format == 149) {
            return imageW * imageH * 4;
        }
        if (imageKey == 17) {
            return imageW * imageH;
        }
        double d = factor = format == 150 ? 0.25 : 0.5;
        if (imageKey == 18) {
            return (int)((double)(imageW * imageH) * factor);
        }
        if (imageKey == 19) {
            return (int)((double)(imageW * imageH) * factor);
        }
        return 0;
    }
}

