/*
 * Decompiled with CFR 0.152.
 */
package com.icatchtek.pancam.core.feature;

import android.graphics.Bitmap;
import com.icatchtek.pancam.core.feature.gles.ICatchPancamGL;
import com.icatchtek.pancam.core.jni.JPancamImage;
import com.icatchtek.pancam.customer.ICatchIPancamImage;
import com.icatchtek.pancam.customer.gl.ICatchIPancamGL;
import com.icatchtek.pancam.customer.stream.ICatchIStreamProvider;
import com.icatchtek.pancam.customer.surface.ICatchISurfaceContext;
import com.icatchtek.pancam.customer.type.ICatchGLImage;
import com.icatchtek.pancam.customer.type.ICatchGLImageRaw;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchPermissionDeniedException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class ICatchPancamImage
implements ICatchIPancamImage {
    private int sessionID;
    private ICatchPancamGL pancamGL;

    public ICatchPancamImage(int sessionID) {
        this.sessionID = sessionID;
    }

    public void releaseResource() {
        if (this.pancamGL != null) {
            this.pancamGL.releaseResource();
        }
    }

    @Override
    public boolean enableRender(ICatchISurfaceContext surfaceContext) {
        try {
            if (this.pancamGL != null) {
                try {
                    this.pancamGL.release();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.pancamGL.releaseResource();
            }
            return JPancamImage.enableRender_Jni(this.sessionID, surfaceContext.getSurfaceID());
        }
        catch (IchInvalidSessionException e) {
            e.printStackTrace();
        }
        catch (IchInvalidArgumentException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public ICatchIPancamGL enableGLRender() {
        return this.enableGLRender(1);
    }

    @Override
    public ICatchIPancamGL enableGLRender(int panoramaType) {
        if (this.pancamGL != null) {
            try {
                this.pancamGL.release();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pancamGL.releaseResource();
            this.pancamGL = null;
        }
        try {
            int pancamGLID = JPancamImage.enableGLRender_Jni(this.sessionID, panoramaType);
            if (pancamGLID >= 0) {
                this.pancamGL = new ICatchPancamGL(pancamGLID);
            }
        }
        catch (IchInvalidSessionException e) {
            e.printStackTrace();
        }
        catch (IchInvalidArgumentException e) {
            e.printStackTrace();
        }
        return this.pancamGL;
    }

    @Override
    public ICatchIStreamProvider disableRender() throws IchInvalidSessionException, IchPermissionDeniedException {
        throw new IchPermissionDeniedException("this operation not supported.");
    }

    @Override
    public boolean update(ICatchGLImage image) throws IchInvalidArgumentException {
        return this.update(image, 0.0f);
    }

    @Override
    public boolean update(ICatchGLImage image, float pitchValue) throws IchInvalidArgumentException {
        if (image == null || image.getPicture() == null) {
            throw new IchInvalidArgumentException("The image should not null.");
        }
        Bitmap source = image.getPicture();
        int bytes = source.getByteCount();
        ByteBuffer buffer = ByteBuffer.allocate(bytes);
        source.copyPixelsToBuffer((Buffer)buffer);
        byte[] array = buffer.array();
        int dataSize = source.getWidth() * source.getHeight() * 4;
        return JPancamImage.update_Jni(this.sessionID, 149, source.getWidth(), source.getHeight(), array, dataSize, pitchValue);
    }

    @Override
    public boolean update(ICatchGLImageRaw imageRaw) throws IchInvalidArgumentException {
        return this.update(imageRaw, 0.0f);
    }

    @Override
    public boolean update(ICatchGLImageRaw imageRaw, float pitchValue) throws IchInvalidArgumentException {
        if (imageRaw == null) {
            throw new IchInvalidArgumentException("The image should not null.");
        }
        int dataSize = imageRaw.getImageW() * imageRaw.getImageH() * 4;
        return JPancamImage.update_Jni(this.sessionID, imageRaw.getFormat(), imageRaw.getImageW(), imageRaw.getImageH(), imageRaw.getBuffer(), dataSize, pitchValue);
    }

    @Override
    public boolean clear() {
        return JPancamImage.clear_Jni(this.sessionID);
    }
}

